/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.corespi.scanner.xbean;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.xbean.finder.archive.Archive;
import org.apache.xbean.finder.archive.ClassesArchive;
import org.apache.xbean.finder.archive.ClasspathArchive;
import org.apache.xbean.finder.archive.CompositeArchive;
import org.apache.xbean.finder.archive.FilteredArchive;
import org.apache.xbean.finder.filter.Filter;

public class CdiArchive
implements Archive {
    private final Map<URL, Collection<String>> map = new HashMap<URL, Collection<String>>();
    private final Set<String> classes = new HashSet<String>();
    private final Archive delegate;

    public CdiArchive(ClassLoader loader, Iterable<URL> urls) {
        ArrayList<FilteredArchive> archives = new ArrayList<FilteredArchive>();
        for (URL url : urls) {
            final ArrayList classes = new ArrayList();
            FilteredArchive archive = new FilteredArchive(ClasspathArchive.archive((ClassLoader)loader, (URL)url), new Filter(){

                public boolean accept(String name) {
                    classes.add(name);
                    CdiArchive.this.classes.add(name);
                    return true;
                }
            });
            this.map.put(url, classes);
            archives.add(archive);
        }
        this.delegate = new CompositeArchive(archives);
    }

    public CdiArchive(Collection<Class<?>> classList) {
        this.delegate = new FilteredArchive((Archive)new ClassesArchive(classList), new Filter(){

            public boolean accept(String name) {
                CdiArchive.this.classes.add(name);
                return true;
            }
        });
    }

    public Set<String> getClasses() {
        return this.classes;
    }

    public Map<URL, Collection<String>> classesByUrl() {
        return this.map;
    }

    public InputStream getBytecode(String className) throws IOException, ClassNotFoundException {
        return this.delegate.getBytecode(className);
    }

    public Class<?> loadClass(String className) throws ClassNotFoundException {
        return this.delegate.loadClass(className);
    }

    public Iterator<Archive.Entry> iterator() {
        return this.delegate.iterator();
    }
}

