/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.container;

import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.el.ELResolver;
import javax.el.ExpressionFactory;
import javax.enterprise.context.ContextNotActiveException;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.NormalScope;
import javax.enterprise.context.spi.Context;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.Stereotype;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Decorator;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.InjectionTarget;
import javax.enterprise.inject.spi.InterceptionType;
import javax.enterprise.inject.spi.Interceptor;
import javax.enterprise.inject.spi.ObserverMethod;
import javax.enterprise.inject.spi.PassivationCapable;
import javax.enterprise.inject.spi.Producer;
import javax.inject.Scope;
import javax.interceptor.InterceptorBinding;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import org.apache.webbeans.component.AbstractOwbBean;
import org.apache.webbeans.component.EnterpriseBeanMarker;
import org.apache.webbeans.component.JmsBeanMarker;
import org.apache.webbeans.component.ManagedBean;
import org.apache.webbeans.component.NewBean;
import org.apache.webbeans.component.OwbBean;
import org.apache.webbeans.component.third.PassivationCapableThirdpartyBeanImpl;
import org.apache.webbeans.component.third.ThirdpartyBeanImpl;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.container.AbstractBeanManager;
import org.apache.webbeans.container.ExternalScope;
import org.apache.webbeans.container.InjectionResolver;
import org.apache.webbeans.container.ManagerObjectFactory;
import org.apache.webbeans.container.SerializableBean;
import org.apache.webbeans.context.creational.CreationalContextImpl;
import org.apache.webbeans.decorator.DecoratorComparator;
import org.apache.webbeans.event.EventMetadata;
import org.apache.webbeans.event.EventMetadataImpl;
import org.apache.webbeans.event.NotificationManager;
import org.apache.webbeans.exception.WebBeansConfigurationException;
import org.apache.webbeans.exception.definition.DuplicateDefinitionException;
import org.apache.webbeans.exception.inject.DefinitionException;
import org.apache.webbeans.plugins.OpenWebBeansJmsPlugin;
import org.apache.webbeans.portable.AnnotatedElementFactory;
import org.apache.webbeans.portable.InjectionTargetImpl;
import org.apache.webbeans.portable.events.discovery.ErrorStack;
import org.apache.webbeans.spi.adaptor.ELAdaptor;
import org.apache.webbeans.spi.plugins.OpenWebBeansEjbPlugin;
import org.apache.webbeans.util.AnnotationUtil;
import org.apache.webbeans.util.Asserts;
import org.apache.webbeans.util.ClassUtil;
import org.apache.webbeans.util.WebBeansUtil;
import org.apache.webbeans.xml.WebBeansXMLConfigurator;

public class BeanManagerImpl
extends AbstractBeanManager
implements BeanManager,
Referenceable {
    private static final long serialVersionUID = 2L;
    private Map<Class<? extends Annotation>, List<Context>> contextMap = new HashMap<Class<? extends Annotation>, List<Context>>();
    private Map<Class<? extends Annotation>, Context> singleContextMap = new HashMap<Class<? extends Annotation>, Context>();
    private Set<Bean<?>> deploymentBeans = new CopyOnWriteArraySet();
    private Map<Contextual<?>, Object> cacheProxies = new ConcurrentHashMap();
    private NotificationManager notificationManager = null;
    private InjectionResolver injectionResolver = null;
    private WebBeansXMLConfigurator xmlConfigurator = null;
    private List<Class<? extends Annotation>> additionalQualifiers = new ArrayList<Class<? extends Annotation>>();
    private List<Class<? extends Annotation>> additionalInterceptorBindings = new ArrayList<Class<? extends Annotation>>();
    private List<ExternalScope> additionalScopes = new ArrayList<ExternalScope>();
    private ConcurrentMap<Class<?>, ConcurrentMap<String, AnnotatedType<?>>> additionalAnnotatedTypes = new ConcurrentHashMap();
    private ErrorStack errorStack = new ErrorStack();
    private ConcurrentMap<String, Bean<?>> passivationBeans = new ConcurrentHashMap();
    private Map<Class<?>, Producer<?>> producersForJavaEeComponents = new ConcurrentHashMap();
    private AnnotatedElementFactory annotatedElementFactory;
    private final WebBeansContext webBeansContext;
    private boolean inUse = false;
    private static Map<Class<? extends Annotation>, Boolean> isScopeTypeNormalCache = new ConcurrentHashMap<Class<? extends Annotation>, Boolean>();

    public BeanManagerImpl(WebBeansContext webBeansContext) {
        this.webBeansContext = webBeansContext;
        this.injectionResolver = new InjectionResolver(webBeansContext);
        this.notificationManager = new NotificationManager(webBeansContext);
        this.annotatedElementFactory = webBeansContext.getAnnotatedElementFactory();
    }

    @Override
    public WebBeansContext getWebBeansContext() {
        return this.webBeansContext;
    }

    public <T> void putProducerForJavaEeComponent(Class<T> javaEeComponentClass, Producer<T> wrapper) {
        Asserts.assertNotNull(javaEeComponentClass);
        Asserts.assertNotNull(wrapper);
        this.producersForJavaEeComponents.put(javaEeComponentClass, wrapper);
    }

    public <T> Producer<T> getProducerForJavaEeComponent(Class<T> javaEeComponentClass) {
        Asserts.assertNotNull(javaEeComponentClass);
        return this.producersForJavaEeComponents.get(javaEeComponentClass);
    }

    public ErrorStack getErrorStack() {
        return this.errorStack;
    }

    public NotificationManager getNotificationManager() {
        return this.notificationManager;
    }

    public InjectionResolver getInjectionResolver() {
        return this.injectionResolver;
    }

    public synchronized void setXMLConfigurator(WebBeansXMLConfigurator xmlConfigurator) {
        if (this.xmlConfigurator != null) {
            throw new IllegalStateException("WebBeansXMLConfigurator is already defined!");
        }
        this.xmlConfigurator = xmlConfigurator;
    }

    public Context getContext(Class<? extends Annotation> scopeType) {
        Asserts.assertNotNull(scopeType, "scopeType parameter can not be null");
        Context standardContext = this.webBeansContext.getContextsService().getCurrentContext(scopeType);
        if (standardContext != null && standardContext.isActive()) {
            return standardContext;
        }
        Context singleContext = this.singleContextMap.get(scopeType);
        if (singleContext != null) {
            if (!singleContext.isActive()) {
                throw new ContextNotActiveException("WebBeans context with scope type annotation @" + scopeType.getSimpleName() + " does not exist within current thread");
            }
            return singleContext;
        }
        List<Context> others = this.contextMap.get(scopeType);
        Context found = null;
        if (others != null) {
            for (Context otherContext : others) {
                if (!otherContext.isActive()) continue;
                if (found != null) {
                    throw new IllegalStateException("More than one active context exists with scope type annotation @" + scopeType.getSimpleName());
                }
                found = otherContext;
            }
        }
        if (found == null) {
            throw new ContextNotActiveException("WebBeans context with scope type annotation @" + scopeType.getSimpleName() + " does not exist within current thread");
        }
        return found;
    }

    public BeanManager addBean(Bean<?> newBean) {
        this.inUse = true;
        return this.addInternalBean(newBean);
    }

    public <T> BeanManager addInternalBean(Bean<T> newBean) {
        if (newBean instanceof AbstractOwbBean) {
            this.addPassivationInfo((OwbBean)newBean);
            this.deploymentBeans.add(newBean);
        } else {
            ThirdpartyBeanImpl<T> bean = !PassivationCapable.class.isInstance(newBean) ? new ThirdpartyBeanImpl<T>(this.webBeansContext, newBean) : new PassivationCapableThirdpartyBeanImpl<T>(this.webBeansContext, newBean);
            this.addPassivationInfo(bean);
            this.deploymentBeans.add(bean);
        }
        return this;
    }

    public void addPassivationInfo(Bean<?> bean) throws DefinitionException {
        Bean<?> oldBean;
        String id = null;
        if (bean instanceof OwbBean) {
            id = ((OwbBean)bean).getId();
        }
        if (id == null && bean instanceof PassivationCapable) {
            id = ((PassivationCapable)bean).getId();
        }
        if (id != null && (oldBean = this.passivationBeans.putIfAbsent(id, bean)) != null) {
            throw new DuplicateDefinitionException("PassivationCapable bean id is not unique: " + id + " bean:" + bean);
        }
    }

    public BeanManager addContext(Context context) {
        this.addContext(context.getScope(), this.webBeansContext.getContextFactory().getCustomContext(context));
        return this;
    }

    public void fireEvent(Object event, Annotation ... bindings) {
        this.fireEvent(event, new EventMetadataImpl(event.getClass(), null, bindings));
    }

    public void fireEvent(Object event, EventMetadata metadata) {
        if (ClassUtil.isDefinitionContainsTypeVariables(event.getClass())) {
            throw new IllegalArgumentException("Event class : " + event.getClass().getName() + " can not be defined as generic type");
        }
        this.notificationManager.fireEvent(event, metadata);
    }

    public Set<Bean<?>> getComponents() {
        return this.deploymentBeans;
    }

    public List<Decorator<?>> resolveDecorators(Set<Type> types, Annotation ... bindingTypes) {
        this.webBeansContext.getAnnotationManager().checkDecoratorResolverParams(types, bindingTypes);
        Set<Decorator<?>> intsSet = this.webBeansContext.getDecoratorsManager().findDeployedWebBeansDecorator(types, bindingTypes);
        ArrayList decoratorList = new ArrayList(intsSet);
        Collections.sort(decoratorList, new DecoratorComparator(this.webBeansContext));
        return decoratorList;
    }

    public List<Interceptor<?>> resolveInterceptors(InterceptionType type, Annotation ... interceptorBindings) {
        this.webBeansContext.getAnnotationManager().checkInterceptorResolverParams(interceptorBindings);
        return this.webBeansContext.getInterceptorsManager().resolveInterceptors(type, interceptorBindings);
    }

    public Set<Bean<?>> getBeans() {
        return this.deploymentBeans;
    }

    private void addContext(Class<? extends Annotation> scopeType, Context context) {
        Asserts.assertNotNull(scopeType, "scopeType parameter can not be null");
        Asserts.assertNotNull(context, "context parameter can not be null");
        List<Context> contextList = this.contextMap.get(scopeType);
        if (contextList == null) {
            Context singleContext = this.singleContextMap.get(scopeType);
            if (singleContext == null) {
                this.singleContextMap.put(scopeType, context);
            } else {
                contextList = new ArrayList<Context>();
                contextList.add(singleContext);
                contextList.add(context);
                this.contextMap.put(scopeType, contextList);
                this.singleContextMap.remove(scopeType);
            }
        } else {
            contextList.add(context);
        }
    }

    @Override
    public Reference getReference() throws NamingException {
        return new Reference(BeanManagerImpl.class.getName(), new StringRefAddr("ManagerImpl", "ManagerImpl"), ManagerObjectFactory.class.getName(), null);
    }

    public BeanManager parse(InputStream xmlStream) {
        this.xmlConfigurator.configure(xmlStream);
        return this;
    }

    public <T> AnnotatedType<T> createAnnotatedType(Class<T> type) {
        AnnotatedType<T> annotatedType = this.annotatedElementFactory.newAnnotatedType(type);
        return annotatedType;
    }

    public <T> CreationalContextImpl<T> createCreationalContext(Contextual<T> contextual) {
        if (contextual instanceof SerializableBean) {
            contextual = ((SerializableBean)contextual).getBean();
        }
        return this.webBeansContext.getCreationalContextFactory().getCreationalContext(contextual);
    }

    public Set<Bean<?>> getBeans(Type beanType, Annotation ... bindings) {
        if (ClassUtil.isTypeVariable(beanType)) {
            throw new IllegalArgumentException("Exception in getBeans method. Bean type can not be TypeVariable for bean type : " + beanType);
        }
        this.webBeansContext.getAnnotationManager().checkQualifierConditions(bindings);
        return this.injectionResolver.implResolveByType(beanType, bindings);
    }

    public Set<Bean<?>> getBeans(String name) {
        Asserts.assertNotNull(name, "name parameter can not be null");
        return this.injectionResolver.implResolveByName(name);
    }

    public ELResolver getELResolver() {
        ELAdaptor elAdaptor = this.webBeansContext.getService(ELAdaptor.class);
        return elAdaptor.getOwbELResolver();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getInjectableReference(InjectionPoint injectionPoint, CreationalContext<?> ownerCreationalContext) {
        Asserts.assertNotNull(injectionPoint, "injectionPoint parameter can not be null");
        Object instance = null;
        if (injectionPoint == null) {
            return null;
        }
        Bean<?> injectedBean = this.injectionResolver.getInjectionPointBean(injectionPoint);
        if (WebBeansUtil.isDependent(injectedBean)) {
            if (!(ownerCreationalContext instanceof CreationalContextImpl)) {
                ownerCreationalContext = this.webBeansContext.getCreationalContextFactory().wrappedCreationalContext(ownerCreationalContext, injectionPoint.getBean());
            }
            ((CreationalContextImpl)ownerCreationalContext).putInjectionPoint(injectionPoint);
            try {
                instance = this.getReference(injectedBean, injectionPoint.getType(), ownerCreationalContext);
            }
            finally {
                ((CreationalContextImpl)ownerCreationalContext).removeInjectionPoint();
            }
        }
        CreationalContext injectedCreational = this.createCreationalContext((Contextual)injectedBean);
        injectedCreational.putInjectionPoint(injectionPoint);
        try {
            instance = this.getReference(injectedBean, injectionPoint.getType(), injectedCreational);
        }
        finally {
            injectedCreational.removeInjectionPoint();
        }
        return instance;
    }

    public Set<Annotation> getInterceptorBindingDefinition(Class<? extends Annotation> binding) {
        Annotation[] annotations = binding.getDeclaredAnnotations();
        HashSet<Annotation> set = new HashSet<Annotation>();
        if (binding.isAnnotationPresent(InterceptorBinding.class)) {
            Collections.addAll(set, annotations);
        }
        return set;
    }

    public Bean<?> getPassivationCapableBean(String id) {
        return (Bean)this.passivationBeans.get(id);
    }

    public Object getReference(Bean<?> bean, Type beanType, CreationalContext<?> creationalContext) {
        Asserts.assertNotNull(bean, "bean parameter can not be null");
        Context context = null;
        Object instance = null;
        if (bean instanceof SerializableBean) {
            bean = ((SerializableBean)bean).getBean();
        }
        if (!(creationalContext instanceof CreationalContextImpl)) {
            creationalContext = this.webBeansContext.getCreationalContextFactory().wrappedCreationalContext(creationalContext, bean);
        }
        if (beanType != null && !this.isBeanTypeAssignableToGivenType(bean.getTypes(), beanType, bean instanceof NewBean) && !ClassUtil.isAssignable(bean.getBeanClass(), beanType)) {
            throw new IllegalArgumentException("Given bean type : " + beanType + " is not applicable for the bean instance : " + bean);
        }
        if (this.isNormalScope(bean.getScope())) {
            instance = this.getEjbOrJmsProxyReference((Bean<?>)bean, beanType, creationalContext);
            if (instance != null) {
                return instance;
            }
            instance = this.cacheProxies.get(bean);
            if (instance == null) {
                instance = this.webBeansContext.getNormalScopeProxyFactory().createNormalScopeProxy(bean);
                this.cacheProxies.put((Contextual<?>)bean, instance);
            }
        } else {
            context = this.getContext(bean.getScope());
            instance = this.getEjbOrJmsProxyReference((Bean<?>)bean, beanType, creationalContext);
            if (instance != null) {
                return instance;
            }
            instance = context.get(bean, creationalContext);
        }
        return instance;
    }

    private boolean isBeanTypeAssignableToGivenType(Set<Type> beanTypes, Type givenType, boolean newBean) {
        for (Type beanApiType : beanTypes) {
            Class<?> requiredType;
            if (ClassUtil.isAssignable(beanApiType, givenType)) {
                return true;
            }
            if (!newBean || !ClassUtil.isParametrizedType(givenType) || !ClassUtil.isClassAssignable(requiredType = ClassUtil.getClass(givenType), ClassUtil.getClass(beanApiType))) continue;
            return true;
        }
        return false;
    }

    private Object getEjbOrJmsProxyReference(Bean<?> bean, Type beanType, CreationalContext<?> creationalContext) {
        if (bean instanceof EnterpriseBeanMarker) {
            if (this.isNormalScope(bean.getScope()) && this.cacheProxies.containsKey(bean)) {
                return this.cacheProxies.get(bean);
            }
            OpenWebBeansEjbPlugin ejbPlugin = this.webBeansContext.getPluginLoader().getEjbPlugin();
            if (ejbPlugin == null) {
                throw new IllegalStateException("There is no EJB plugin provider. Injection is failed for bean : " + bean);
            }
            return ejbPlugin.getSessionBeanProxy(bean, ClassUtil.getClazz(beanType), creationalContext);
        }
        if (bean instanceof JmsBeanMarker) {
            OpenWebBeansJmsPlugin jmsPlugin = this.webBeansContext.getPluginLoader().getJmsPlugin();
            if (jmsPlugin == null) {
                throw new IllegalStateException("There is no JMS plugin provider. Injection is failed for bean : " + bean);
            }
            return jmsPlugin.getJmsBeanProxy(bean, ClassUtil.getClass(beanType));
        }
        return null;
    }

    public Set<Annotation> getStereotypeDefinition(Class<? extends Annotation> stereotype) {
        Annotation[] annotations = stereotype.getDeclaredAnnotations();
        HashSet<Annotation> set = new HashSet<Annotation>();
        if (stereotype.isAnnotationPresent(Stereotype.class)) {
            Collections.addAll(set, annotations);
        }
        return set;
    }

    public boolean isQualifier(Class<? extends Annotation> annotationType) {
        return this.webBeansContext.getAnnotationManager().isQualifierAnnotation(annotationType);
    }

    public boolean isInterceptorBinding(Class<? extends Annotation> annotationType) {
        return this.webBeansContext.getAnnotationManager().isInterceptorBindingAnnotation(annotationType);
    }

    public boolean isScope(Class<? extends Annotation> annotationType) {
        if (AnnotationUtil.hasAnnotation(annotationType.getDeclaredAnnotations(), Scope.class) || AnnotationUtil.hasAnnotation(annotationType.getDeclaredAnnotations(), NormalScope.class)) {
            return true;
        }
        for (ExternalScope ext : this.additionalScopes) {
            if (!ext.getScope().equals(annotationType)) continue;
            return true;
        }
        return false;
    }

    public boolean isNormalScope(Class<? extends Annotation> scopeType) {
        Boolean isNormal = isScopeTypeNormalCache.get(scopeType);
        if (isNormal != null) {
            return isNormal;
        }
        for (ExternalScope extScope : this.additionalScopes) {
            if (!extScope.getScope().equals(scopeType)) continue;
            isScopeTypeNormalCache.put(scopeType, extScope.isNormal());
            return extScope.isNormal();
        }
        isNormal = scopeType.getAnnotation(NormalScope.class) != null;
        isScopeTypeNormalCache.put(scopeType, isNormal);
        return isNormal;
    }

    public boolean isPassivatingScope(Class<? extends Annotation> annotationType) {
        for (ExternalScope extScope : this.additionalScopes) {
            if (!extScope.getScope().equals(annotationType)) continue;
            return extScope.isPassivating();
        }
        NormalScope scope = annotationType.getAnnotation(NormalScope.class);
        if (scope != null) {
            return scope.passivating();
        }
        return false;
    }

    public boolean isStereotype(Class<? extends Annotation> annotationType) {
        return AnnotationUtil.hasAnnotation(annotationType.getDeclaredAnnotations(), Stereotype.class);
    }

    public <X> Bean<? extends X> resolve(Set<Bean<? extends X>> beans) {
        return this.injectionResolver.resolve(beans);
    }

    public void validate(InjectionPoint injectionPoint) {
        Bean bean = injectionPoint.getBean();
        this.injectionResolver.checkInjectionPointType(injectionPoint);
        Class<?> rawType = ClassUtil.getRawTypeForInjectionPoint(injectionPoint);
        if (rawType.equals(InjectionPoint.class)) {
            if (AnnotationUtil.hasAnnotation(AnnotationUtil.asArray(injectionPoint.getQualifiers()), Default.class) && !bean.getScope().equals(Dependent.class)) {
                throw new WebBeansConfigurationException("Bean " + bean.getBeanClass() + " scope can not define other scope except @Dependent to inject InjectionPoint");
            }
        } else {
            this.injectionResolver.checkInjectionPoints(injectionPoint);
        }
    }

    public <T> InjectionTarget<T> createInjectionTarget(AnnotatedType<T> type) {
        ManagedBean<T> bean = this.webBeansContext.getWebBeansUtil().defineManagedBean(type);
        if (bean == null) {
            throw new DefinitionException("Could not create InjectionTargetBean for type " + type.getJavaClass());
        }
        List<AnnotatedMethod<?>> postConstructMethods = this.webBeansContext.getInterceptorUtil().getLifecycleMethods(bean.getAnnotatedType(), PostConstruct.class, true);
        List<AnnotatedMethod<?>> preDestroyMethods = this.webBeansContext.getInterceptorUtil().getLifecycleMethods(bean.getAnnotatedType(), PreDestroy.class, false);
        return new InjectionTargetImpl(bean.getAnnotatedType(), bean.getInjectionPoints(), this.webBeansContext, postConstructMethods, preDestroyMethods);
    }

    public <T> Set<ObserverMethod<? super T>> resolveObserverMethods(T event, Annotation ... qualifiers) {
        return this.resolveObserverMethods(event, new EventMetadataImpl(event.getClass(), null, qualifiers));
    }

    public <T> Set<ObserverMethod<? super T>> resolveObserverMethods(T event, EventMetadata metadata) {
        if (ClassUtil.isDefinitionContainsTypeVariables(ClassUtil.getClass(metadata.getType()))) {
            throw new IllegalArgumentException("Event type can not contain type variables. Event class is : " + event.getClass());
        }
        return this.notificationManager.resolveObservers(event, metadata);
    }

    public ExpressionFactory wrapExpressionFactory(ExpressionFactory expressionFactory) {
        ELAdaptor elAdaptor = this.webBeansContext.getService(ELAdaptor.class);
        return elAdaptor.getOwbWrappedExpressionFactory(expressionFactory);
    }

    public void addAdditionalQualifier(Class<? extends Annotation> qualifier) {
        if (!this.additionalQualifiers.contains(qualifier)) {
            this.additionalQualifiers.add(qualifier);
        }
    }

    public void addAdditionalInterceptorBindings(Class<? extends Annotation> interceptorBinding) {
        if (!this.additionalInterceptorBindings.contains(interceptorBinding)) {
            this.additionalInterceptorBindings.add(interceptorBinding);
        }
    }

    public void addAdditionalAnnotatedType(AnnotatedType<?> annotatedType) {
        this.addAdditionalAnnotatedType(annotatedType, "OWB_DEFAULT_KEY");
    }

    public void addAdditionalAnnotatedType(AnnotatedType<?> annotatedType, String id) {
        this.webBeansContext.getAnnotatedElementFactory().setAnnotatedType(annotatedType, id);
        ConcurrentMap<String, Object> annotatedTypes = (ConcurrentHashMap)this.additionalAnnotatedTypes.get(annotatedType.getJavaClass());
        if (annotatedTypes == null) {
            annotatedTypes = new ConcurrentHashMap();
            ConcurrentMap oldAnnotatedTypes = this.additionalAnnotatedTypes.putIfAbsent(annotatedType.getJavaClass(), annotatedTypes);
            if (oldAnnotatedTypes != null) {
                annotatedTypes = oldAnnotatedTypes;
            }
        }
        annotatedTypes.put(id, annotatedType);
    }

    public void removeAdditionalAnnotatedType(AnnotatedType<?> annotatedType) {
        this.removeAdditionalAnnotatedType(annotatedType, "OWB_DEFAULT_KEY");
    }

    public void removeAdditionalAnnotatedType(AnnotatedType<?> annotatedType, String id) {
        ConcurrentMap annotatedTypes = (ConcurrentMap)this.additionalAnnotatedTypes.get(annotatedType.getJavaClass());
        if (annotatedTypes == null) {
            return;
        }
        if (annotatedType.equals(annotatedTypes.get(id))) {
            annotatedTypes.remove(id);
        }
    }

    public List<Class<? extends Annotation>> getAdditionalQualifiers() {
        return this.additionalQualifiers;
    }

    public void addAdditionalScope(ExternalScope additionalScope) {
        if (!this.additionalScopes.contains(additionalScope)) {
            this.additionalScopes.add(additionalScope);
        }
    }

    public List<ExternalScope> getAdditionalScopes() {
        return this.additionalScopes;
    }

    public Collection<AnnotatedType<?>> getAdditionalAnnotatedTypes() {
        ArrayList annotatedTypes = new ArrayList();
        for (ConcurrentMap types : this.additionalAnnotatedTypes.values()) {
            annotatedTypes.addAll(types.values());
        }
        return annotatedTypes;
    }

    public <T> AnnotatedType<T> getAdditionalAnnotatedType(Class<T> type, String id) {
        ConcurrentMap annotatedTypes = (ConcurrentMap)this.additionalAnnotatedTypes.get(type);
        if (annotatedTypes == null) {
            return null;
        }
        return (AnnotatedType)annotatedTypes.get(id);
    }

    public void clear() {
        this.additionalAnnotatedTypes.clear();
        this.additionalQualifiers.clear();
        this.additionalScopes.clear();
        this.clearCacheProxies();
        this.singleContextMap.clear();
        this.contextMap.clear();
        this.deploymentBeans.clear();
        this.errorStack.clear();
        this.producersForJavaEeComponents.clear();
        this.passivationBeans.clear();
        this.webBeansContext.getInterceptorsManager().clear();
        this.webBeansContext.getDecoratorsManager().clear();
    }

    public void clearCacheProxies() {
        this.cacheProxies.clear();
    }

    public boolean isInUse() {
        return this.inUse;
    }
}

