/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.component.creation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Set;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.InterceptionType;
import org.apache.webbeans.component.BeanAttributesImpl;
import org.apache.webbeans.component.CdiInterceptorBean;
import org.apache.webbeans.component.creation.InterceptorBeanBuilder;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.exception.WebBeansConfigurationException;
import org.apache.webbeans.util.ArrayUtil;

public class CdiInterceptorBeanBuilder<T>
extends InterceptorBeanBuilder<T, CdiInterceptorBean<T>> {
    private Set<Annotation> interceptorBindings;

    public CdiInterceptorBeanBuilder(WebBeansContext webBeansContext, AnnotatedType<T> annotatedType, BeanAttributesImpl<T> beanAttributes) {
        super(webBeansContext, annotatedType, beanAttributes);
    }

    public void defineCdiInterceptorRules() {
        this.checkInterceptorConditions();
        this.defineInterceptorMethods();
        this.defineInterceptorBindings();
    }

    @Override
    public boolean isInterceptorEnabled() {
        return this.webBeansContext.getInterceptorsManager().isInterceptorClassEnabled(this.annotatedType.getJavaClass());
    }

    protected void defineInterceptorBindings() {
        Annotation[] bindings = this.webBeansContext.getAnnotationManager().getInterceptorBindingMetaAnnotations(this.annotatedType.getAnnotations());
        if (bindings == null || bindings.length == 0) {
            throw new WebBeansConfigurationException("WebBeans Interceptor class : " + this.annotatedType.getJavaClass() + " must have at least one @InterceptorBinding annotation");
        }
        this.interceptorBindings = ArrayUtil.asSet(bindings);
    }

    @Override
    protected CdiInterceptorBean<T> createBean(Class<T> beanClass, boolean enabled, Map<InterceptionType, Method[]> interceptionMethods) {
        return new CdiInterceptorBean<T>(this.webBeansContext, this.annotatedType, this.beanAttributes, beanClass, this.interceptorBindings, enabled, interceptionMethods);
    }
}

