/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.lifecycle;

import java.lang.annotation.Annotation;
import java.util.Properties;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.spi.BeanManager;
import org.apache.webbeans.config.BeansDeployer;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.config.WebBeansFinder;
import org.apache.webbeans.container.BeanManagerImpl;
import org.apache.webbeans.container.InjectionResolver;
import org.apache.webbeans.logger.WebBeansLogger;
import org.apache.webbeans.portable.events.discovery.BeforeShutdownImpl;
import org.apache.webbeans.spi.ContainerLifecycle;
import org.apache.webbeans.spi.ContextsService;
import org.apache.webbeans.spi.JNDIService;
import org.apache.webbeans.spi.ScannerService;
import org.apache.webbeans.util.WebBeansUtil;
import org.apache.webbeans.xml.WebBeansXMLConfigurator;

public abstract class AbstractLifeCycle
implements ContainerLifecycle {
    protected WebBeansLogger logger;
    protected ScannerService scannerService;
    protected final ContextsService contextsService;
    private final BeansDeployer deployer;
    private final WebBeansXMLConfigurator xmlDeployer;
    private final JNDIService jndiService;
    private final BeanManagerImpl beanManager;
    protected final WebBeansContext webBeansContext;

    protected AbstractLifeCycle() {
        this(null);
    }

    protected AbstractLifeCycle(Properties properties) {
        this.beforeInitApplication(properties);
        this.webBeansContext = WebBeansContext.getInstance();
        this.beanManager = this.webBeansContext.getBeanManagerImpl();
        this.xmlDeployer = new WebBeansXMLConfigurator();
        this.deployer = new BeansDeployer(this.xmlDeployer, this.webBeansContext);
        this.jndiService = this.webBeansContext.getService(JNDIService.class);
        this.beanManager.setXMLConfigurator(this.xmlDeployer);
        this.scannerService = this.webBeansContext.getScannerService();
        this.contextsService = this.webBeansContext.getService(ContextsService.class);
        this.initApplication(properties);
    }

    public WebBeansContext getWebBeansContext() {
        return this.webBeansContext;
    }

    public BeanManager getBeanManager() {
        return this.beanManager;
    }

    public void startApplication(Object startupObject) {
        this.logger.info("INFO_0005");
        long begin = System.currentTimeMillis();
        this.beforeStartApplication(startupObject);
        this.webBeansContext.getPluginLoader().startUp();
        this.contextsService.init(startupObject);
        this.logger.debug("Scanning classpaths for beans artifacts.");
        this.scannerService.scan();
        this.logger.debug("Deploying scanned beans.");
        this.deployer.deploy(this.scannerService);
        this.afterStartApplication(startupObject);
        this.logger.info("INFO_0001", Long.toString(System.currentTimeMillis() - begin));
    }

    public void stopApplication(Object endObject) {
        this.logger.debug("OpenWebBeans Container is stopping.");
        try {
            this.beforeStopApplication(endObject);
            this.contextsService.startContext(ApplicationScoped.class, endObject);
            this.beanManager.fireEvent(new BeforeShutdownImpl(), new Annotation[0]);
            this.contextsService.destroy(endObject);
            this.jndiService.unbind("java:comp/BeanManager");
            this.webBeansContext.getPluginLoader().shutDown();
            this.webBeansContext.getExtensionLoader().clear();
            InjectionResolver injectionResolver = this.webBeansContext.getBeanManagerImpl().getInjectionResolver();
            injectionResolver.clearCaches();
            this.webBeansContext.getJavassistProxyFactory().clear();
            this.webBeansContext.getAnnotatedElementFactory().clear();
            this.webBeansContext.getjMSManager().clear();
            this.afterStopApplication(endObject);
            this.beanManager.clear();
            WebBeansFinder.clearInstances(WebBeansUtil.getCurrentClassLoader());
        }
        catch (Exception e) {
            this.logger.error("ERROR_0021", e);
        }
    }

    protected WebBeansLogger getLogger() {
        return this.logger;
    }

    public ContextsService getContextService() {
        return this.contextsService;
    }

    public void initApplication(Properties properties) {
        this.afterInitApplication(properties);
    }

    protected void beforeInitApplication(Properties properties) {
    }

    protected void afterInitApplication(Properties properties) {
    }

    protected void afterStartApplication(Object startupObject) {
    }

    protected void afterStopApplication(Object stopObject) {
    }

    protected void beforeStartApplication(Object startupObject) {
    }

    protected void beforeStopApplication(Object stopObject) {
    }
}

