/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.decorator;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import javassist.util.proxy.MethodHandler;
import javax.interceptor.InvocationContext;
import org.apache.webbeans.component.EnterpriseBeanMarker;
import org.apache.webbeans.component.OwbBean;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.exception.WebBeansException;
import org.apache.webbeans.logger.WebBeansLogger;
import org.apache.webbeans.util.WebBeansUtil;

public class DelegateHandler
implements MethodHandler,
Serializable,
Externalizable {
    private transient WebBeansLogger logger = WebBeansLogger.getLogger(DelegateHandler.class);
    private transient List<Object> decorators;
    private transient int position = 0;
    private transient Object actualBean = null;
    private transient OwbBean<?> bean = null;
    private transient InvocationContext ejbContext;

    public DelegateHandler() {
        this.logger = WebBeansLogger.getLogger(DelegateHandler.class);
    }

    public DelegateHandler(OwbBean<?> bean) {
        this.bean = bean;
    }

    public DelegateHandler(OwbBean<?> bean, InvocationContext ejbContext) {
        this.bean = bean;
        this.ejbContext = ejbContext;
    }

    public Object invoke(Object instance, Method method, Method proceed, Object[] arguments) throws Exception {
        if (this.actualBean == null) {
            this.actualBean = instance;
        }
        while (this.position < this.decorators.size()) {
            Object decorator = this.decorators.get(this.position++);
            try {
                Method decMethod = decorator.getClass().getMethod(method.getName(), method.getParameterTypes());
                boolean methodInInterface = this.checkForMethodInInterfaces(decorator.getClass(), method);
                if (decMethod == null || !methodInInterface) continue;
                if (!decMethod.isAccessible()) {
                    this.bean.getWebBeansContext().getSecurityService().doPrivilegedSetAccessible((AccessibleObject)decMethod, true);
                }
                Object returnValue = decMethod.invoke(decorator, arguments);
                --this.position;
                return returnValue;
            }
            catch (SecurityException e) {
                this.logger.error("ERROR_0011", method.getName(), decorator.getClass().getName());
                throw new WebBeansException(e);
            }
            catch (NoSuchMethodException e) {
            }
            catch (InvocationTargetException e) {
                if (e.getCause() instanceof NoSuchMethodException) continue;
                this.logger.error("ERROR_0012", e.getTargetException(), method.getName(), decorator.getClass().getName());
                throw new WebBeansException(e);
            }
            catch (IllegalAccessException e) {
                this.logger.error("ERROR_0014", method.getName(), decorator.getClass().getName());
                throw new WebBeansException(e);
            }
        }
        if (!method.isAccessible()) {
            this.bean.getWebBeansContext().getSecurityService().doPrivilegedSetAccessible((AccessibleObject)method, true);
        }
        Object result = null;
        if (!(this.bean instanceof EnterpriseBeanMarker)) {
            result = method.invoke(this.actualBean, arguments);
        } else if (this.ejbContext != null) {
            Method ejbMethod = this.ejbContext.getMethod();
            if (method.getName().equals(ejbMethod.getName()) && method.getReturnType().equals(ejbMethod.getReturnType())) {
                result = this.ejbContext.proceed();
            } else {
                Object ejbInstance = this.ejbContext.getTarget();
                result = method.invoke(ejbInstance, arguments);
            }
        }
        return result;
    }

    private boolean checkForMethodInInterfaces(Class<?> class1, Method m) {
        Class<?>[] interfaces = class1.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            try {
                if (interfaces[i].getMethod(m.getName(), m.getParameterTypes()) == null) continue;
                return true;
            }
            catch (NoSuchMethodException exception) {
                // empty catch block
            }
        }
        return false;
    }

    public void setDecorators(List<Object> dec) {
        this.decorators = dec;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        String id = WebBeansUtil.isPassivationCapable(this.bean);
        if (id != null) {
            out.writeObject(id);
            out.writeObject(this.actualBean);
            out.writeObject(this.decorators);
        } else {
            out.writeObject("");
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        String id = (String)in.readObject();
        if (id.equals("")) {
            return;
        }
        this.bean = (OwbBean)WebBeansContext.currentInstance().getBeanManagerImpl().getPassivationCapableBean(id);
        this.actualBean = in.readObject();
        this.decorators = (List)in.readObject();
    }
}

