/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.intercept;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.interceptor.Interceptor;
import org.apache.webbeans.config.WebBeansFinder;
import org.apache.webbeans.container.BeanManagerImpl;
import org.apache.webbeans.exception.WebBeansConfigurationException;
import org.apache.webbeans.util.Asserts;

public class InterceptorsManager {
    private List<Class<?>> enabledInterceptors = new CopyOnWriteArrayList();

    public static InterceptorsManager getInstance() {
        InterceptorsManager instance = (InterceptorsManager)WebBeansFinder.getSingletonInstance(InterceptorsManager.class.getName());
        return instance;
    }

    public void addNewInterceptor(Class<?> interceptorClazz) {
        Asserts.nullCheckForClass(interceptorClazz, "interceptorClazz can not be null");
        if (!this.enabledInterceptors.contains(interceptorClazz)) {
            InterceptorsManager.getInstance().enabledInterceptors.add(interceptorClazz);
        }
    }

    public int compare(Class<?> src, Class<?> target) {
        Asserts.assertNotNull(src, "src parameter can not be  null");
        Asserts.assertNotNull(target, "target parameter can not be null");
        int srcIndex = this.enabledInterceptors.indexOf(src);
        int targetIndex = this.enabledInterceptors.indexOf(target);
        if (srcIndex == -1 || targetIndex == -1) {
            throw new IllegalArgumentException("One of the compare class of the list : [" + src.getName() + "," + target.getName() + "]" + " is not contained in the enabled interceptors list!");
        }
        if (srcIndex == targetIndex) {
            return 0;
        }
        if (srcIndex < targetIndex) {
            return -1;
        }
        return 1;
    }

    public boolean isInterceptorEnabled(Class<?> interceptorClazz) {
        Asserts.nullCheckForClass(interceptorClazz, "interceptorClazz can not be null");
        return InterceptorsManager.getInstance().enabledInterceptors.contains(interceptorClazz);
    }

    public void validateInterceptorClasses() {
        for (Class<?> decoratorClazz : this.enabledInterceptors) {
            if (decoratorClazz.isAnnotationPresent(Interceptor.class) || BeanManagerImpl.getManager().containsCustomInterceptorClass(decoratorClazz)) continue;
            throw new WebBeansConfigurationException("Given class : " + decoratorClazz + " is not a interceptor class");
        }
    }
}

