/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.xml;

import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.decorator.Decorator;
import javax.enterprise.context.NormalScope;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Disposes;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import javax.inject.Scope;
import javax.interceptor.Interceptor;
import org.apache.webbeans.annotation.DefaultLiteral;
import org.apache.webbeans.annotation.WebBeansAnnotation;
import org.apache.webbeans.component.AbstractOwbBean;
import org.apache.webbeans.component.xml.XMLManagedBean;
import org.apache.webbeans.component.xml.XMLProducerBean;
import org.apache.webbeans.config.DefinitionUtil;
import org.apache.webbeans.config.ManagedBeanConfigurator;
import org.apache.webbeans.config.OpenWebBeansConfiguration;
import org.apache.webbeans.container.BeanManagerImpl;
import org.apache.webbeans.decorator.DecoratorsManager;
import org.apache.webbeans.exception.WebBeansConfigurationException;
import org.apache.webbeans.exception.definition.NonexistentConstructorException;
import org.apache.webbeans.exception.definition.NonexistentFieldException;
import org.apache.webbeans.exception.definition.NonexistentMethodException;
import org.apache.webbeans.exception.definition.NonexistentTypeException;
import org.apache.webbeans.exception.inject.DeploymentException;
import org.apache.webbeans.inject.AlternativesManager;
import org.apache.webbeans.inject.impl.InjectionPointFactory;
import org.apache.webbeans.inject.xml.XMLInjectableConstructor;
import org.apache.webbeans.inject.xml.XMLInjectionModelType;
import org.apache.webbeans.inject.xml.XMLInjectionPointModel;
import org.apache.webbeans.intercept.InterceptorsManager;
import org.apache.webbeans.jms.JMSManager;
import org.apache.webbeans.jms.JMSModel;
import org.apache.webbeans.logger.WebBeansLogger;
import org.apache.webbeans.plugins.OpenWebBeansJmsPlugin;
import org.apache.webbeans.plugins.PluginLoader;
import org.apache.webbeans.proxy.JavassistProxyFactory;
import org.apache.webbeans.spi.plugins.OpenWebBeansEjbPlugin;
import org.apache.webbeans.util.AnnotationUtil;
import org.apache.webbeans.util.Asserts;
import org.apache.webbeans.util.ClassUtil;
import org.apache.webbeans.util.WebBeansUtil;
import org.apache.webbeans.xml.XMLAnnotationTypeManager;
import org.apache.webbeans.xml.XMLDefinitionUtil;
import org.apache.webbeans.xml.XMLUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public final class WebBeansXMLConfigurator {
    private static final WebBeansLogger logger = WebBeansLogger.getLogger(WebBeansXMLConfigurator.class);
    private String CURRENT_SCAN_FILE_NAME = null;
    private boolean owbSpecificConfiguration = false;
    private XMLAnnotationTypeManager xmlAnnotTypeManager = XMLAnnotationTypeManager.getInstance();

    public WebBeansXMLConfigurator() {
        String usage = OpenWebBeansConfiguration.getInstance().getProperty("org.apache.webbeans.useOwbSpecificXmlConfig");
        this.owbSpecificConfiguration = Boolean.parseBoolean(usage);
    }

    public void configure(InputStream xmlStream) {
        try {
            if (xmlStream.available() > 0) {
                if (this.owbSpecificConfiguration) {
                    this.configureOwbSpecific(xmlStream, "No-name XML Stream");
                } else {
                    this.configureSpecSpecific(xmlStream, "No-name XML Stream");
                }
            }
        }
        catch (IOException e) {
            throw new WebBeansConfigurationException(e);
        }
    }

    public void configure(InputStream xmlStream, String fileName) {
        try {
            if (xmlStream.available() > 0) {
                if (this.owbSpecificConfiguration) {
                    this.configureOwbSpecific(xmlStream, fileName);
                } else {
                    this.configureSpecSpecific(xmlStream, fileName);
                }
            }
        }
        catch (IOException e) {
            throw new WebBeansConfigurationException(e);
        }
    }

    public void configureOwbSpecific(InputStream xmlStream, String fileName) {
        try {
            if (xmlStream.available() > 0) {
                Asserts.assertNotNull(xmlStream, "xmlStream parameter can not be null!");
                Asserts.assertNotNull(fileName, "fileName parameter can not be null!");
                this.CURRENT_SCAN_FILE_NAME = fileName;
                Element webBeansRoot = XMLUtil.getRootElement(xmlStream);
                this.configureOwbSpecific(webBeansRoot);
            }
        }
        catch (IOException e) {
            throw new WebBeansConfigurationException(e);
        }
    }

    public void configureSpecSpecific(InputStream xmlStream, String fileName) {
        try {
            if (xmlStream.available() > 0) {
                Asserts.assertNotNull(xmlStream, "xmlStream parameter can not be null!");
                Asserts.assertNotNull(fileName, "fileName parameter can not be null!");
                this.CURRENT_SCAN_FILE_NAME = fileName;
                Element webBeansRoot = XMLUtil.getSpecStrictRootElement(xmlStream);
                this.configureSpecSpecific(webBeansRoot);
            }
        }
        catch (IOException e) {
            throw new WebBeansConfigurationException(e);
        }
    }

    private void configureOwbSpecific(Element webBeansRoot) {
        ArrayList<Element> webBeanDeclerationList = new ArrayList<Element>();
        NodeList ns = webBeansRoot.getChildNodes();
        for (int i = 0; i < ns.getLength(); ++i) {
            Node node = ns.item(i);
            if (!(node instanceof Element)) continue;
            Element child = (Element)node;
            if (XMLUtil.isElementWebBeanDeclaration(child)) {
                webBeanDeclerationList.add(child);
                continue;
            }
            if (XMLUtil.isElementInterceptorsDeclaration(child)) {
                this.configureInterceptorsElement(child);
                continue;
            }
            if (XMLUtil.isElementDecoratosDeclaration(child)) {
                this.configureDecoratorsElement(child);
                continue;
            }
            if (XMLUtil.isElementBindingTypeDecleration(child)) {
                this.addNewBindingType(child);
                continue;
            }
            if (XMLUtil.isElementInterceptorBindingTypeDecleration(child)) {
                this.addNewInterceptorBindingType(child);
                continue;
            }
            if (XMLUtil.isElementStereoTypeDecleration(child)) {
                this.addNewStereoTypeType(child);
                continue;
            }
            if (!XMLUtil.getName(child).equals("Alternatives")) continue;
            this.configureAlternativesElement(child);
        }
        this.configureWebBeansComponents(webBeanDeclerationList);
    }

    private void configureSpecSpecific(Element webBeansRoot) {
        NodeList ns = webBeansRoot.getChildNodes();
        for (int i = 0; i < ns.getLength(); ++i) {
            Node node = ns.item(i);
            if (!(node instanceof Element)) continue;
            Element child = (Element)node;
            if (XMLUtil.getName(child).equals("interceptors")) {
                this.configureInterceptorsElement(child);
                continue;
            }
            if (XMLUtil.getName(child).equals("decorators")) {
                this.configureDecoratorsElement(child);
                continue;
            }
            if (!XMLUtil.getName(child).equals("alternatives")) continue;
            this.configureAlternativesElement(child);
        }
    }

    private void configureWebBeansComponents(List<Element> listOfWebBeanDecleration) {
        if (!listOfWebBeanDecleration.isEmpty()) {
            for (Element child : listOfWebBeanDecleration) {
                if (XMLUtil.isElementJMSDeclaration(child)) {
                    this.configureJMSEndpointComponent(child);
                    continue;
                }
                this.configureNewWebBeanComponent(child);
            }
        }
    }

    private void addNewBindingType(Element bindingTypeElement) {
        Class<?> clazz = XMLUtil.getElementJavaType(bindingTypeElement);
        if (clazz == null) {
            throw new NonexistentTypeException(this.createConfigurationFailedMessage() + "Binding type with given class : " + bindingTypeElement.getLocalName() + " not found");
        }
        Class<?> clazzAnnot = null;
        if (!clazz.isAnnotation()) {
            throw new WebBeansConfigurationException(this.createConfigurationFailedMessage() + "Binding type with given class : " + bindingTypeElement.getLocalName() + " is not an annotation type");
        }
        clazzAnnot = clazz;
        if (this.xmlAnnotTypeManager.hasBindingType(clazzAnnot)) {
            throw new DeploymentException(this.createConfigurationFailedMessage() + "Binding type with given class : " + bindingTypeElement.getLocalName() + " is already defined in the XML");
        }
        this.xmlAnnotTypeManager.addBindingType(clazzAnnot);
    }

    private void addNewInterceptorBindingType(Element interceptorBindingTypeElement) {
        Class<?> clazz = XMLUtil.getElementJavaType(interceptorBindingTypeElement);
        if (clazz == null) {
            throw new NonexistentTypeException(this.createConfigurationFailedMessage() + "InterceptorBinding type with given class : " + interceptorBindingTypeElement.getLocalName() + " not found");
        }
        Class<?> clazzAnnot = null;
        if (!clazz.isAnnotation()) {
            throw new WebBeansConfigurationException(this.createConfigurationFailedMessage() + "InterceptorBinding type with given class : " + interceptorBindingTypeElement.getLocalName() + " is not an annotation type");
        }
        clazzAnnot = clazz;
        if (this.xmlAnnotTypeManager.hasInterceptorBindingType(clazzAnnot)) {
            throw new DeploymentException(this.createConfigurationFailedMessage() + "InterceptorBinding type with given class : " + interceptorBindingTypeElement.getLocalName() + " is already defined in the XML");
        }
        NodeList ns = interceptorBindingTypeElement.getChildNodes();
        for (int i = 0; i < ns.getLength(); ++i) {
            Node node = ns.item(i);
            if (!(node instanceof Element)) continue;
            Element child = (Element)node;
            Class<?> clz = XMLUtil.getElementJavaType(child);
            if (clz == null) {
                throw new NonexistentTypeException(this.createConfigurationFailedMessage() + "InterceptorBinding type with given class : " + XMLUtil.getElementJavaClassName(child) + " not found " + "in namespace : " + XMLUtil.getElementNameSpace(child));
            }
            if (!clz.isAnnotation() || !AnnotationUtil.isInterceptorBindingAnnotation(clz)) {
                throw new WebBeansConfigurationException(this.createConfigurationFailedMessage() + "InterceptorBinding type with given class : " + XMLUtil.getElementJavaClassName(child) + " is not interceptor binding annotation type");
            }
            Annotation inherited = XMLUtil.getXMLDefinedAnnotationMember(child, clz, this.createConfigurationFailedMessage());
            this.xmlAnnotTypeManager.addInterceotorBindingTypeInheritAnnotation((Class<? extends Annotation>)clazzAnnot, inherited);
        }
    }

    private void addNewStereoTypeType(Element stereoTypeElement) {
        Class<?> clazz = XMLUtil.getElementJavaType(stereoTypeElement);
        if (clazz == null) {
            throw new NonexistentTypeException(this.createConfigurationFailedMessage() + "Stereotype with given class : " + stereoTypeElement.getLocalName() + " not found");
        }
        Class<?> clazzAnnot = null;
        if (!clazz.isAnnotation()) {
            throw new WebBeansConfigurationException(this.createConfigurationFailedMessage() + "Stereotype with given class : " + stereoTypeElement.getLocalName() + " is not an annotation type");
        }
        clazzAnnot = clazz;
        if (this.xmlAnnotTypeManager.hasStereoType(clazzAnnot)) {
            throw new DeploymentException(this.createConfigurationFailedMessage() + "Stereotype with given class : " + stereoTypeElement.getLocalName() + " is already defined in the XML");
        }
        this.xmlAnnotTypeManager.addStereoType(clazzAnnot, stereoTypeElement, clazzAnnot.getName(), this.createConfigurationFailedMessage());
    }

    private void configureInterceptorsElement(Element interceptorsElement) {
        InterceptorsManager manager = InterceptorsManager.getInstance();
        NodeList ns = interceptorsElement.getChildNodes();
        for (int i = 0; i < ns.getLength(); ++i) {
            Node node = ns.item(i);
            if (!(node instanceof Element)) continue;
            Element child = (Element)node;
            Class<?> clazz = null;
            clazz = this.owbSpecificConfiguration ? XMLUtil.getElementJavaType(child) : ClassUtil.getClassFromName(child.getTextContent().trim());
            if (clazz == null) {
                throw new WebBeansConfigurationException(this.createConfigurationFailedMessage() + "Interceptor class : " + (this.owbSpecificConfiguration ? XMLUtil.getName(child) : child.getTextContent().trim()) + " not found");
            }
            if (AnnotationUtil.hasAnnotation(clazz.getDeclaredAnnotations(), Interceptor.class) && !AnnotationUtil.hasInterceptorBindingMetaAnnotation(clazz.getDeclaredAnnotations())) {
                throw new WebBeansConfigurationException(this.createConfigurationFailedMessage() + "Interceptor class : " + (this.owbSpecificConfiguration ? XMLUtil.getName(child) : child.getTextContent().trim()) + " must have at least one @InterceptorBindingType");
            }
            if (manager.isInterceptorEnabled(clazz)) {
                throw new WebBeansConfigurationException(this.createConfigurationFailedMessage() + "Interceptor class : " + (this.owbSpecificConfiguration ? XMLUtil.getName(child) : child.getTextContent().trim()) + " is already defined");
            }
            manager.addNewInterceptor(clazz);
        }
    }

    private void configureDecoratorsElement(Element decoratorsElement) {
        DecoratorsManager manager = DecoratorsManager.getInstance();
        NodeList ns = decoratorsElement.getChildNodes();
        for (int i = 0; i < ns.getLength(); ++i) {
            Node node = ns.item(i);
            if (!(node instanceof Element)) continue;
            Element child = (Element)node;
            Class<?> clazz = null;
            clazz = this.owbSpecificConfiguration ? XMLUtil.getElementJavaType(child) : ClassUtil.getClassFromName(child.getTextContent().trim());
            if (clazz == null) {
                throw new WebBeansConfigurationException(this.createConfigurationFailedMessage() + "Decorator class : " + (this.owbSpecificConfiguration ? XMLUtil.getName(child) : child.getTextContent().trim()) + " not found");
            }
            if (manager.isDecoratorEnabled(clazz)) {
                throw new WebBeansConfigurationException(this.createConfigurationFailedMessage() + "Decorator class : " + (this.owbSpecificConfiguration ? XMLUtil.getName(child) : child.getTextContent().trim()) + " is already defined");
            }
            manager.addNewDecorator(clazz);
        }
    }

    private void configureAlternativesElement(Element alternativesElement) {
        NodeList ns = alternativesElement.getChildNodes();
        for (int i = 0; i < ns.getLength(); ++i) {
            Node node = ns.item(i);
            if (!(node instanceof Element)) continue;
            Element child = (Element)node;
            if (XMLUtil.getName(child).equals("stereotype") || XMLUtil.getName(child).equals("Stereotype")) {
                this.addAlternative(child, true);
                continue;
            }
            if (XMLUtil.getName(child).equals("class") || XMLUtil.getName(child).equals("Class")) {
                this.addAlternative(child, false);
                continue;
            }
            if (!logger.wblWillLogWarn()) continue;
            logger.warn("WARN_0002", XMLUtil.getName(child));
        }
    }

    private void addAlternative(Element child, boolean isStereoType) {
        Class<?> clazz = null;
        clazz = this.owbSpecificConfiguration ? XMLUtil.getElementJavaType(child) : ClassUtil.getClassFromName(child.getTextContent().trim());
        if (clazz == null) {
            throw new WebBeansConfigurationException(this.createConfigurationFailedMessage() + "Alternative class : " + XMLUtil.getName(child) + " not found");
        }
        AlternativesManager manager = AlternativesManager.getInstance();
        if (isStereoType) {
            manager.addStereoTypeAlternative(clazz);
        } else {
            manager.addClazzAlternative(clazz);
        }
    }

    private void configureNewWebBeanComponent(Element webBeanElement) {
        Class<?> clazz = XMLUtil.getElementJavaType(webBeanElement);
        if (clazz == null) {
            throw new NonexistentTypeException(this.createConfigurationFailedMessage() + "Class with name : " + XMLUtil.getName(webBeanElement) + " is not found in namespace " + XMLUtil.getElementNameSpace(webBeanElement));
        }
        boolean ok = false;
        OpenWebBeansEjbPlugin plugin = PluginLoader.getInstance().getEjbPlugin();
        if (plugin != null && plugin.isSessionBean(clazz)) {
            this.configureEJBWebBean(clazz);
            ok = true;
        } else if (ManagedBeanConfigurator.isManagedBean(clazz)) {
            this.configureSimpleWebBean(clazz, webBeanElement);
            ok = true;
        }
        if (!ok) {
            throw new WebBeansConfigurationException(this.createConfigurationFailedMessage() + "Given class with name : " + clazz.getName() + " is not resolved to any WebBeans type in {Simple WebBeans, Enterprise WebBeans, JMS WebBeans}");
        }
    }

    public <T> XMLManagedBean<T> configureSimpleWebBean(Class<T> simpleClass, Element webBeanDecleration) {
        XMLDefinitionUtil.checkSimpleWebBeansInXML(simpleClass, webBeanDecleration, this.createConfigurationFailedMessage());
        if (XMLUtil.hasChildElementWithWebBeansNameSpace(webBeanDecleration, "Interceptor") && !InterceptorsManager.getInstance().isInterceptorEnabled(simpleClass)) {
            return null;
        }
        if (XMLUtil.hasChildElementWithWebBeansNameSpace(webBeanDecleration, "Decorator") && !DecoratorsManager.getInstance().isDecoratorEnabled(simpleClass)) {
            return null;
        }
        XMLManagedBean<T> component = new XMLManagedBean<T>(simpleClass);
        DefinitionUtil.defineApiTypes(component, simpleClass);
        this.configureWebBeanDeclerationChilds(component, webBeanDecleration);
        BeanManagerImpl.getManager().addBean(component);
        return component;
    }

    private <T> void configureWebBeanDeclerationChilds(XMLManagedBean<T> component, Element webBeanDecleration) {
        ArrayList constTypeList = new ArrayList();
        ArrayList<Element> constructorParameterElementList = new ArrayList<Element>();
        ArrayList<Class<? extends Annotation>> annotationSet = new ArrayList<Class<? extends Annotation>>();
        ArrayList<Element> annotationElementList = new ArrayList<Element>();
        boolean isConstructor = false;
        String fieldOrMethodName = null;
        NodeList ns = webBeanDecleration.getChildNodes();
        for (int i = 0; i < ns.getLength(); ++i) {
            Node node = ns.item(i);
            if (!(node instanceof Element)) continue;
            Element child = (Element)node;
            Class<?> type = XMLUtil.getElementJavaType(child);
            boolean isElementApplicable = false;
            if (type != null) {
                if (type.isAnnotation()) {
                    Class<?> annot = type;
                    annotationSet.add(annot);
                    annotationElementList.add(child);
                    isElementApplicable = true;
                } else {
                    if (!isConstructor) {
                        isConstructor = true;
                    }
                    constructorParameterElementList.add(child);
                    constTypeList.add(type);
                    isElementApplicable = true;
                }
            } else if (XMLUtil.getElementNameSpace(child).equals(XMLUtil.getElementNameSpace(webBeanDecleration))) {
                String name = XMLUtil.getName(child);
                if (fieldOrMethodName != null) {
                    if (fieldOrMethodName.equals(name)) {
                        throw new WebBeansConfigurationException(this.createConfigurationFailedMessage() + "This field/method with name : " + fieldOrMethodName + " is already defined.");
                    }
                    this.configureFieldOrMethodMetaData(component, child);
                    fieldOrMethodName = name;
                    isElementApplicable = true;
                } else {
                    this.configureFieldOrMethodMetaData(component, child);
                    fieldOrMethodName = name;
                    isElementApplicable = true;
                }
            } else {
                throw new WebBeansConfigurationException(this.createConfigurationFailedMessage() + "Parent and child namespace has to be the same for field/method element decleration");
            }
            if (isElementApplicable) continue;
            throw new WebBeansConfigurationException(this.createConfigurationFailedMessage() + "Element with name : " + XMLUtil.getName(child) + " is not applicable for child of the simple webbeans class :  " + component.getReturnType().getName());
        }
        XMLDefinitionUtil.checkTypeMetaDataClasses(annotationSet, this.createConfigurationFailedMessage());
        this.configureTypeLevelMetaData(component, annotationSet, annotationElementList, webBeanDecleration);
        if (isConstructor) {
            this.configureConstructorMetaData(component, constTypeList, constructorParameterElementList);
        } else {
            component.setConstructor(WebBeansUtil.defineConstructor(component.getReturnType()));
        }
    }

    public <T> void configureTypeLevelMetaData(XMLManagedBean<T> component, List<Class<? extends Annotation>> annotationSet, List<Element> annotationElementList, Element webBeanDecleration) {
        boolean isInterceptor = false;
        boolean isDecorator = false;
        if (annotationSet.contains(Interceptor.class)) {
            isInterceptor = true;
        }
        if (annotationSet.contains(Decorator.class)) {
            isDecorator = true;
        }
        this.configureStereoType(component, annotationSet, annotationElementList);
        this.configureScopeType(component, annotationSet, annotationElementList);
        this.configureBindingType(component, annotationSet, annotationElementList);
        if (!isInterceptor && !isDecorator) {
            this.configureInterceptorBindingType(component, annotationSet, annotationElementList);
        }
        this.configureNamed(component, annotationSet, webBeanDecleration);
        this.configureSpecializes(component, annotationSet);
        if (isInterceptor) {
            this.configureInterceptor(component, annotationSet, annotationElementList);
        }
        if (isDecorator) {
            this.configureDecorator(component, annotationSet, annotationElementList, webBeanDecleration);
        }
    }

    public <T> void configureProducerTypeLevelMetaData(AbstractOwbBean<T> component, List<Class<? extends Annotation>> annotationSet, List<Element> annotationElementList, Element webBeanDecleration) {
        this.configureBindingType(component, annotationSet, annotationElementList);
        this.configureStereoType(component, annotationSet, annotationElementList);
        this.configureScopeType(component, annotationSet, annotationElementList);
        this.configureNamed(component, annotationSet, webBeanDecleration);
    }

    private <T> void configureConstructorMetaData(XMLManagedBean<T> component, List<Class<?>> typeList, List<Element> constructorParameterListElement) {
        Class implClazz = component.getReturnType();
        Constructor<T>[] cons = ClassUtil.getConstructors(implClazz);
        boolean found = false;
        Constructor componentConstructor = null;
        for (Constructor constructor : cons) {
            Class<?>[] pt = constructor.getParameterTypes();
            if (pt.length != typeList.size()) continue;
            int j = 0;
            boolean ok = false;
            for (Class<?> parameterType : pt) {
                Class<?> xmlType = typeList.get(j);
                if (ClassUtil.isClassAssignable(parameterType, xmlType)) {
                    if (!ok) {
                        ok = true;
                    }
                } else {
                    ok = false;
                }
                ++j;
            }
            if (!ok) continue;
            if (found) {
                throw new WebBeansConfigurationException(this.createConfigurationFailedMessage() + "More than one constructor decleration exist.");
            }
            found = true;
            componentConstructor = constructor;
        }
        if (!found) {
            throw new NonexistentConstructorException(this.createConfigurationFailedMessage() + "Constructor decleration not found in the class.");
        }
        XMLInjectableConstructor injectableConstructor = new XMLInjectableConstructor(componentConstructor, component, null);
        int i = 0;
        Constructor constructor = injectableConstructor.getConstructor();
        for (Element element : constructorParameterListElement) {
            XMLInjectionPointModel model = XMLUtil.getInjectionPointModel(element, this.createConfigurationFailedMessage());
            injectableConstructor.addInjectionPointModel(model);
            Annotation[] paramAnnos = constructor.getParameterAnnotations()[i++];
            for (Annotation paramAnno : paramAnnos) {
                model.addAnnotation(paramAnno);
            }
            model.setInjectionMember(constructor);
            model.setType(XMLInjectionModelType.CONSTRUCTOR);
            component.addInjectionPoint(InjectionPointFactory.getXMLInjectionPointData(component, model));
        }
        component.setInjectableConstructor(injectableConstructor);
    }

    private <T> void configureFieldOrMethodMetaData(XMLManagedBean<T> component, Element child) {
        if (XMLUtil.isElementField(child)) {
            this.configureField(component, child);
        } else if (XMLUtil.isElementMethod(child)) {
            this.configureMethod(component, child);
        }
    }

    private boolean hasTextOnlyChild(Element element) {
        NodeList ns = element.getChildNodes();
        for (int i = 0; i < ns.getLength(); ++i) {
            if (ns.item(i) instanceof Text) continue;
            return false;
        }
        return true;
    }

    private <T> void configureField(XMLManagedBean<T> component, Element child) {
        String fieldName;
        Class clazz = component.getReturnType();
        Field field = ClassUtil.getFieldWithName(clazz, fieldName = XMLUtil.getName(child));
        if (field == null) {
            throw new NonexistentFieldException(this.createConfigurationFailedMessage() + "Field name : " + fieldName + " decleration not found in the class : " + clazz.getName());
        }
        boolean isValueElement = false;
        boolean isApplicable = false;
        if (this.hasTextOnlyChild(child) && !isValueElement) {
            isValueElement = true;
            isApplicable = true;
        }
        boolean isTypeElement = false;
        int childElementNumber = 0;
        Element directChild = null;
        NodeList directChilds = child.getChildNodes();
        for (int i = 0; i < directChilds.getLength(); ++i) {
            Annotation[] annots;
            Node node = directChilds.item(i);
            if (!(node instanceof Element)) continue;
            directChild = (Element)node;
            ++childElementNumber;
            if (XMLUtil.isElementInWebBeansNameSpaceWithName(directChild, "value")) {
                if (isValueElement) continue;
                isValueElement = true;
                isApplicable = true;
                continue;
            }
            Class<?> directChildType = XMLUtil.getElementJavaType(directChild);
            if (!ClassUtil.isClassAssignable(field.getType(), directChildType)) {
                throw new WebBeansConfigurationException(this.createConfigurationFailedMessage() + "Declared field type is not assignable to class field type");
            }
            XMLInjectionPointModel injectionPointModel = XMLUtil.getInjectionPointModel(directChild, this.createConfigurationFailedMessage());
            component.addFieldInjectionPoint(field, injectionPointModel);
            for (Annotation annotation : annots = field.getAnnotations()) {
                injectionPointModel.addAnnotation(annotation);
            }
            injectionPointModel.setInjectionMember(field);
            injectionPointModel.setType(XMLInjectionModelType.FIELD);
            component.addInjectionPoint(InjectionPointFactory.getXMLInjectionPointData(component, injectionPointModel));
            isTypeElement = true;
            isApplicable = true;
        }
        if (!isApplicable) {
            throw new WebBeansConfigurationException(this.createConfigurationFailedMessage() + "Field with name : " + fieldName + " element is not correctly defined");
        }
        if (childElementNumber > 1) {
            if (!isValueElement) {
                throw new WebBeansConfigurationException(this.createConfigurationFailedMessage() + "One of the direct childs of the field must be element <value>");
            }
            if (isValueElement && isTypeElement) {
                throw new WebBeansConfigurationException(this.createConfigurationFailedMessage() + "Direct child of the field can not contains both value element and type element");
            }
        }
        if (directChild != null) {
            this.configureFieldValues(component, field, directChild, isValueElement);
        } else {
            this.configureFieldValues(component, field, child, isValueElement);
        }
    }

    private <T> void configureMethod(XMLManagedBean<T> component, Element child) {
        if (!ClassUtil.hasMethodWithName(component.getReturnType(), XMLUtil.getName(child))) {
            throw new NonexistentMethodException(this.createConfigurationFailedMessage() + "Method declaration with name " + XMLUtil.getName(child) + " is not found in the class : " + component.getReturnType().getName());
        }
        boolean isDefineType = false;
        int type = 0;
        ArrayList methodParameters = new ArrayList();
        ArrayList<Element> methodParameterElements = new ArrayList<Element>();
        Element methodChild = null;
        NodeList mns = child.getChildNodes();
        for (int j = 0; j < mns.getLength(); ++j) {
            Node node = mns.item(j);
            if (!(node instanceof Element)) continue;
            methodChild = (Element)node;
            Class<?> childClazz = XMLUtil.getElementJavaType(methodChild);
            String moreThanOneChildTypeErrorMesg = this.createConfigurationFailedMessage() + XMLUtil.getName(methodChild) + "method declaration can not contain more than one <Initializer>, <Destructor>, <Produces>, <Disposes> or <Observes> element";
            if (childClazz == null) {
                throw new NonexistentTypeException(this.createConfigurationFailedMessage() + "Direct child element of method : " + XMLUtil.getName(methodChild) + " does not corresponds to any Java type");
            }
            if (childClazz.isAnnotation()) {
                if (childClazz.equals(Disposes.class)) {
                    if (isDefineType) {
                        throw new WebBeansConfigurationException(moreThanOneChildTypeErrorMesg);
                    }
                    this.checkConfigureDisposes(component, methodChild);
                    isDefineType = true;
                    type = 2;
                    continue;
                }
                if (childClazz.equals(Observes.class)) {
                    if (isDefineType) {
                        throw new WebBeansConfigurationException(moreThanOneChildTypeErrorMesg);
                    }
                    this.checkConfigureObserves(component, methodChild);
                    isDefineType = true;
                    type = 3;
                    continue;
                }
                if (childClazz.equals(Inject.class)) {
                    if (isDefineType) {
                        throw new WebBeansConfigurationException(moreThanOneChildTypeErrorMesg);
                    }
                    isDefineType = true;
                    type = 0;
                    continue;
                }
                if (childClazz.equals(Produces.class)) {
                    if (isDefineType) {
                        throw new WebBeansConfigurationException(moreThanOneChildTypeErrorMesg);
                    }
                    isDefineType = true;
                    type = 1;
                    continue;
                }
                if (AnnotationUtil.isInterceptorBindingAnnotation(childClazz)) {
                    type = 5;
                    continue;
                }
                throw new WebBeansConfigurationException(this.createConfigurationFailedMessage() + "Direct child element of method : " + XMLUtil.getName(methodChild) + " with Java type : " + childClazz + " is unknown");
            }
            methodParameters.add(childClazz);
            methodParameterElements.add(methodChild);
        }
        Method annotatedMethod = this.checkConfigureMethodConditions(component, child, methodParameters);
        this.configureMethodAnnotationType(component, annotatedMethod, child, type, methodParameterElements);
    }

    private <T> void configureMethodAnnotationType(XMLManagedBean<T> component, Method annotatedMethod, Element annotChild, int type, List<Element> methodParameterElements) {
        switch (type) {
            case 0: {
                this.configureMethodInitializeAnnotation(component, annotatedMethod, methodParameterElements);
                break;
            }
            case 1: {
                this.configureMethodProducesAnnotation(component, annotatedMethod, annotChild);
                break;
            }
            case 2: {
                this.configureMethodDisposesAnnotation(component, annotatedMethod, annotChild);
                break;
            }
            case 3: {
                this.configureMethodObservesAnnotation(component, annotatedMethod, annotChild);
                break;
            }
            case 5: {
                this.configureMethodInterceptorBindingTypeAnnotation(component, annotatedMethod, annotChild);
                break;
            }
            default: {
                throw new WebBeansConfigurationException("unknown MethodAnnotytionType " + type);
            }
        }
    }

    private <T> void configureMethodInitializeAnnotation(XMLManagedBean<T> component, Method initializeMethod, List<Element> methodParameterElements) {
        if (methodParameterElements.isEmpty()) {
            component.addMethodInjectionPoint(initializeMethod, null);
        } else {
            for (Element element : methodParameterElements) {
                XMLInjectionPointModel model = XMLUtil.getInjectionPointModel(element, this.createConfigurationFailedMessage());
                component.addMethodInjectionPoint(initializeMethod, model);
                component.addInjectionPoint(XMLDefinitionUtil.getXMLMethodInjectionPoint(component, model, initializeMethod));
            }
        }
    }

    private <T> void configureMethodProducesAnnotation(XMLManagedBean<T> component, Method producesMethod, Element annotChild) {
        XMLProducerBean<T> producer = XMLDefinitionUtil.defineXMLProducerMethod(this, component, producesMethod, annotChild, this.createConfigurationFailedMessage());
        BeanManagerImpl.getManager().addBean(producer);
    }

    private <T> void configureMethodDisposesAnnotation(XMLManagedBean<T> component, Method disposalMethod, Element annotChild) {
        XMLDefinitionUtil.defineXMLDisposalMethod(component, disposalMethod, annotChild, this.createConfigurationFailedMessage());
    }

    private <T> void configureMethodObservesAnnotation(XMLManagedBean<T> component, Method observesMethod, Element annotChild) {
        XMLDefinitionUtil.defineXMLObservesMethod(component, observesMethod, annotChild, this.createConfigurationFailedMessage());
    }

    private <T> void configureMethodInterceptorBindingTypeAnnotation(XMLManagedBean<T> component, Method interceptorMethod, Element annotChild) {
        XMLDefinitionUtil.defineXMLMethodLevelInterceptorType(component, interceptorMethod, annotChild, this.createConfigurationFailedMessage());
    }

    private <T> Method checkConfigureMethodConditions(XMLManagedBean<T> component, Element child, List<Class<?>> methodParameters) {
        List<Method> definedMethods = ClassUtil.getClassMethodsWithTypes(component.getReturnType(), XMLUtil.getName(child), methodParameters);
        if (definedMethods.size() == 0) {
            throw new NonexistentMethodException(this.createConfigurationFailedMessage() + "Method declaration with name " + XMLUtil.getName(child) + " is not found in the class : " + component.getReturnType().getName());
        }
        if (definedMethods.size() > 1) {
            throw new WebBeansConfigurationException(this.createConfigurationFailedMessage() + "More than one method : " + XMLUtil.getName(child) + " is found in the class : " + component.getReturnType().getName());
        }
        return definedMethods.get(0);
    }

    private <T> void checkConfigureDisposes(AbstractOwbBean<T> component, Element disposes) {
        NodeList disposesChilds = disposes.getChildNodes();
        if (disposesChilds.getLength() != 1) {
            throw new WebBeansConfigurationException(this.createConfigurationFailedMessage() + "Disposes element : " + XMLUtil.getName(disposes) + " can not contain more than one direct child elements");
        }
    }

    private <T> void checkConfigureObserves(AbstractOwbBean<T> component, Element observes) {
        int childElementCount = 0;
        NodeList observesChilds = observes.getChildNodes();
        for (int i = 0; i < observesChilds.getLength(); ++i) {
            if (!(observesChilds.item(i) instanceof Element)) continue;
            ++childElementCount;
        }
        if (childElementCount != 1) {
            throw new WebBeansConfigurationException(this.createConfigurationFailedMessage() + "Observes element : " + XMLUtil.getName(observes) + " can not contain more than one direct child elements");
        }
    }

    private <T> void configureScopeType(AbstractOwbBean<T> component, List<Class<? extends Annotation>> annotationSet, List<Element> annotationElementList) {
        Class<Annotation> scopeType = XMLDefinitionUtil.defineXMLTypeMetaData(component, annotationSet, NormalScope.class, this.createConfigurationFailedMessage() + "@Scope/@NormalScope annotation is not configured correctly");
        if (scopeType == null) {
            scopeType = XMLDefinitionUtil.defineXMLTypeMetaData(component, annotationSet, Scope.class, this.createConfigurationFailedMessage() + "@Scope/@NormalScope annotation is not configured correctly");
        }
        if (scopeType == null) {
            DefinitionUtil.defineDefaultScopeType(component, this.createConfigurationFailedMessage() + "@Scope annotation is not configured correctly");
        } else {
            component.setImplScopeType(JavassistProxyFactory.createNewAnnotationProxy(scopeType));
        }
    }

    private <T> void configureBindingType(AbstractOwbBean<T> component, List<Class<? extends Annotation>> annotationSet, List<Element> annotationElementList) {
        boolean isDefined = XMLDefinitionUtil.defineXMLBindingType(component, annotationSet, annotationElementList, this.createConfigurationFailedMessage());
        if (!isDefined) {
            component.addQualifier((Annotation)((Object)new DefaultLiteral()));
        }
    }

    private <T> void configureInterceptorBindingType(XMLManagedBean<T> component, List<Class<? extends Annotation>> annotationSet, List<Element> annotationElementList) {
        XMLDefinitionUtil.defineXMLClassLevelInterceptorType(component, annotationSet, annotationElementList, this.createConfigurationFailedMessage());
    }

    private <T> void configureStereoType(AbstractOwbBean<T> component, List<Class<? extends Annotation>> annotationSet, List<Element> annotationElementList) {
        XMLDefinitionUtil.defineXMLStereoType(component, annotationSet);
    }

    private <T> void configureNamed(AbstractOwbBean<T> component, List<Class<? extends Annotation>> annotationSet, Element webBeanDecleration) {
        boolean isDefined = XMLDefinitionUtil.defineXMLName(component, annotationSet);
        if (isDefined) {
            Element element = (Element)webBeanDecleration.getElementsByTagName("Named").item(0);
            String name = element.getTextContent().trim();
            if (name != null && !name.equals("")) {
                component.setName(name);
            } else {
                component.setName(WebBeansUtil.getManagedBeanDefaultName(component.getReturnType().getName()));
            }
        } else {
            DefinitionUtil.defineName(component, component.getReturnType().getDeclaredAnnotations(), WebBeansUtil.getManagedBeanDefaultName(component.getReturnType().getSimpleName()));
        }
    }

    private <T> void configureSpecializes(XMLManagedBean<T> component, List<Class<? extends Annotation>> annotationSet) {
        XMLDefinitionUtil.defineXMLSpecializes(component, annotationSet);
    }

    private <T> void configureInterceptor(XMLManagedBean<T> component, List<Class<? extends Annotation>> annotationSet, List<Element> annotationElementList) {
        XMLDefinitionUtil.defineXMLInterceptors(component, annotationSet, annotationElementList, this.createConfigurationFailedMessage());
    }

    private <T> void configureDecorator(XMLManagedBean<T> component, List<Class<? extends Annotation>> annotationSet, List<Element> annotationElementList, Element webBeanDecleration) {
        XMLDefinitionUtil.defineXMLDecorators(component, annotationSet, webBeanDecleration, this.createConfigurationFailedMessage());
    }

    private void configureEJBWebBean(Class<?> ejbClass) {
    }

    private void configureJMSEndpointComponent(Element webBeanElement) {
        Element resource = (Element)webBeanElement.getElementsByTagName("Resource").item(0);
        if (resource == null) {
            throw new WebBeansConfigurationException("Topic or Queue resource mut be defined in the XML");
        }
        Element name = (Element)resource.getElementsByTagName("name").item(0);
        Element mappedName = (Element)resource.getElementsByTagName("mappedName").item(0);
        if (name == null && mappedName == null) {
            throw new WebBeansConfigurationException("Topic or Queue must define name or mapped name for the JNDI");
        }
        ArrayList<WebBeansAnnotation> bindingTypes = new ArrayList<WebBeansAnnotation>();
        NodeList ns = webBeanElement.getChildNodes();
        for (int i = 0; i < ns.getLength(); ++i) {
            Class<?> binding;
            Element child;
            Node node = ns.item(i);
            if (!(node instanceof Element) || (child = (Element)node).getLocalName() == "Resource" || !AnnotationUtil.isQualifierAnnotation(binding = XMLUtil.getElementJavaType(child))) continue;
            bindingTypes.add(JavassistProxyFactory.createNewAnnotationProxy(binding));
        }
        JMSModel.JMSType type = null;
        type = webBeanElement.getLocalName().equals("Topic") ? JMSModel.JMSType.TOPIC : JMSModel.JMSType.QUEUE;
        String jndiName = name == null ? null : name.getTextContent().trim();
        String mapName = mappedName == null ? null : mappedName.getTextContent().trim();
        JMSModel model = new JMSModel(type, jndiName, mapName);
        JMSManager.getInstance().addJmsModel(model);
        for (Annotation annotation : bindingTypes) {
            model.addBinding(annotation);
        }
        OpenWebBeansJmsPlugin plugin = PluginLoader.getInstance().getJmsPlugin();
        BeanManagerImpl.getManager().addBean(plugin.getJmsBean(model));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private <T> void configureFieldValues(XMLManagedBean<T> component, Field field, Element child, boolean isValueElement) {
        if (!isValueElement) return;
        String errorMessage = this.createConfigurationFailedMessage() + "Field value of field name : " + field.getName() + " is not applicable for initial value assignment";
        Class<?> fieldType = field.getType();
        String value = child.getTextContent().trim();
        try {
            if (!ClassUtil.isInValueTypes(fieldType)) {
                throw new WebBeansConfigurationException(this.createConfigurationFailedMessage() + "Field type with field name : " + field.getName() + " is not compatible for initial value assignment");
            }
            if (ClassUtil.isPrimitive(fieldType) || ClassUtil.isPrimitiveWrapper(fieldType)) {
                Object objVal = ClassUtil.isValueOkForPrimitiveOrWrapper(fieldType, value);
                if (objVal == null) throw new WebBeansConfigurationException(errorMessage);
                component.addFieldValue(field, objVal);
                return;
            } else if (ClassUtil.isEnum(fieldType)) {
                Enum enumValue = ClassUtil.isValueOkForEnum(fieldType, value);
                if (enumValue == null) {
                    throw new WebBeansConfigurationException(errorMessage);
                }
                component.addFieldValue(field, enumValue);
                return;
            } else if (fieldType.equals(String.class)) {
                component.addFieldValue(field, value);
                return;
            } else if (fieldType.equals(java.util.Date.class) || fieldType.equals(Date.class) || fieldType.equals(Time.class) || fieldType.equals(Timestamp.class)) {
                java.util.Date date = ClassUtil.isValueOkForDate(value);
                if (date == null) {
                    throw new WebBeansConfigurationException(errorMessage);
                }
                component.addFieldValue(field, date);
                return;
            } else if (fieldType.equals(Calendar.class)) {
                Calendar calendar = ClassUtil.isValueOkForCalendar(value);
                if (calendar == null) {
                    throw new WebBeansConfigurationException(errorMessage);
                }
                component.addFieldValue(field, calendar);
                return;
            } else if (fieldType.equals(BigDecimal.class) || fieldType.equals(BigInteger.class)) {
                Object bigValue = ClassUtil.isValueOkForBigDecimalOrInteger(fieldType, value);
                if (bigValue == null) {
                    throw new WebBeansConfigurationException(errorMessage);
                }
                component.addFieldValue(field, bigValue);
                return;
            } else if (fieldType.equals(Class.class)) {
                Class<?> clazz = ClassUtil.getClassFromName(value);
                if (clazz == null) {
                    throw new WebBeansConfigurationException(errorMessage);
                }
                component.addFieldValue(field, clazz);
                return;
            } else if (List.class.isAssignableFrom(fieldType)) {
                this.configureFieldListValue(component, field, child, errorMessage);
                return;
            } else {
                if (!Set.class.isAssignableFrom(fieldType)) return;
                this.configureFieldSetValue(component, field, child, errorMessage);
            }
            return;
        }
        catch (ParseException e) {
            throw new WebBeansConfigurationException(errorMessage, e);
        }
    }

    private void configureFieldListValue(XMLManagedBean<?> component, Field field, Element child, String errorMessage) {
        boolean isString = false;
        boolean isEnum = false;
        boolean isClazz = false;
        Type type = field.getGenericType();
        Class argClazz = null;
        ArrayList<Object> list = null;
        if (type instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)type;
            Type arg = pt.getActualTypeArguments()[0];
            if (ClassUtil.isFirstParametricTypeArgGeneric(pt)) {
                throw new WebBeansConfigurationException(this.createConfigurationFailedMessage() + "List field type with field name : " + field.getName() + " must be declared as ParametrizedType " + "but parametric type can not be TypeVariable or Wildcard Type");
            }
            argClazz = (Class)arg;
            if (argClazz.equals(String.class)) {
                isString = true;
                list = new ArrayList<Object>();
            } else if (Enum.class.isAssignableFrom(argClazz)) {
                isEnum = true;
                list = new ArrayList();
            } else if (argClazz.equals(Class.class)) {
                isClazz = true;
                list = new ArrayList();
            }
        } else {
            throw new WebBeansConfigurationException(this.createConfigurationFailedMessage() + "List field type with field name : " + field.getName() + " must be declared as ParametrizedType");
        }
        NodeList valueElements = child.getChildNodes();
        for (int i = 0; i < valueElements.getLength(); ++i) {
            Node valueNode = valueElements.item(i);
            if (!(valueNode instanceof Text)) continue;
            Text valueElement = (Text)valueNode;
            String value = valueElement.getTextContent().trim();
            if (isString) {
                list.add(value);
                continue;
            }
            if (isEnum) {
                Enum en = ClassUtil.isValueOkForEnum(argClazz, value);
                if (en == null) {
                    throw new WebBeansConfigurationException(errorMessage);
                }
                list.add(en);
                continue;
            }
            if (!isClazz) continue;
            Class<?> clazz = ClassUtil.getClassFromName(value);
            if (clazz == null) {
                throw new WebBeansConfigurationException(errorMessage);
            }
            list.add(clazz);
        }
        component.addFieldValue(field, list);
    }

    private void configureFieldSetValue(XMLManagedBean<?> component, Field field, Element child, String errorMessage) {
        boolean isString = false;
        boolean isEnum = false;
        boolean isClazz = false;
        Type type = field.getGenericType();
        Class argClazz = null;
        HashSet<Object> set = null;
        if (type instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)type;
            Type arg = pt.getActualTypeArguments()[0];
            if (ClassUtil.isFirstParametricTypeArgGeneric(pt)) {
                throw new WebBeansConfigurationException(this.createConfigurationFailedMessage() + "Set field type with field name : " + field.getName() + " must be declared as ParametrizedType " + "but parametric type can not be TypeVariable or Wildcard Type");
            }
            argClazz = (Class)arg;
            if (argClazz.equals(String.class)) {
                isString = true;
                set = new HashSet<Object>();
            } else if (Enum.class.isAssignableFrom(argClazz)) {
                isEnum = true;
                set = new HashSet();
            } else if (argClazz.equals(Class.class)) {
                isClazz = true;
                set = new HashSet();
            }
        } else {
            throw new WebBeansConfigurationException(this.createConfigurationFailedMessage() + "Set field type with field name : " + field.getName() + " must be declared as ParametrizedType");
        }
        NodeList valueElements = child.getChildNodes();
        for (int i = 0; i < valueElements.getLength(); ++i) {
            Node valueNode = valueElements.item(i);
            if (!(valueNode instanceof Element)) continue;
            Element valueElement = (Element)valueNode;
            String value = valueElement.getTextContent().trim();
            if (isString) {
                set.add(value);
                continue;
            }
            if (isEnum) {
                Enum en = ClassUtil.isValueOkForEnum(argClazz, value);
                if (en == null) {
                    throw new WebBeansConfigurationException(errorMessage);
                }
                set.add(en);
                continue;
            }
            if (!isClazz) continue;
            Class<?> clazz = ClassUtil.getClassFromName(value);
            if (clazz == null) {
                throw new WebBeansConfigurationException(errorMessage);
            }
            set.add(clazz);
        }
        component.addFieldValue(field, set);
    }

    private String createConfigurationFailedMessage() {
        return "WebBeans XML configuration defined in " + this.CURRENT_SCAN_FILE_NAME + " is failed. Reason is : ";
    }
}

