/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.corespi;

import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import org.apache.webbeans.exception.WebBeansException;
import org.apache.webbeans.spi.SingletonService;
import org.apache.webbeans.util.Asserts;
import org.apache.webbeans.util.ClassUtil;
import org.apache.webbeans.util.WebBeansUtil;

public class DefaultSingletonService
implements SingletonService {
    private final Map<ClassLoader, Map<String, Object>> singletonMap = new HashMap<ClassLoader, Map<String, Object>>();
    private final Map<Object, ClassLoader> objectToClassLoaderMap = new IdentityHashMap<Object, ClassLoader>();

    public Object getSingletonInstance(String singletonName) {
        return this.getSingletonInstance(singletonName, WebBeansUtil.getCurrentClassLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getSingletonInstance(String singletonName, ClassLoader classLoader) {
        Object object = null;
        Map<ClassLoader, Map<String, Object>> map = this.singletonMap;
        synchronized (map) {
            Map<String, Object> managerMap = this.singletonMap.get(classLoader);
            if (managerMap == null) {
                managerMap = new HashMap<String, Object>();
                this.singletonMap.put(classLoader, managerMap);
            }
            if ((object = managerMap.get(singletonName)) == null) {
                try {
                    Class<?> clazz = ClassUtil.getClassFromName(singletonName);
                    if (clazz == null) {
                        throw new ClassNotFoundException("Class with name: " + singletonName + " is not found in the system");
                    }
                    object = clazz.newInstance();
                    managerMap.put(singletonName, object);
                    this.objectToClassLoaderMap.put(object, classLoader);
                }
                catch (InstantiationException e) {
                    throw new WebBeansException("Unable to instantiate class : " + singletonName, e);
                }
                catch (IllegalAccessException e) {
                    throw new WebBeansException("Illegal access exception in creating instance with class : " + singletonName, e);
                }
                catch (ClassNotFoundException e) {
                    throw new WebBeansException("Class not found exception in creating instance with class : " + singletonName, e);
                }
            }
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getExistingSingletonInstance(String singletonName, ClassLoader cl) {
        Object object = null;
        Map<ClassLoader, Map<String, Object>> map = this.singletonMap;
        synchronized (map) {
            Map<String, Object> managerMap = this.singletonMap.get(cl);
            if (managerMap == null) {
                return null;
            }
            object = managerMap.get(singletonName);
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearInstances(ClassLoader classLoader) {
        Asserts.assertNotNull(classLoader, "classloader is null");
        Map<ClassLoader, Map<String, Object>> map = this.singletonMap;
        synchronized (map) {
            Map<String, Object> objects = this.singletonMap.remove(classLoader);
            if (objects != null) {
                for (Map.Entry<String, Object> entry : objects.entrySet()) {
                    this.objectToClassLoaderMap.remove(entry.getValue());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassLoader getSingletonClassLoader(Object object) {
        Asserts.assertNotNull(object, "object is null");
        Map<Object, ClassLoader> map = this.objectToClassLoaderMap;
        synchronized (map) {
            if (this.objectToClassLoaderMap.containsKey(object)) {
                return this.objectToClassLoaderMap.get(object);
            }
        }
        return null;
    }

    public void clear(Object classLoader) {
        this.assertClassLoaderKey(classLoader);
        this.clearInstances((ClassLoader)classLoader);
    }

    public Object get(Object key, String singletonClassName) {
        this.assertClassLoaderKey(key);
        return this.getSingletonInstance(singletonClassName, (ClassLoader)key);
    }

    public Object getExist(Object key, String singletonClassName) {
        this.assertClassLoaderKey(key);
        return this.getExistingSingletonInstance(singletonClassName, (ClassLoader)key);
    }

    public boolean isExist(Object key, String singletonClassName) {
        this.assertClassLoaderKey(key);
        return this.getExistingSingletonInstance(singletonClassName, (ClassLoader)key) != null;
    }

    public ClassLoader getKey(Object singleton) {
        return this.getSingletonClassLoader(singleton);
    }

    private void assertClassLoaderKey(Object key) {
        if (!(key instanceof ClassLoader)) {
            throw new IllegalArgumentException("Key instance must be ClassLoader for using DefaultSingletonService");
        }
    }
}

