/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.container;

import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.enterprise.event.Event;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.New;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.InjectionPoint;
import org.apache.webbeans.annotation.AnyLiteral;
import org.apache.webbeans.annotation.DefaultLiteral;
import org.apache.webbeans.component.AbstractOwbBean;
import org.apache.webbeans.container.BeanManagerImpl;
import org.apache.webbeans.container.ResolutionUtil;
import org.apache.webbeans.exception.WebBeansConfigurationException;
import org.apache.webbeans.exception.inject.NullableDependencyException;
import org.apache.webbeans.logger.WebBeansLogger;
import org.apache.webbeans.util.AnnotationUtil;
import org.apache.webbeans.util.Asserts;
import org.apache.webbeans.util.ClassUtil;
import org.apache.webbeans.util.WebBeansUtil;

public class InjectionResolver {
    private final WebBeansLogger logger = WebBeansLogger.getLogger(InjectionResolver.class);
    private BeanManagerImpl manager;
    private Map<String, Set<Bean<?>>> resolvedBeansByType = new ConcurrentHashMap();
    private Map<String, Set<Bean<?>>> resolvedBeansByName = new ConcurrentHashMap();

    public InjectionResolver(BeanManagerImpl manager) {
        this.manager = manager;
    }

    public void clearCaches() {
        this.resolvedBeansByName.clear();
        this.resolvedBeansByType.clear();
    }

    public static InjectionResolver getInstance() {
        InjectionResolver instance = BeanManagerImpl.getManager().getInjectionResolver();
        return instance;
    }

    public void checkInjectionPointType(InjectionPoint injectionPoint) {
        Type type = injectionPoint.getType();
        if (ClassUtil.isTypeVariable(type)) {
            throw new WebBeansConfigurationException("Injection point type : " + injectionPoint + " can not define Type Variable generic type");
        }
    }

    public void checkInjectionPoints(InjectionPoint injectionPoint) {
        WebBeansUtil.checkInjectionPointNamedQualifier(injectionPoint);
        Type type = injectionPoint.getType();
        Class clazz = null;
        if (ClassUtil.isTypeVariable(type)) {
            throw new WebBeansConfigurationException("Injection point type : " + injectionPoint + " type can not be defined as Typevariable or Wildcard type!");
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)type;
            clazz = (Class)pt.getRawType();
        } else {
            clazz = (Class)type;
        }
        Annotation[] qualifiers = new Annotation[injectionPoint.getQualifiers().size()];
        qualifiers = injectionPoint.getQualifiers().toArray(qualifiers);
        Set<Bean<?>> beanSet = this.implResolveByType(type, qualifiers);
        if (beanSet.isEmpty() && qualifiers.length == 1 && qualifiers[0].annotationType().equals(New.class)) {
            New newQualifier = (New)qualifiers[0];
            if (newQualifier.value() == New.class) {
                beanSet.add(WebBeansUtil.createNewComponent(clazz, type));
            } else {
                beanSet.add(WebBeansUtil.createNewComponent(newQualifier.value(), null));
            }
        }
        ResolutionUtil.checkResolvedBeans(beanSet, clazz, qualifiers, injectionPoint);
        Bean<?> bean = beanSet.iterator().next();
        if (clazz.isPrimitive() && bean.isNullable()) {
            throw new NullableDependencyException("Injection point type : " + injectionPoint + " type is primitive but resolved bean can have nullable objects!");
        }
    }

    public Bean<?> getInjectionPointBean(InjectionPoint injectionPoint) {
        Set<Bean<?>> beanSet;
        Type type = injectionPoint.getType();
        Class clazz = null;
        if (type instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)type;
            clazz = (Class)pt.getRawType();
        } else {
            clazz = (Class)type;
        }
        Annotation[] qualifiers = injectionPoint.getQualifiers().toArray(new Annotation[0]);
        if (this.isInstanceOrEventInjection(type)) {
            qualifiers = new Annotation[]{new AnyLiteral()};
        }
        if ((beanSet = this.implResolveByType(type, qualifiers)).isEmpty() && qualifiers.length == 1 && qualifiers[0].annotationType().equals(New.class)) {
            New newQualifier = (New)qualifiers[0];
            if (newQualifier.value() == New.class) {
                beanSet.add(WebBeansUtil.createNewComponent(clazz, type));
            } else {
                beanSet.add(WebBeansUtil.createNewComponent(newQualifier.value(), null));
            }
        }
        ResolutionUtil.checkResolvedBeans(beanSet, clazz, qualifiers, injectionPoint);
        return beanSet.iterator().next();
    }

    private boolean isInstanceOrEventInjection(Type type) {
        ParameterizedType pt;
        Class clazz = null;
        boolean injectInstanceOrEventProvider = false;
        if (type instanceof ParameterizedType && ((clazz = (Class)(pt = (ParameterizedType)type).getRawType()).isAssignableFrom(Instance.class) || clazz.isAssignableFrom(Event.class))) {
            injectInstanceOrEventProvider = true;
        }
        return injectInstanceOrEventProvider;
    }

    public Set<Bean<?>> implResolveByName(String name) {
        Set<Bean<?>> specializedComponents;
        Asserts.assertNotNull(name, "name parameter can not be null");
        String cacheKey = name;
        Set<Bean<?>> resolvedComponents = this.resolvedBeansByName.get(cacheKey);
        if (resolvedComponents != null) {
            return resolvedComponents;
        }
        resolvedComponents = new HashSet();
        Set<Bean<?>> deployedComponents = this.manager.getBeans();
        for (Bean<?> component : deployedComponents) {
            if (component.getName() == null || !component.getName().equals(name)) continue;
            resolvedComponents.add(component);
        }
        if ((resolvedComponents = this.findByEnabled(resolvedComponents)).size() > 1 && (specializedComponents = this.findSpecializedForNameResolution(resolvedComponents)).size() > 0) {
            resolvedComponents = specializedComponents;
        }
        if (resolvedComponents.isEmpty()) {
            this.resolvedBeansByName.put(cacheKey, Collections.EMPTY_SET);
        } else {
            this.resolvedBeansByName.put(cacheKey, resolvedComponents);
        }
        this.logger.debug("DEBUG_ADD_BYNAME_CACHE_BEANS", cacheKey);
        return resolvedComponents;
    }

    private Set<Bean<?>> findByEnabled(Set<Bean<?>> resolvedComponents) {
        HashSet specializedComponents = new HashSet();
        if (resolvedComponents.size() > 0) {
            for (Bean<?> bean : resolvedComponents) {
                AbstractOwbBean component = (AbstractOwbBean)bean;
                if (!component.isEnabled()) continue;
                specializedComponents.add(component);
            }
        }
        return specializedComponents;
    }

    private Set<Bean<?>> findSpecializedForNameResolution(Set<Bean<?>> resolvedComponents) {
        HashSet specializedComponents = new HashSet();
        if (resolvedComponents.size() > 0) {
            for (Bean<?> bean : resolvedComponents) {
                AbstractOwbBean component = (AbstractOwbBean)bean;
                if (!component.isSpecializedBean()) continue;
                specializedComponents.add(component);
            }
        }
        return specializedComponents;
    }

    public Set<Bean<?>> implResolveByType(Type injectionPointType, Annotation ... qualifiers) {
        String cacheKey = this.getBeanCacheKey(injectionPointType, qualifiers);
        Set<Bean<?>> resolvedComponents = this.resolvedBeansByType.get(cacheKey);
        if (resolvedComponents != null) {
            return resolvedComponents;
        }
        resolvedComponents = new HashSet();
        Set<Bean<?>> deployedComponents = this.manager.getBeans();
        boolean currentQualifier = false;
        boolean returnAll = false;
        if (this.isInstanceOrEventInjection(injectionPointType)) {
            qualifiers = new Annotation[]{new AnyLiteral()};
        } else if (qualifiers.length == 0) {
            qualifiers = new Annotation[]{new DefaultLiteral()};
            currentQualifier = true;
        }
        if (injectionPointType.equals(Object.class) && currentQualifier) {
            returnAll = true;
        }
        block0: for (Bean<?> component : deployedComponents) {
            if (returnAll) {
                resolvedComponents.add(component);
                continue;
            }
            Set componentApiTypes = component.getTypes();
            for (Type componentApiType : componentApiTypes) {
                if (!ClassUtil.isAssignable(componentApiType, injectionPointType)) continue;
                resolvedComponents.add(component);
                continue block0;
            }
        }
        resolvedComponents = this.findByQualifier(resolvedComponents, qualifiers);
        if ((resolvedComponents = this.findByAlternatives(resolvedComponents)).size() > 1) {
            resolvedComponents = this.findBySpecialization(resolvedComponents);
        }
        this.resolvedBeansByType.put(cacheKey, resolvedComponents);
        this.logger.debug("DEBUG_ADD_BYTYPE_CACHE_BEANS", cacheKey);
        return resolvedComponents;
    }

    private String getBeanCacheKey(Type injectionPointType, Annotation ... qualifiers) {
        StringBuilder cacheKey = new StringBuilder(injectionPointType.toString());
        for (Annotation a : qualifiers) {
            cacheKey.append('@').append(((Object)a).toString());
        }
        return cacheKey.toString();
    }

    public Set<Bean<?>> findBySpecialization(Set<Bean<?>> result) {
        Iterator<Bean<?>> it = result.iterator();
        HashSet res = new HashSet();
        while (it.hasNext()) {
            AbstractOwbBean component = (AbstractOwbBean)it.next();
            if (!component.isSpecializedBean() || !component.isEnabled()) continue;
            res.add(component);
        }
        if (res.size() > 0) {
            return res;
        }
        return result;
    }

    public Set<Bean<?>> findByAlternatives(Set<Bean<?>> result) {
        HashSet alternativeSet = new HashSet();
        HashSet enableSet = new HashSet();
        boolean containsAlternative = false;
        for (Bean<?> bean : result) {
            AbstractOwbBean temp;
            if (bean.isAlternative()) {
                if (!containsAlternative) {
                    containsAlternative = true;
                }
                alternativeSet.add(bean);
                continue;
            }
            if (containsAlternative || !(temp = (AbstractOwbBean)bean).isEnabled()) continue;
            enableSet.add(bean);
        }
        if (containsAlternative) {
            return alternativeSet;
        }
        return enableSet;
    }

    private Set<Bean<?>> findByQualifier(Set<Bean<?>> remainingSet, Annotation ... annotations) {
        Iterator<Bean<?>> it = remainingSet.iterator();
        HashSet result = new HashSet();
        while (it.hasNext()) {
            Bean<?> component = it.next();
            Set qTypes = component.getQualifiers();
            int i = 0;
            for (Annotation annot : annotations) {
                for (Annotation qualifier : qTypes) {
                    if (!annot.annotationType().equals(qualifier.annotationType()) || !AnnotationUtil.hasAnnotationMember(qualifier.annotationType(), qualifier, annot)) continue;
                    ++i;
                }
            }
            if (i != annotations.length) continue;
            result.add(component);
            i = 0;
        }
        return result;
    }
}

