/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.component;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Decorator;
import org.apache.webbeans.component.AbstractInjectionTargetBean;
import org.apache.webbeans.component.InterceptedMarker;
import org.apache.webbeans.component.WebBeansType;
import org.apache.webbeans.inject.InjectableConstructor;
import org.apache.webbeans.intercept.InterceptorData;

public class ManagedBean<T>
extends AbstractInjectionTargetBean<T>
implements InterceptedMarker {
    private Constructor<T> constructor;

    public ManagedBean(Class<T> returnType) {
        this(returnType, WebBeansType.MANAGED);
    }

    public ManagedBean(Class<T> returnType, WebBeansType type) {
        super(type, returnType);
        this.setInheritedMetaData();
    }

    @Override
    protected T createComponentInstance(CreationalContext<T> creationalContext) {
        Constructor<T> con = this.getConstructor();
        InjectableConstructor<T> ic = new InjectableConstructor<T>(con, this, creationalContext);
        T instance = ic.doInjection();
        return instance;
    }

    public Constructor<T> getConstructor() {
        return this.constructor;
    }

    public void setConstructor(Constructor<T> constructor) {
        this.constructor = constructor;
    }

    @Override
    public boolean isPassivationCapable() {
        if (Serializable.class.isAssignableFrom(this.returnType)) {
            for (Decorator dec : this.decorators) {
                if (dec.getBeanClass() == null || Serializable.class.isAssignableFrom(dec.getBeanClass())) continue;
                return false;
            }
            for (InterceptorData interceptorData : this.interceptorStack) {
                Class<?> interceptor;
                if (!interceptorData.isDefinedInInterceptorClass() || Serializable.class.isAssignableFrom(interceptor = interceptorData.getInterceptorClass())) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

