/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.util;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Properties;
import javassist.util.proxy.ProxyFactory;
import org.apache.webbeans.exception.WebBeansException;

public class SecurityUtil {
    private static final int METHOD_CLASS_GETDECLAREDCONSTRUCTOR = 1;
    private static final int METHOD_CLASS_GETDECLAREDCONSTRUCTORS = 2;
    private static final int METHOD_CLASS_GETDECLAREDMETHOD = 3;
    private static final int METHOD_CLASS_GETDECLAREDMETHODS = 4;
    private static final int METHOD_CLASS_GETDECLAREDFIELD = 5;
    private static final int METHOD_CLASS_GETDECLAREDFIELDS = 6;
    private static final PrivilegedActionGetSystemProperties SYSTEM_PROPERTY_ACTION = new PrivilegedActionGetSystemProperties();

    public static <T> Constructor<T> doPrivilegedGetDeclaredConstructor(Class<T> clazz, Class<?> ... parameterTypes) throws NoSuchMethodException {
        Object obj = AccessController.doPrivileged(new PrivilegedActionForClass(clazz, parameterTypes, 1));
        if (obj instanceof NoSuchMethodException) {
            throw (NoSuchMethodException)obj;
        }
        return (Constructor)obj;
    }

    public static <T> Constructor<T>[] doPrivilegedGetDeclaredConstructors(Class<T> clazz) {
        Object obj = AccessController.doPrivileged(new PrivilegedActionForClass(clazz, null, 2));
        return (Constructor[])obj;
    }

    public static <T> Method doPrivilegedGetDeclaredMethod(Class<T> clazz, String name, Class<?> ... parameterTypes) throws NoSuchMethodException {
        Object obj = AccessController.doPrivileged(new PrivilegedActionForClass(clazz, new Object[]{name, parameterTypes}, 3));
        if (obj instanceof NoSuchMethodException) {
            throw (NoSuchMethodException)obj;
        }
        return (Method)obj;
    }

    public static <T> Method[] doPrivilegedGetDeclaredMethods(Class<T> clazz) {
        Object obj = AccessController.doPrivileged(new PrivilegedActionForClass(clazz, null, 4));
        return (Method[])obj;
    }

    public static <T> Field doPrivilegedGetDeclaredField(Class<T> clazz, String name) throws NoSuchFieldException {
        Object obj = AccessController.doPrivileged(new PrivilegedActionForClass(clazz, name, 5));
        if (obj instanceof NoSuchFieldException) {
            throw (NoSuchFieldException)obj;
        }
        return (Field)obj;
    }

    public static <T> Field[] doPrivilegedGetDeclaredFields(Class<T> clazz) {
        Object obj = AccessController.doPrivileged(new PrivilegedActionForClass(clazz, null, 6));
        return (Field[])obj;
    }

    public static Object doPrivilegedSetAccessible(AccessibleObject obj, boolean flag) {
        AccessController.doPrivileged(new PrivilegedActionForAccessibleObject(obj, flag));
        return null;
    }

    public static Class<?> doPrivilegedCreateClass(ProxyFactory factory) {
        Class ret = (Class)AccessController.doPrivileged(new PrivilegedActionForProxyFactory(factory));
        return ret;
    }

    public static String doPrivilegedGetSystemProperty(String propertyName, String defaultValue) {
        String value = AccessController.doPrivileged(new PrivilegedActionForProperty(propertyName, defaultValue));
        return value;
    }

    public static void doPrivilegedSetSystemProperty(String propertyName, String value) {
        AccessController.doPrivileged(new PrivilegedActionForSetProperty(propertyName, value));
    }

    public static Properties doPrivilegedGetSystemProperties() {
        return AccessController.doPrivileged(SYSTEM_PROPERTY_ACTION);
    }

    protected static class PrivilegedActionForProxyFactory
    implements PrivilegedAction<Object> {
        ProxyFactory factory;

        protected PrivilegedActionForProxyFactory(ProxyFactory factory) {
            this.factory = factory;
        }

        @Override
        public Object run() {
            return this.factory.createClass();
        }
    }

    protected static class PrivilegedActionGetSystemProperties
    implements PrivilegedAction<Properties> {
        protected PrivilegedActionGetSystemProperties() {
        }

        @Override
        public Properties run() {
            return System.getProperties();
        }
    }

    protected static class PrivilegedActionForSetProperty
    implements PrivilegedAction<Object> {
        private final String propertyName;
        private final String value;

        protected PrivilegedActionForSetProperty(String propertyName, String value) {
            this.propertyName = propertyName;
            this.value = value;
        }

        @Override
        public String run() {
            System.setProperty(this.propertyName, this.value);
            return null;
        }
    }

    protected static class PrivilegedActionForProperty
    implements PrivilegedAction<String> {
        private final String propertyName;
        private final String defaultValue;

        protected PrivilegedActionForProperty(String propertyName, String defaultValue) {
            this.propertyName = propertyName;
            this.defaultValue = defaultValue;
        }

        @Override
        public String run() {
            return System.getProperty(this.propertyName, this.defaultValue);
        }
    }

    protected static class PrivilegedActionForAccessibleObject
    implements PrivilegedAction<Object> {
        AccessibleObject object;
        boolean flag;

        protected PrivilegedActionForAccessibleObject(AccessibleObject object, boolean flag) {
            this.object = object;
            this.flag = flag;
        }

        @Override
        public Object run() {
            this.object.setAccessible(this.flag);
            return null;
        }
    }

    protected static class PrivilegedActionForClass
    implements PrivilegedAction<Object> {
        Class<?> clazz;
        Object parameters;
        int method;

        protected PrivilegedActionForClass(Class<?> clazz, Object parameters, int method) {
            this.clazz = clazz;
            this.parameters = parameters;
            this.method = method;
        }

        @Override
        public Object run() {
            try {
                switch (this.method) {
                    case 1: {
                        return this.clazz.getDeclaredConstructor((Class[])this.parameters);
                    }
                    case 2: {
                        return this.clazz.getDeclaredConstructors();
                    }
                    case 3: {
                        String name = (String)((Object[])this.parameters)[0];
                        Class[] realParameters = (Class[])((Object[])this.parameters)[1];
                        return this.clazz.getDeclaredMethod(name, realParameters);
                    }
                    case 4: {
                        return this.clazz.getDeclaredMethods();
                    }
                    case 5: {
                        return this.clazz.getDeclaredField((String)this.parameters);
                    }
                    case 6: {
                        return this.clazz.getDeclaredFields();
                    }
                }
                return new WebBeansException("unknown security method: " + this.method);
            }
            catch (Exception exception) {
                return exception;
            }
        }
    }
}

