/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.proxy;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javassist.util.proxy.MethodHandler;
import javassist.util.proxy.ProxyFactory;
import javassist.util.proxy.ProxyObject;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.Decorator;
import org.apache.webbeans.annotation.WebBeansAnnotation;
import org.apache.webbeans.component.InjectionTargetBean;
import org.apache.webbeans.component.OwbBean;
import org.apache.webbeans.context.creational.CreationalContextImpl;
import org.apache.webbeans.decorator.AbstractDecoratorMethodHandler;
import org.apache.webbeans.decorator.WebBeansDecorator;
import org.apache.webbeans.intercept.ApplicationScopedBeanIntereptorHandler;
import org.apache.webbeans.intercept.DependentScopedBeanInterceptorHandler;
import org.apache.webbeans.intercept.InterceptorData;
import org.apache.webbeans.intercept.NormalScopedBeanInterceptorHandler;
import org.apache.webbeans.intercept.webbeans.WebBeansInterceptor;
import org.apache.webbeans.util.ClassUtil;
import org.apache.webbeans.util.SecurityUtil;
import org.apache.webbeans.util.WebBeansUtil;

public final class JavassistProxyFactory {
    private static Map<OwbBean<?>, Class<?>> normalScopedBeanProxyClasses = new ConcurrentHashMap();
    private static Map<OwbBean<?>, Class<?>> dependentScopedBeanProxyClasses = new ConcurrentHashMap();
    private static Map<OwbBean<?>, Class<?>> interceptorProxyClasses = new ConcurrentHashMap();
    private static Map<OwbBean<?>, Class<?>> ejbProxyClasses = new ConcurrentHashMap();

    private JavassistProxyFactory() {
    }

    public static Map<OwbBean<?>, Class<?>> getInterceptorProxyClasses() {
        return interceptorProxyClasses;
    }

    public static void clear() {
        normalScopedBeanProxyClasses.clear();
        dependentScopedBeanProxyClasses.clear();
        interceptorProxyClasses.clear();
        ejbProxyClasses.clear();
    }

    public static Class<?> getEjbBeanProxyClass(OwbBean<?> bean) {
        return ejbProxyClasses.get(bean);
    }

    public static Class<?> defineEjbBeanProxyClass(OwbBean<?> bean, ProxyFactory factory) {
        Class<?> clazz = ejbProxyClasses.get(bean);
        if (clazz != null) {
            return clazz;
        }
        clazz = SecurityUtil.doPrivilegedCreateClass(factory);
        ejbProxyClasses.put(bean, clazz);
        return clazz;
    }

    public static Class<?> createAbstractDecoratorProxyClass(OwbBean<?> bean) {
        Class<?> clazz = null;
        try {
            ProxyFactory fact = JavassistProxyFactory.createProxyFactory(bean);
            AbstractDecoratorMethodHandler handler = new AbstractDecoratorMethodHandler();
            fact.setHandler((MethodHandler)handler);
            clazz = SecurityUtil.doPrivilegedCreateClass(fact);
        }
        catch (Exception e) {
            WebBeansUtil.throwRuntimeExceptions(e);
        }
        return clazz;
    }

    public static Object createNormalScopedBeanProxy(OwbBean<?> bean, CreationalContext<?> creationalContext) {
        Object result = null;
        try {
            Class<?> proxyClass = normalScopedBeanProxyClasses.get(bean);
            if (proxyClass == null) {
                ProxyFactory fact = JavassistProxyFactory.createProxyFactory(bean);
                proxyClass = JavassistProxyFactory.getProxyClass(fact);
                normalScopedBeanProxyClasses.put(bean, proxyClass);
            }
            result = proxyClass.newInstance();
            if (!(bean instanceof WebBeansDecorator) && !(bean instanceof WebBeansInterceptor)) {
                if (bean.getScope().equals(ApplicationScoped.class)) {
                    ((ProxyObject)result).setHandler((MethodHandler)new ApplicationScopedBeanIntereptorHandler(bean, creationalContext));
                } else {
                    ((ProxyObject)result).setHandler((MethodHandler)new NormalScopedBeanInterceptorHandler(bean, creationalContext));
                }
            }
        }
        catch (Exception e) {
            WebBeansUtil.throwRuntimeExceptions(e);
        }
        return result;
    }

    public static Object createDependentScopedBeanProxy(OwbBean<?> bean, Object actualInstance, CreationalContext<?> creastionalContext) {
        Object result = null;
        List<InterceptorData> interceptors = null;
        List<Decorator<?>> decorators = null;
        InjectionTargetBean injectionTargetBean = null;
        if (bean instanceof InjectionTargetBean) {
            injectionTargetBean = (InjectionTargetBean)bean;
            interceptors = injectionTargetBean.getInterceptorStack();
            decorators = injectionTargetBean.getDecoratorStack();
        }
        if (interceptors == null && decorators == null) {
            return actualInstance;
        }
        boolean notInInterceptorClassAndLifecycle = false;
        if (interceptors != null) {
            for (InterceptorData id : interceptors) {
                if (!id.isDefinedInInterceptorClass() && id.isLifecycleInterceptor()) continue;
                notInInterceptorClassAndLifecycle = true;
                break;
            }
        }
        if (!notInInterceptorClassAndLifecycle && decorators.isEmpty()) {
            CreationalContextImpl ccImpl;
            if (creastionalContext instanceof CreationalContextImpl && (ccImpl = (CreationalContextImpl)creastionalContext).getBean() != null && ccImpl.getBean().equals(bean)) {
                ccImpl.addDependent(actualInstance, bean, actualInstance);
            }
            return actualInstance;
        }
        try {
            Class<?> proxyClass = dependentScopedBeanProxyClasses.get(bean);
            if (proxyClass == null) {
                ProxyFactory fact = JavassistProxyFactory.createProxyFactory(bean);
                proxyClass = JavassistProxyFactory.getProxyClass(fact);
                dependentScopedBeanProxyClasses.put(bean, proxyClass);
            }
            result = proxyClass.newInstance();
            if (!(bean instanceof WebBeansDecorator) && !(bean instanceof WebBeansInterceptor)) {
                ((ProxyObject)result).setHandler((MethodHandler)new DependentScopedBeanInterceptorHandler(bean, actualInstance, creastionalContext));
            }
        }
        catch (Exception e) {
            WebBeansUtil.throwRuntimeExceptions(e);
        }
        return result;
    }

    public static Class<?> getProxyClass(ProxyFactory factory) {
        Class<?> proxyClass = null;
        try {
            proxyClass = SecurityUtil.doPrivilegedCreateClass(factory);
        }
        catch (Exception e) {
            ProxyFactory.classLoaderProvider = new ProxyFactory.ClassLoaderProvider(){

                public ClassLoader get(ProxyFactory pf) {
                    return Thread.currentThread().getContextClassLoader();
                }
            };
            proxyClass = SecurityUtil.doPrivilegedCreateClass(factory);
        }
        return proxyClass;
    }

    public static ProxyFactory createProxyFactory(Bean<?> bean) throws Exception {
        Set types = bean.getTypes();
        HashSet interfaceList = new HashSet();
        Class<?> superClass = null;
        for (Type generic : types) {
            Class<?> type = ClassUtil.getClazz(generic);
            if (type.isInterface()) {
                interfaceList.add(type);
                continue;
            }
            if (superClass != null && (!superClass.isAssignableFrom(type) || type == Object.class)) continue;
            superClass = type;
        }
        if (!interfaceList.contains(Serializable.class)) {
            interfaceList.add(Serializable.class);
        }
        Class[] interfaceArray = new Class[interfaceList.size()];
        interfaceArray = interfaceList.toArray(interfaceArray);
        ProxyFactory fact = new ProxyFactory();
        fact.setInterfaces(interfaceArray);
        fact.setSuperclass(superClass);
        ProxyFactory.useCache = false;
        return fact;
    }

    public static WebBeansAnnotation createNewAnnotationProxy(Class<? extends Annotation> annotationType) {
        WebBeansAnnotation result = null;
        try {
            ProxyFactory pf = new ProxyFactory();
            pf.setInterfaces(new Class[]{annotationType, Annotation.class});
            pf.setSuperclass(WebBeansAnnotation.class);
            pf.setHandler((MethodHandler)new WebBeansAnnotation(annotationType));
            result = (WebBeansAnnotation)pf.create(new Class[]{Class.class}, new Object[]{annotationType});
        }
        catch (Exception e) {
            WebBeansUtil.throwRuntimeExceptions(e);
        }
        return result;
    }

    public static boolean isProxyInstance(Object o) {
        return o instanceof ProxyObject;
    }
}

