/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.lifecycle;

import java.lang.annotation.Annotation;
import java.util.Properties;
import javax.enterprise.inject.spi.BeanManager;
import org.apache.webbeans.config.BeansDeployer;
import org.apache.webbeans.config.WebBeansFinder;
import org.apache.webbeans.container.BeanManagerImpl;
import org.apache.webbeans.container.InjectionResolver;
import org.apache.webbeans.corespi.ServiceLoader;
import org.apache.webbeans.logger.WebBeansLogger;
import org.apache.webbeans.plugins.PluginLoader;
import org.apache.webbeans.portable.AnnotatedElementFactory;
import org.apache.webbeans.portable.events.ExtensionLoader;
import org.apache.webbeans.portable.events.discovery.BeforeShutdownImpl;
import org.apache.webbeans.proxy.JavassistProxyFactory;
import org.apache.webbeans.spi.ContainerLifecycle;
import org.apache.webbeans.spi.ContextsService;
import org.apache.webbeans.spi.JNDIService;
import org.apache.webbeans.spi.ScannerService;
import org.apache.webbeans.util.WebBeansUtil;
import org.apache.webbeans.xml.WebBeansXMLConfigurator;

public abstract class AbstractLifeCycle
implements ContainerLifecycle {
    private final WebBeansLogger logger;
    protected ScannerService scannerService;
    protected final ContextsService contextsService;
    private final BeansDeployer deployer;
    private final WebBeansXMLConfigurator xmlDeployer;
    private final JNDIService jndiService;
    private final BeanManagerImpl beanManager;

    protected AbstractLifeCycle() {
        this(null, WebBeansLogger.getLogger(AbstractLifeCycle.class));
    }

    protected AbstractLifeCycle(Properties properties, WebBeansLogger logger) {
        this.beforeInitApplication(properties);
        this.beanManager = (BeanManagerImpl)WebBeansFinder.getSingletonInstance(BeanManagerImpl.class.getName());
        this.xmlDeployer = new WebBeansXMLConfigurator();
        this.deployer = new BeansDeployer(this.xmlDeployer);
        this.jndiService = ServiceLoader.getService(JNDIService.class);
        this.beanManager.setXMLConfigurator(this.xmlDeployer);
        this.scannerService = ServiceLoader.getService(ScannerService.class);
        this.contextsService = ServiceLoader.getService(ContextsService.class);
        this.logger = logger;
        this.initApplication(properties);
    }

    public BeanManager getBeanManager() {
        return this.beanManager;
    }

    public void startApplication(Object startupObject) throws Exception {
        this.logger.info("INFO_0005");
        long begin = System.currentTimeMillis();
        this.beforeStartApplication(startupObject);
        PluginLoader.getInstance().startUp();
        this.contextsService.init(startupObject);
        this.logger.debug("Scanning classpaths for beans artifacts.");
        this.scannerService.scan();
        this.logger.debug("Deploying scanned beans.");
        this.deployer.deploy(this.scannerService);
        this.afterStartApplication(startupObject);
        this.logger.info("INFO_0001", Long.toString(System.currentTimeMillis() - begin));
    }

    public void stopApplication(Object endObject) {
        this.logger.debug("OpenWebBeans Container is stopping.");
        try {
            this.beforeStopApplication(endObject);
            this.beanManager.fireEvent(new BeforeShutdownImpl(), new Annotation[0]);
            this.contextsService.destroy(endObject);
            this.jndiService.unbind("java:comp/BeanManager");
            PluginLoader.getInstance().shutDown();
            ExtensionLoader.getInstance().clear();
            InjectionResolver.getInstance().clearCaches();
            JavassistProxyFactory.clear();
            AnnotatedElementFactory.clear();
            this.afterStopApplication(endObject);
            WebBeansFinder.clearInstances(WebBeansUtil.getCurrentClassLoader());
        }
        catch (Exception e) {
            this.logger.error("ERROR_0021", e);
        }
    }

    protected WebBeansLogger getLogger() {
        return this.logger;
    }

    protected ScannerService getScannerService() {
        return this.scannerService;
    }

    public ContextsService getContextService() {
        return this.contextsService;
    }

    protected BeansDeployer getDeployer() {
        return this.deployer;
    }

    protected WebBeansXMLConfigurator getXmlDeployer() {
        return this.xmlDeployer;
    }

    protected JNDIService getJndiService() {
        return this.jndiService;
    }

    public void initApplication(Properties properties) {
        this.afterInitApplication(properties);
    }

    protected void beforeInitApplication(Properties properties) {
    }

    protected void afterInitApplication(Properties properties) {
    }

    protected void afterStartApplication(Object startupObject) throws Exception {
    }

    protected void afterStopApplication(Object stopObject) throws Exception {
    }

    protected void beforeStartApplication(Object startupObject) throws Exception {
    }

    protected void beforeStopApplication(Object stopObject) throws Exception {
    }
}

