/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.corespi;

import java.util.List;
import org.apache.webbeans.config.OpenWebBeansConfiguration;
import org.apache.webbeans.config.WebBeansFinder;
import org.apache.webbeans.logger.WebBeansLogger;
import org.apache.webbeans.plugins.PluginLoader;
import org.apache.webbeans.spi.plugins.OpenWebBeansPlugin;

public class ServiceLoader {
    private static final WebBeansLogger logger = WebBeansLogger.getLogger(ServiceLoader.class);

    public static <T> T getService(Class<T> serviceInterface) {
        String implName = OpenWebBeansConfiguration.getInstance().getProperty(serviceInterface.getName());
        if (implName == null) {
            List<OpenWebBeansPlugin> plugins = PluginLoader.getInstance().getPlugins();
            if (plugins != null && plugins.size() > 0) {
                for (OpenWebBeansPlugin plugin : plugins) {
                    if (!plugin.supportService(serviceInterface)) continue;
                    return (T)plugin.getSupportedService(serviceInterface);
                }
            }
            if (logger.wblWillLogWarn()) {
                logger.warn("WARN_0009", serviceInterface.getName());
            }
            return null;
        }
        return (T)WebBeansFinder.getSingletonInstance(implName);
    }

    public static <T> T getService(Class<T> serviceInterface, ClassLoader cl) {
        String implName = OpenWebBeansConfiguration.getInstance().getProperty(serviceInterface.getName());
        if (implName == null) {
            List<OpenWebBeansPlugin> plugins = PluginLoader.getInstance().getPlugins();
            if (plugins != null && plugins.size() > 0) {
                for (OpenWebBeansPlugin plugin : plugins) {
                    if (!plugin.supportService(serviceInterface)) continue;
                    return (T)plugin.getSupportedService(serviceInterface);
                }
            }
            if (logger.wblWillLogWarn()) {
                logger.warn("WARN_0009", serviceInterface.getName());
            }
            return null;
        }
        return (T)WebBeansFinder.getSingletonInstance(implName, cl);
    }
}

