/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.config;

import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import org.apache.webbeans.exception.WebBeansException;
import org.apache.webbeans.util.Asserts;
import org.apache.webbeans.util.ClassUtil;
import org.apache.webbeans.util.WebBeansUtil;

public final class WebBeansFinder {
    private static Map<ClassLoader, Map<String, Object>> singletonMap = new HashMap<ClassLoader, Map<String, Object>>();
    private static Map<Object, ClassLoader> objectToClassLoaderMap = new IdentityHashMap<Object, ClassLoader>();

    private WebBeansFinder() {
    }

    public static Object getSingletonInstance(String singletonName) {
        return WebBeansFinder.getSingletonInstance(singletonName, WebBeansUtil.getCurrentClassLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getSingletonInstance(String singletonName, ClassLoader classLoader) {
        Object object = null;
        Map<ClassLoader, Map<String, Object>> map = singletonMap;
        synchronized (map) {
            Map<String, Object> managerMap = singletonMap.get(classLoader);
            if (managerMap == null) {
                managerMap = new HashMap<String, Object>();
                singletonMap.put(classLoader, managerMap);
            }
            if ((object = managerMap.get(singletonName)) == null) {
                try {
                    Class<?> clazz = ClassUtil.getClassFromName(singletonName);
                    if (clazz == null) {
                        throw new ClassNotFoundException("Class with name: " + singletonName + " is not found in the system");
                    }
                    object = clazz.newInstance();
                    managerMap.put(singletonName, object);
                    objectToClassLoaderMap.put(object, classLoader);
                }
                catch (InstantiationException e) {
                    throw new WebBeansException("Unable to instantiate class : " + singletonName, e);
                }
                catch (IllegalAccessException e) {
                    throw new WebBeansException("Illegal access exception in creating instance with class : " + singletonName, e);
                }
                catch (ClassNotFoundException e) {
                    throw new WebBeansException("Class not found exception in creating instance with class : " + singletonName, e);
                }
            }
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object getExistingSingletonInstance(String singletonName, ClassLoader cl) {
        Object object = null;
        Map<ClassLoader, Map<String, Object>> map = singletonMap;
        synchronized (map) {
            Map<String, Object> managerMap = singletonMap.get(cl);
            if (managerMap == null) {
                return null;
            }
            object = managerMap.get(singletonName);
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearInstances(ClassLoader classLoader) {
        Asserts.assertNotNull(classLoader, "classloader is null");
        Map<ClassLoader, Map<String, Object>> map = singletonMap;
        synchronized (map) {
            Map<String, Object> objects = singletonMap.remove(classLoader);
            if (objects != null) {
                for (Map.Entry<String, Object> entry : objects.entrySet()) {
                    objectToClassLoaderMap.remove(entry.getValue());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ClassLoader getSingletonClassLoader(Object object) {
        Asserts.assertNotNull(object, "object is null");
        Map<Object, ClassLoader> map = objectToClassLoaderMap;
        synchronized (map) {
            if (objectToClassLoaderMap.containsKey(object)) {
                return objectToClassLoaderMap.get(object);
            }
        }
        return null;
    }
}

