/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.logger;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.log4j.Logger;

public final class WebBeansLogger {
    private Logger logger = null;
    private ResourceBundle wbBundle = ResourceBundle.getBundle("openwebbeans/Messages");

    private WebBeansLogger() {
    }

    public static WebBeansLogger getLogger(Class<?> clazz) {
        WebBeansLogger wbLogger = new WebBeansLogger();
        Logger inLogger = Logger.getLogger(clazz);
        wbLogger.setLogger(inLogger);
        return wbLogger;
    }

    public void fatal(String messageKey) {
        this.checkNullLogger();
        this.logger.fatal((Object)this.getTokenString(messageKey));
    }

    public void fatal(String messageKey, Object[] args) {
        this.checkNullLogger();
        this.logger.fatal((Object)this.constructMessage(messageKey, args));
    }

    public void fatal(String messageKey, Throwable e) {
        this.checkNullLogger();
        this.logger.fatal((Object)this.getTokenString(messageKey), e);
    }

    public void error(Throwable e) {
        this.checkNullLogger();
        this.logger.error((Object)e);
    }

    public void error(String messageKey) {
        this.checkNullLogger();
        this.logger.error((Object)this.getTokenString(messageKey));
    }

    public void error(String messageKey, Object[] args) {
        this.checkNullLogger();
        this.logger.error((Object)this.constructMessage(messageKey, args));
    }

    public void error(String messageKey, Throwable e) {
        this.checkNullLogger();
        this.logger.error((Object)this.getTokenString(messageKey), e);
    }

    public void error(String messageKey, Object[] args, Throwable e) {
        this.checkNullLogger();
        this.logger.error((Object)this.constructMessage(messageKey, args), e);
    }

    public void warn(String messageKey) {
        this.checkNullLogger();
        this.logger.warn((Object)this.getTokenString(messageKey));
    }

    public void warn(String messageKey, Object[] args) {
        this.checkNullLogger();
        this.logger.warn((Object)this.constructMessage(messageKey, args));
    }

    public void warn(String messageKey, Throwable e) {
        this.checkNullLogger();
        this.logger.warn((Object)this.getTokenString(messageKey), e);
    }

    public void info(String messageKey) {
        this.checkNullLogger();
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)this.getTokenString(messageKey));
        }
    }

    public void info(String messageKey, Object[] args) {
        this.checkNullLogger();
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)this.constructMessage(messageKey, args));
        }
    }

    public void info(String messageKey, Throwable e) {
        this.checkNullLogger();
        if (this.logger.isInfoEnabled()) {
            this.logger.info((Object)this.getTokenString(messageKey), e);
        }
    }

    public void debug(String messageKey) {
        this.checkNullLogger();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)this.getTokenString(messageKey));
        }
    }

    public void debug(String messageKey, Object[] args) {
        this.checkNullLogger();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)this.constructMessage(messageKey, args));
        }
    }

    public void debug(String messageKey, Throwable e) {
        this.checkNullLogger();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)this.getTokenString(messageKey), e);
        }
    }

    public void trace(String messageKey) {
        this.checkNullLogger();
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)this.getTokenString(messageKey));
        }
    }

    public void trace(String messageKey, Object[] args) {
        this.checkNullLogger();
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)this.constructMessage(messageKey, args));
        }
    }

    public void trace(String messageKey, Throwable e) {
        this.checkNullLogger();
        if (this.logger.isTraceEnabled()) {
            this.logger.trace((Object)this.getTokenString(messageKey), e);
        }
    }

    private String constructMessage(String messageKey, Object[] args) {
        MessageFormat msgFrmt = new MessageFormat(this.getTokenString(messageKey), Locale.getDefault());
        String formattedString = msgFrmt.format(args);
        return formattedString;
    }

    public String getTokenString(String messageKey) {
        String strVal = null;
        if (this.wbBundle == null) {
            throw new NullPointerException("ResourceBundle can not be null");
        }
        try {
            strVal = this.wbBundle.getString(messageKey);
        }
        catch (MissingResourceException mre) {
            strVal = null;
        }
        if (strVal == null) {
            return messageKey;
        }
        return strVal;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    private void checkNullLogger() {
        if (this.logger == null) {
            throw new NullPointerException("Logger can not be null");
        }
    }
}

