/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.lifecycle;

import java.lang.annotation.Annotation;
import java.util.Properties;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.el.ELResolver;
import javax.enterprise.inject.spi.BeanManager;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestEvent;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.jsp.JspApplicationContext;
import javax.servlet.jsp.JspFactory;
import org.apache.webbeans.config.BeansDeployer;
import org.apache.webbeans.config.OpenWebBeansConfiguration;
import org.apache.webbeans.config.WebBeansFinder;
import org.apache.webbeans.container.BeanManagerImpl;
import org.apache.webbeans.context.ContextFactory;
import org.apache.webbeans.conversation.ConversationManager;
import org.apache.webbeans.el.WebBeansELResolver;
import org.apache.webbeans.exception.WebBeansException;
import org.apache.webbeans.logger.WebBeansLogger;
import org.apache.webbeans.plugins.PluginLoader;
import org.apache.webbeans.portable.events.ExtensionLoader;
import org.apache.webbeans.portable.events.discovery.BeforeShutdownImpl;
import org.apache.webbeans.spi.ContainerLifecycle;
import org.apache.webbeans.spi.JNDIService;
import org.apache.webbeans.spi.ScannerService;
import org.apache.webbeans.spi.ServiceLoader;
import org.apache.webbeans.xml.WebBeansXMLConfigurator;

public final class DefaultLifecycle
implements ContainerLifecycle {
    private static final WebBeansLogger logger = WebBeansLogger.getLogger(DefaultLifecycle.class);
    private ScheduledExecutorService service = null;
    private ScannerService discovery = null;
    private final BeansDeployer deployer;
    private final WebBeansXMLConfigurator xmlDeployer;
    private final JNDIService jndiService;
    private final BeanManagerImpl rootManager = (BeanManagerImpl)WebBeansFinder.getSingletonInstance(WebBeansFinder.SINGLETON_MANAGER);

    public DefaultLifecycle() {
        this.xmlDeployer = new WebBeansXMLConfigurator();
        this.deployer = new BeansDeployer(this.xmlDeployer);
        this.jndiService = ServiceLoader.getService(JNDIService.class);
        this.init();
    }

    public void init() {
        this.rootManager.setXMLConfigurator(this.xmlDeployer);
    }

    public void requestStarted(ServletRequestEvent event) {
        HttpServletRequest httpRequest;
        HttpSession currentSession;
        logger.debug("Starting a new request : ", new Object[]{event.getServletRequest().getRemoteAddr()});
        ContextFactory.initializeThreadLocals();
        ContextFactory.initRequestContext(event);
        ServletRequest request = event.getServletRequest();
        if (request instanceof HttpServletRequest && (currentSession = (httpRequest = (HttpServletRequest)request).getSession(false)) == null) {
            try {
                httpRequest.getSession();
            }
            catch (Exception e) {
                logger.error("ERROR_0013", e);
            }
        }
    }

    public void requestEnded(ServletRequestEvent event) {
        logger.debug("Destroying a request : ", new Object[]{event.getServletRequest().getRemoteAddr()});
        ContextFactory.destroyRequestContext((HttpServletRequest)event.getServletRequest());
    }

    public void sessionStarted(HttpSessionEvent event) {
        logger.debug("Starting a session with session id : ", new Object[]{event.getSession().getId()});
        ContextFactory.initSessionContext(event.getSession());
    }

    public void sessionEnded(HttpSessionEvent event) {
        logger.debug("Destroying a session with session id : ", new Object[]{event.getSession().getId()});
        ContextFactory.destroySessionContext(event.getSession());
        ConversationManager conversationManager = ConversationManager.getInstance();
        conversationManager.destroyConversationContextWithSessionId(event.getSession().getId());
    }

    public void applicationStarted(Object startupObject) {
        ServletContext servletContext = null;
        if (startupObject != null) {
            if (startupObject instanceof ServletContextEvent) {
                servletContext = ((ServletContextEvent)startupObject).getServletContext();
            } else {
                throw new WebBeansException(logger.getTokenString("EXCEPT_0001"));
            }
        }
        logger.debug("OpenWebBeans Container is starting.");
        long begin = System.currentTimeMillis();
        ContextFactory.initApplicationContext(servletContext);
        ContextFactory.initSingletonContext(servletContext);
        this.discovery = ServiceLoader.getService(ScannerService.class);
        this.discovery.init((Object)servletContext);
        PluginLoader.getInstance().startUp();
        String strDelay = OpenWebBeansConfiguration.getInstance().getProperty("org.apache.webbeans.conversation.Conversation.periodicDelay", "150000");
        long delay = Long.parseLong(strDelay);
        this.service = Executors.newScheduledThreadPool(1);
        this.service.scheduleWithFixedDelay(new ConversationCleaner(), delay, delay, TimeUnit.MILLISECONDS);
        logger.debug("Scanning classpaths for beans artifacts.");
        this.discovery.scan();
        logger.debug("Deploying scanned beans.");
        this.deployer.deploy(this.discovery);
        if (OpenWebBeansConfiguration.getInstance().isJspApplication()) {
            logger.debug("Application is configured as JSP. Adding EL Resolver.");
            JspApplicationContext applicationCtx = JspFactory.getDefaultFactory().getJspApplicationContext(servletContext);
            applicationCtx.addELResolver((ELResolver)new WebBeansELResolver());
        }
        long end = System.currentTimeMillis();
        logger.info("INFO_0002", new Object[]{Long.toString(end - begin)});
    }

    public void applicationEnded(Object endObject) {
        ServletContext servletContext = null;
        if (endObject != null) {
            if (endObject instanceof ServletContextEvent) {
                servletContext = ((ServletContextEvent)endObject).getServletContext();
            } else {
                throw new WebBeansException(logger.getTokenString("EXCEPT_0002"));
            }
        }
        logger.debug("OpenWebBeans Container is stopping.");
        this.rootManager.fireEvent(new BeforeShutdownImpl(), new Annotation[0]);
        this.service.shutdownNow();
        ContextFactory.destroyApplicationContext(servletContext);
        ContextFactory.destroySingletonContext(servletContext);
        this.jndiService.unbind("java:comp/BeanManager");
        PluginLoader.getInstance().shutDown();
        ExtensionLoader.getInstance().clear();
        WebBeansFinder.clearInstances();
        logger.info("INFO_0003", new Object[]{servletContext != null ? servletContext.getContextPath() : null});
    }

    public void sessionPassivated(HttpSessionEvent event) {
        logger.info("INFO_0004", new Object[]{event.getSession().getId()});
    }

    public void sessionActivated(HttpSessionEvent event) {
        logger.info("INFO_0005", new Object[]{event.getSession().getId()});
    }

    public BeanManager getBeanManager() {
        return this.rootManager;
    }

    public void init(Properties properties) {
    }

    public void start(Object startupObject) throws Exception {
        this.applicationStarted(startupObject);
    }

    public void stop(Object endObject) {
        this.applicationEnded(endObject);
    }

    private static class ConversationCleaner
    implements Runnable {
        @Override
        public void run() {
            ConversationManager.getInstance().destroyWithRespectToTimout();
        }
    }
}

