/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.intercept.ejb;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptors;
import org.apache.webbeans.intercept.InterceptorData;
import org.apache.webbeans.util.AnnotationUtil;
import org.apache.webbeans.util.Asserts;
import org.apache.webbeans.util.ClassUtil;
import org.apache.webbeans.util.WebBeansUtil;

public final class EJBInterceptorConfig {
    private EJBInterceptorConfig() {
    }

    public static void configure(Class<?> clazz, List<InterceptorData> stack) {
        Asserts.nullCheckForClass(clazz);
        if (AnnotationUtil.hasClassAnnotation(clazz, Interceptors.class)) {
            Class[] intClasses;
            Interceptors incs = clazz.getAnnotation(Interceptors.class);
            for (Class intClass : intClasses = incs.value()) {
                EJBInterceptorConfig.configureInterceptorAnnots(intClass, stack, false, null);
            }
        }
        EJBInterceptorConfig.configureBeanAnnots(clazz, stack);
        EJBInterceptorConfig.checkInheritedButOverridenMethod(clazz, stack);
    }

    private static boolean checkGivenClassIsInInterceptorList(Class<?> mainClass, Class<?> candidateClass) {
        if (AnnotationUtil.hasClassAnnotation(mainClass, Interceptors.class)) {
            Class[] intClasses;
            Interceptors incs = mainClass.getAnnotation(Interceptors.class);
            for (Class intClass : intClasses = incs.value()) {
                if (intClass.equals(candidateClass)) {
                    return true;
                }
                if (!EJBInterceptorConfig.checkInInterceptorHierarchy(intClass, candidateClass)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean checkInInterceptorHierarchy(Class<?> interceptorClass, Class<?> candidateClass) {
        Class<?> superClassInterceptor = interceptorClass.getSuperclass();
        if (superClassInterceptor != null && !superClassInterceptor.equals(Object.class)) {
            if (superClassInterceptor.equals(candidateClass)) {
                return true;
            }
            return EJBInterceptorConfig.checkInInterceptorHierarchy(superClassInterceptor, candidateClass);
        }
        return false;
    }

    private static void checkInheritedButOverridenMethod(Class<?> clazz, List<InterceptorData> stack) {
        Iterator<InterceptorData> it = stack.iterator();
        while (it.hasNext()) {
            InterceptorData interceptorData = it.next();
            if (!interceptorData.isLifecycleInterceptor() || !EJBInterceptorConfig.removeInheritedButOverridenInterceptor(clazz, interceptorData)) continue;
            it.remove();
        }
    }

    private static boolean removeInheritedButOverridenInterceptor(Class<?> clazz, InterceptorData interceptorData) {
        Method interceptor = interceptorData.getInterceptorMethod();
        Class<?> declaringClass = interceptor.getDeclaringClass();
        if (EJBInterceptorConfig.checkGivenClassIsInInterceptorList(clazz, declaringClass)) {
            return false;
        }
        if (!declaringClass.equals(clazz)) {
            Method found = ClassUtil.getDeclaredMethod(clazz, interceptor.getName(), interceptor.getParameterTypes());
            if (found != null) {
                return true;
            }
            Class<?> superClass = clazz.getSuperclass();
            if (superClass != null && !superClass.equals(Object.class)) {
                return EJBInterceptorConfig.removeInheritedButOverridenInterceptor(superClass, interceptorData);
            }
        }
        return false;
    }

    private static void configureInterceptorAnnots(Class<?> clazz, List<InterceptorData> stack, boolean isMethod, Method m) {
        Class<?> superClass = clazz.getSuperclass();
        if (superClass != null && !superClass.equals(Object.class)) {
            EJBInterceptorConfig.configureInterceptorAnnots(superClass, stack, false, null);
        }
        WebBeansUtil.configureInterceptorMethods(null, clazz, AroundInvoke.class, true, isMethod, stack, m, false);
        WebBeansUtil.configureInterceptorMethods(null, clazz, PostConstruct.class, true, isMethod, stack, m, false);
        WebBeansUtil.configureInterceptorMethods(null, clazz, PreDestroy.class, true, isMethod, stack, m, false);
    }

    private static void configureBeanAnnots(Class<?> clazz, List<InterceptorData> stack) {
        Method[] methods;
        for (Method method : methods = clazz.getDeclaredMethods()) {
            Class[] intClasses;
            Interceptors incs = method.getAnnotation(Interceptors.class);
            if (incs == null) continue;
            for (Class intClass : intClasses = incs.value()) {
                EJBInterceptorConfig.configureInterceptorAnnots(intClass, stack, true, method);
            }
        }
        List<Class<?>> listSuperClazz = ClassUtil.getSuperClasses(clazz, new ArrayList());
        EJBInterceptorConfig.configureBeanSuperClassAnnots(listSuperClazz, stack);
        WebBeansUtil.configureInterceptorMethods(null, clazz, AroundInvoke.class, false, false, stack, null, false);
        WebBeansUtil.configureInterceptorMethods(null, clazz, PostConstruct.class, false, false, stack, null, false);
        WebBeansUtil.configureInterceptorMethods(null, clazz, PreDestroy.class, false, false, stack, null, false);
    }

    private static void configureBeanSuperClassAnnots(List<Class<?>> list, List<InterceptorData> stack) {
        int i = list.size();
        for (int j = i - 1; j >= 0; --j) {
            Class<?> clazz = list.get(j);
            if (clazz.equals(Object.class)) continue;
            WebBeansUtil.configureInterceptorMethods(null, clazz, AroundInvoke.class, false, false, stack, null, false);
            WebBeansUtil.configureInterceptorMethods(null, clazz, PostConstruct.class, false, false, stack, null, false);
            WebBeansUtil.configureInterceptorMethods(null, clazz, PreDestroy.class, false, false, stack, null, false);
        }
    }
}

