/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.event;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.enterprise.event.ObserverException;
import javax.enterprise.event.Observes;
import javax.enterprise.event.Reception;
import javax.enterprise.event.TransactionPhase;
import javax.enterprise.inject.spi.ObserverMethod;
import javax.enterprise.inject.spi.ProcessObserverMethod;
import javax.enterprise.util.TypeLiteral;
import javax.transaction.Synchronization;
import javax.transaction.Transaction;
import org.apache.webbeans.annotation.AnyLiteral;
import org.apache.webbeans.component.InjectionTargetBean;
import org.apache.webbeans.container.BeanManagerImpl;
import org.apache.webbeans.event.EventUtil;
import org.apache.webbeans.event.ObserverMethodImpl;
import org.apache.webbeans.exception.WebBeansException;
import org.apache.webbeans.logger.WebBeansLogger;
import org.apache.webbeans.portable.events.generics.GenericBeanEvent;
import org.apache.webbeans.portable.events.generics.GenericProducerObserverEvent;
import org.apache.webbeans.spi.ServiceLoader;
import org.apache.webbeans.spi.TransactionService;
import org.apache.webbeans.util.AnnotationUtil;
import org.apache.webbeans.util.ArrayUtil;
import org.apache.webbeans.util.Asserts;
import org.apache.webbeans.util.ClassUtil;
import org.apache.webbeans.util.WebBeansUtil;

public final class NotificationManager {
    private static final WebBeansLogger logger = WebBeansLogger.getLogger(NotificationManager.class);
    private final Map<Type, Set<ObserverMethod<?>>> observers = new ConcurrentHashMap();
    private final TransactionService transactionService = ServiceLoader.getService(TransactionService.class);

    public static NotificationManager getInstance() {
        BeanManagerImpl manager = BeanManagerImpl.getManager();
        return manager.getNotificationManager();
    }

    public <T> void addObserver(ObserverMethod<T> observer, Type eventType) {
        EventUtil.checkEventBindings(observer.getObservedQualifiers());
        Set<ObserverMethod<?>> set = this.observers.get(eventType);
        if (set == null) {
            set = new HashSet();
            this.observers.put(eventType, set);
        }
        set.add(observer);
    }

    public <T> void addObserver(ObserverMethod<T> observer, TypeLiteral<T> typeLiteral) {
        EventUtil.checkEventType(typeLiteral.getRawType());
        this.addObserver(observer, typeLiteral.getType());
    }

    public <T> void removeObserver(ObserverMethod<T> observer, Class<T> eventType, Annotation ... annotations) {
        EventUtil.checkEventType(eventType);
        EventUtil.checkEventBindings(annotations);
        if (this.observers.containsKey(eventType)) {
            Set<ObserverMethod<?>> set = this.observers.get(eventType);
            for (ObserverMethod<?> ob : set) {
                Set evenBindings = ob.getObservedQualifiers();
                Object[] anns = new Annotation[evenBindings.size()];
                anns = evenBindings.toArray(anns);
                if (!ob.equals(observer) || !Arrays.equals(anns, annotations)) continue;
                set.remove(ob);
            }
        }
    }

    public <T> void removeObserver(ObserverMethod<T> observer, TypeLiteral<T> typeLiteral, Annotation ... annotations) {
        this.removeObserver(observer, typeLiteral.getRawType(), annotations);
    }

    public <T> Set<ObserverMethod<? super T>> resolveObservers(T event, Annotation ... eventQualifiers) {
        EventUtil.checkEventBindings(eventQualifiers);
        Set<Annotation> qualifiers = ArrayUtil.asSet(eventQualifiers);
        Class<?> eventType = event.getClass();
        Set<ObserverMethod<? super T>> observers = this.filterByType(event, eventType);
        observers = this.filterByQualifiers(observers, qualifiers);
        return observers;
    }

    private <T> Set<ObserverMethod<? super T>> filterByType(T event, Class<T> eventType) {
        Type[] genericInts;
        if (WebBeansUtil.isExtensionEventType(eventType)) {
            return this.filterByExtensionEventType(event, eventType);
        }
        HashSet<ObserverMethod<T>> matching = new HashSet<ObserverMethod<T>>();
        HashSet<Type> types = new HashSet<Type>();
        types.add(eventType);
        Type superClazz = eventType.getGenericSuperclass();
        if (superClazz != null) {
            types.add(superClazz);
        }
        if ((genericInts = eventType.getGenericInterfaces()) != null && genericInts.length > 0) {
            for (Type genericInt : genericInts) {
                types.add(genericInt);
            }
        }
        Set<Type> keySet = this.observers.keySet();
        block1: for (Type type : keySet) {
            for (Type check : types) {
                if (!ClassUtil.checkEventTypeAssignability(check, type)) continue;
                Set<ObserverMethod<?>> wrappers = this.observers.get(type);
                for (ObserverMethod<?> wrapper : wrappers) {
                    matching.add(wrapper);
                }
                continue block1;
            }
        }
        return matching;
    }

    private <T> Set<ObserverMethod<? super T>> filterByExtensionEventType(T event, Class<T> eventType) {
        HashSet<ObserverMethod<? super T>> matching = new HashSet<ObserverMethod<? super T>>();
        Set<Type> keySet = this.observers.keySet();
        for (Type type : keySet) {
            Object genericBeanEvent;
            Class<?> beanClass = null;
            Class<T> observerClass = ClassUtil.getClazz(type);
            if (!observerClass.isAssignableFrom(eventType)) continue;
            if (WebBeansUtil.isExtensionBeanEventType(eventType)) {
                if (!WebBeansUtil.isDefaultExtensionBeanEventType(observerClass)) continue;
                genericBeanEvent = (GenericBeanEvent)event;
                beanClass = genericBeanEvent.getBeanClass();
                if (ClassUtil.isParametrizedType(type)) {
                    this.addToMathingWithParametrizedForBeans(type, beanClass, matching);
                    continue;
                }
                this.addToMatching(type, matching);
                continue;
            }
            if (WebBeansUtil.isExtensionProducerOrObserverEventType(eventType)) {
                if (!WebBeansUtil.isDefaultExtensionProducerOrObserverEventType(observerClass)) continue;
                genericBeanEvent = (GenericProducerObserverEvent)event;
                beanClass = genericBeanEvent.getBeanClass();
                Class<?> producerOrObserverReturnClass = genericBeanEvent.getProducerOrObserverType();
                if (ClassUtil.isParametrizedType(type)) {
                    boolean isObserverMethod = false;
                    if (observerClass.equals(ProcessObserverMethod.class)) {
                        isObserverMethod = true;
                    }
                    this.addToMathingWithParametrizedForProducers(isObserverMethod, type, beanClass, producerOrObserverReturnClass, matching);
                    continue;
                }
                this.addToMatching(type, matching);
                continue;
            }
            if (!observerClass.isAssignableFrom(eventType)) continue;
            this.addToMatching(type, matching);
        }
        return matching;
    }

    private boolean checkEventTypeParameterForExtensions(Class<?> beanClass, Type observerTypeActualArg) {
        if (ClassUtil.isTypeVariable(observerTypeActualArg)) {
            Class clazzTvBound;
            TypeVariable tv = (TypeVariable)observerTypeActualArg;
            Type tvBound = tv.getBounds()[0];
            if (tvBound instanceof Class && (clazzTvBound = (Class)tvBound).isAssignableFrom(beanClass)) {
                return true;
            }
        } else {
            Class observerClass;
            if (ClassUtil.isWildCardType(observerTypeActualArg)) {
                return ClassUtil.checkRequiredTypeisWildCard(beanClass, observerTypeActualArg);
            }
            if (observerTypeActualArg instanceof Class && (observerClass = (Class)observerTypeActualArg).isAssignableFrom(beanClass)) {
                return true;
            }
        }
        return false;
    }

    private <T> void addToMatching(Type type, Set<ObserverMethod<? super T>> matching) {
        Set<ObserverMethod<?>> wrappers = this.observers.get(type);
        for (ObserverMethod<?> wrapper : wrappers) {
            matching.add(wrapper);
        }
    }

    private <T> void addToMathingWithParametrizedForBeans(Type type, Class<?> beanClass, Set<ObserverMethod<? super T>> matching) {
        ParameterizedType pt = (ParameterizedType)type;
        Type[] actualArgs = pt.getActualTypeArguments();
        if (actualArgs.length == 0) {
            Class rawType = (Class)pt.getRawType();
            if (rawType.isAssignableFrom(beanClass)) {
                this.addToMatching(type, matching);
            }
        } else if (this.checkEventTypeParameterForExtensions(beanClass, actualArgs[0])) {
            this.addToMatching(type, matching);
        }
    }

    private <T> void addToMathingWithParametrizedForProducers(boolean isObserverMethod, Type type, Class<?> beanClass, Class<?> producerOrObserverReturnClass, Set<ObserverMethod<? super T>> matching) {
        ParameterizedType pt = (ParameterizedType)type;
        Type[] actualArgs = pt.getActualTypeArguments();
        if (actualArgs.length == 0) {
            Class rawType = (Class)pt.getRawType();
            if (rawType.isAssignableFrom(beanClass)) {
                this.addToMatching(type, matching);
            }
        } else {
            Type beanClassArg = actualArgs[0];
            Type returnClassArg = actualArgs[1];
            if (isObserverMethod) {
                beanClassArg = actualArgs[1];
                returnClassArg = actualArgs[0];
            }
            if (this.checkEventTypeParameterForExtensions(beanClass, beanClassArg) && this.checkEventTypeParameterForExtensions(producerOrObserverReturnClass, returnClassArg)) {
                this.addToMatching(type, matching);
            }
        }
    }

    private <T> Set<ObserverMethod<? super T>> filterByQualifiers(Set<ObserverMethod<? super T>> observers, Set<Annotation> eventQualifiers) {
        eventQualifiers.add((Annotation)((Object)new AnyLiteral()));
        HashSet<ObserverMethod<T>> matching = new HashSet<ObserverMethod<T>>();
        block0: for (ObserverMethod<T> observerMethod : observers) {
            Set qualifiers = observerMethod.getObservedQualifiers();
            if (qualifiers.size() > eventQualifiers.size()) continue;
            for (Annotation qualifier : qualifiers) {
                boolean found = false;
                for (Annotation inList : eventQualifiers) {
                    if (!AnnotationUtil.hasAnnotationMember(qualifier.annotationType(), inList, qualifier)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                continue block0;
            }
            matching.add(observerMethod);
        }
        return matching;
    }

    public void fireEvent(Object event, Annotation ... qualifiers) {
        Transaction transaction = this.transactionService.getTransaction();
        Set<ObserverMethod<Object>> observers = this.resolveObservers(event, qualifiers);
        for (ObserverMethod<Object> observer : observers) {
            try {
                TransactionPhase phase = observer.getTransactionPhase();
                if (transaction != null && phase != null) {
                    if (phase.equals((Object)TransactionPhase.AFTER_COMPLETION)) {
                        transaction.registerSynchronization((Synchronization)new AfterCompletion(observer, event));
                        continue;
                    }
                    if (phase.equals((Object)TransactionPhase.AFTER_SUCCESS)) {
                        transaction.registerSynchronization((Synchronization)new AfterCompletionSuccess(observer, event));
                        continue;
                    }
                    if (phase.equals((Object)TransactionPhase.AFTER_FAILURE)) {
                        transaction.registerSynchronization((Synchronization)new AfterCompletionFailure(observer, event));
                        continue;
                    }
                    if (phase.equals((Object)TransactionPhase.BEFORE_COMPLETION)) {
                        transaction.registerSynchronization((Synchronization)new BeforeCompletion(observer, event));
                        continue;
                    }
                    throw new IllegalStateException(logger.getTokenString("EXCEPT_0007") + phase);
                }
                observer.notify(event);
            }
            catch (WebBeansException e) {
                Throwable exc = e.getCause();
                if (exc instanceof InvocationTargetException) {
                    InvocationTargetException invt = (InvocationTargetException)exc;
                    exc = invt.getCause();
                }
                if (!RuntimeException.class.isAssignableFrom(exc.getClass())) {
                    throw new ObserverException(logger.getTokenString("EXCEPT_0008") + event.getClass().getName(), (Throwable)e);
                }
                RuntimeException rte = (RuntimeException)exc;
                throw rte;
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new WebBeansException(e);
            }
        }
    }

    public <T> Set<ObserverMethod<?>> addObservableComponentMethods(InjectionTargetBean<?> component) {
        Asserts.assertNotNull(component, "component parameter can not be null");
        Set<Method> observableMethods = component.getObservableMethods();
        HashSet observerMethods = new HashSet();
        for (Method observableMethod : observableMethods) {
            Observes observes = AnnotationUtil.getMethodFirstParameterAnnotation(observableMethod, Observes.class);
            boolean ifExist = false;
            if (observes.notifyObserver().equals((Object)Reception.IF_EXISTS)) {
                ifExist = true;
            }
            ObserverMethodImpl observer = new ObserverMethodImpl(component, observableMethod, ifExist);
            Type type = AnnotationUtil.getMethodFirstParameterWithAnnotation(observableMethod, Observes.class);
            this.addObserver(observer, type);
            observerMethods.add(observer);
        }
        return observerMethods;
    }

    private static class AfterCompletionFailure
    extends AbstractSynchronization {
        private AfterCompletionFailure(ObserverMethod observer, Object event) {
            super(observer, event);
        }

        @Override
        public void afterCompletion(int i) {
            if (i != 3) {
                this.notifyObserver();
            }
        }
    }

    private static class AfterCompletionSuccess
    extends AbstractSynchronization {
        private AfterCompletionSuccess(ObserverMethod observer, Object event) {
            super(observer, event);
        }

        @Override
        public void afterCompletion(int i) {
            if (i == 3) {
                this.notifyObserver();
            }
        }
    }

    private static class AfterCompletion
    extends AbstractSynchronization {
        private AfterCompletion(ObserverMethod observer, Object event) {
            super(observer, event);
        }

        @Override
        public void afterCompletion(int i) {
            this.notifyObserver();
        }
    }

    private static class BeforeCompletion
    extends AbstractSynchronization {
        private BeforeCompletion(ObserverMethod observer, Object event) {
            super(observer, event);
        }

        @Override
        public void beforeCompletion() {
            this.notifyObserver();
        }
    }

    private static class AbstractSynchronization<T>
    implements Synchronization {
        private final ObserverMethod<T> observer;
        private final T event;

        public AbstractSynchronization(ObserverMethod<T> observer, T event) {
            this.observer = observer;
            this.event = event;
        }

        public void beforeCompletion() {
        }

        public void afterCompletion(int i) {
        }

        public void notifyObserver() {
            try {
                this.observer.notify(this.event);
            }
            catch (Exception e) {
                logger.error("ERROR_0003", e);
            }
        }
    }
}

