/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.decorator;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Decorator;
import org.apache.webbeans.annotation.DefaultLiteral;
import org.apache.webbeans.component.AbstractInjectionTargetBean;
import org.apache.webbeans.component.InjectionTargetBean;
import org.apache.webbeans.container.BeanManagerImpl;
import org.apache.webbeans.context.creational.CreationalContextImpl;
import org.apache.webbeans.decorator.DecoratorUtil;
import org.apache.webbeans.decorator.WebBeansDecorator;
import org.apache.webbeans.decorator.xml.WebBeansXMLDecorator;
import org.apache.webbeans.inject.xml.XMLInjectionPointModel;
import org.apache.webbeans.logger.WebBeansLogger;

public final class WebBeansDecoratorConfig {
    private static WebBeansLogger logger = WebBeansLogger.getLogger(WebBeansDecoratorConfig.class);

    private WebBeansDecoratorConfig() {
    }

    public static <T> void configureDecoratorClass(AbstractInjectionTargetBean<T> delegate) {
        logger.debug("Configuring decorator class : " + delegate.getReturnType());
        WebBeansDecorator<T> decorator = new WebBeansDecorator<T>(delegate);
        BeanManagerImpl.getManager().addDecorator(decorator);
    }

    public static <T> void configureXMLDecoratorClass(AbstractInjectionTargetBean<T> delegate, XMLInjectionPointModel model) {
        logger.debug("Configuring XML decorator class : " + delegate.getReturnType());
        WebBeansXMLDecorator<T> decorator = new WebBeansXMLDecorator<T>(delegate, model);
        BeanManagerImpl.getManager().addDecorator(decorator);
    }

    public static void configureDecarotors(AbstractInjectionTargetBean<?> component) {
        Set<Annotation> qualifiers = component.getQualifiers();
        Annotation[] anns = new Annotation[qualifiers.size()];
        anns = qualifiers.toArray(anns);
        List<Decorator<?>> decoratorList = BeanManagerImpl.getManager().resolveDecorators(component.getTypes(), anns);
        if (decoratorList != null && !decoratorList.isEmpty()) {
            DecoratorUtil.checkManagedBeanDecoratorConditions(component, decoratorList);
            for (WebBeansDecorator webBeansDecorator : decoratorList) {
                component.getDecoratorStack().add(webBeansDecorator);
            }
        }
    }

    public static List<Object> getDecoratorStack(InjectionTargetBean<?> component, Object instance, Object delegate, CreationalContextImpl<?> ownerCreationalContext) {
        ArrayList<Object> decoratorStack = new ArrayList<Object>();
        List<Decorator<?>> decoratorList = component.getDecoratorStack();
        Iterator<Decorator<?>> itList = decoratorList.iterator();
        BeanManagerImpl manager = BeanManagerImpl.getManager();
        while (itList.hasNext()) {
            WebBeansDecorator decorator = (WebBeansDecorator)itList.next();
            CreationalContext creationalContext = manager.createCreationalContext((Contextual)decorator);
            Object decoratorInstance = manager.getReference(decorator, decorator.getBeanClass(), creationalContext);
            decorator.setInjections(decoratorInstance, creationalContext);
            decorator.setDelegate(decoratorInstance, delegate);
            decoratorStack.add(decoratorInstance);
            if (ownerCreationalContext == null) continue;
            ownerCreationalContext.addDependent(decorator, decoratorInstance, creationalContext);
        }
        return decoratorStack;
    }

    private static Set<Decorator<?>> getWebBeansDecorators() {
        return Collections.unmodifiableSet(BeanManagerImpl.getManager().getDecorators());
    }

    public static Set<Decorator<?>> findDeployedWebBeansDecorator(Set<Type> apiType, Annotation ... anns) {
        HashSet set = new HashSet();
        Iterator<Decorator<?>> it = WebBeansDecoratorConfig.getWebBeansDecorators().iterator();
        WebBeansDecorator decorator = null;
        ArrayList<Class<? extends Annotation>> bindingTypes = new ArrayList<Class<? extends Annotation>>();
        HashSet<Annotation> listAnnot = new HashSet<Annotation>();
        for (Annotation ann : anns) {
            bindingTypes.add(ann.annotationType());
            listAnnot.add(ann);
        }
        if (listAnnot.isEmpty()) {
            listAnnot.add((Annotation)((Object)new DefaultLiteral()));
        }
        while (it.hasNext()) {
            decorator = (WebBeansDecorator)it.next();
            if (!decorator.isDecoratorMatch(apiType, listAnnot)) continue;
            set.add(decorator);
        }
        return set;
    }
}

