/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.decorator;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.HashSet;
import java.util.Set;
import javax.decorator.Delegate;
import javax.enterprise.context.spi.Context;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Decorator;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.inject.Inject;
import org.apache.webbeans.component.AbstractInjectionTargetBean;
import org.apache.webbeans.component.AbstractOwbBean;
import org.apache.webbeans.component.ManagedBean;
import org.apache.webbeans.component.WebBeansType;
import org.apache.webbeans.container.BeanManagerImpl;
import org.apache.webbeans.exception.WebBeansConfigurationException;
import org.apache.webbeans.exception.WebBeansException;
import org.apache.webbeans.inject.InjectableField;
import org.apache.webbeans.inject.InjectableMethods;
import org.apache.webbeans.logger.WebBeansLogger;
import org.apache.webbeans.proxy.JavassistProxyFactory;
import org.apache.webbeans.util.AnnotationUtil;
import org.apache.webbeans.util.ClassUtil;

public class WebBeansDecorator<T>
extends AbstractInjectionTargetBean<T>
implements Decorator<T> {
    private static WebBeansLogger logger = WebBeansLogger.getLogger(WebBeansDecorator.class);
    private Class<?> clazz;
    private Set<Type> decoratedTypes = new HashSet<Type>();
    protected Type delegateType;
    protected Set<Annotation> delegateBindings = new HashSet<Annotation>();
    protected Field delegateField;
    private AbstractInjectionTargetBean<T> wrappedBean;

    public WebBeansDecorator(AbstractInjectionTargetBean<T> wrappedBean) {
        super(WebBeansType.DECORATOR, wrappedBean.getReturnType());
        this.wrappedBean = wrappedBean;
        this.clazz = wrappedBean.getReturnType();
        this.init();
    }

    protected void init() {
        ClassUtil.setInterfaceTypeHierarchy(this.decoratedTypes, this.clazz);
        if (this.decoratedTypes.contains(Serializable.class)) {
            this.decoratedTypes.remove(Serializable.class);
        }
        this.initDelegate();
    }

    protected void initDelegate() {
        AnnotatedElement element;
        Set<InjectionPoint> injectionPoints = this.getInjectionPoints();
        boolean found = false;
        InjectionPoint ipFound = null;
        for (InjectionPoint ip : injectionPoints) {
            if (!ip.getAnnotated().isAnnotationPresent(Delegate.class)) continue;
            if (!found) {
                found = true;
                ipFound = ip;
                continue;
            }
            throw new WebBeansConfigurationException("Decorators must have a one @Delegate injection point. But the decorator bean : " + this.toString() + " has more than one");
        }
        if (ipFound == null) {
            throw new WebBeansConfigurationException("Decorators must have a one @Delegate injection point.But the decorator bean : " + this.toString() + " has none");
        }
        String message = new String("Error in decorator : " + this.toString() + ". The delegate injection point must be an injected field, " + "initializer method parameter or bean constructor method parameter. ");
        if (!(ipFound.getMember() instanceof Constructor) && !(element = (AnnotatedElement)((Object)ipFound.getMember())).isAnnotationPresent(Inject.class)) {
            throw new WebBeansConfigurationException(message);
        }
        this.initDelegateInternal(ipFound);
    }

    @Override
    public boolean isPassivationCapable() {
        return this.wrappedBean.isPassivationCapable();
    }

    private void initDelegateInternal(InjectionPoint ip) {
        this.delegateType = ip.getType();
        this.delegateBindings = ip.getQualifiers();
        if (ip.getMember() instanceof Field) {
            this.delegateField = (Field)ip.getMember();
        } else {
            Field[] fields = ClassUtil.getFieldsWithType(this.returnType, this.delegateType);
            if (fields.length == 0) {
                throw new WebBeansConfigurationException("Delegate injection field is not found for decorator : " + this.toString());
            }
            if (fields.length > 1) {
                throw new WebBeansConfigurationException("More than one delegate injection field is found for decorator : " + this.toString());
            }
            this.delegateField = fields[0];
        }
        Type fieldType = this.delegateField.getGenericType();
        for (Type decType : this.decoratedTypes) {
            if (!ClassUtil.getClass(decType).isAssignableFrom(ClassUtil.getClass(fieldType))) {
                throw new WebBeansConfigurationException("Decorator : " + this.toString() + " delegate attribute must implement all of the decorator decorated types.");
            }
            if (!ClassUtil.isParametrizedType(decType) || !ClassUtil.isParametrizedType(fieldType) || fieldType.equals(decType)) continue;
            throw new WebBeansConfigurationException("Decorator : " + this.toString() + " generic delegate attribute must be same with decorated type : " + decType);
        }
    }

    private boolean bindingMatchesAnnotations(Annotation bindingType, Set<Annotation> annotations) {
        for (Annotation annot : annotations) {
            if (!AnnotationUtil.hasAnnotationMember(bindingType.annotationType(), annot, bindingType)) continue;
            return true;
        }
        return false;
    }

    private boolean apiTypesMatchDelegateType(Set<Type> apiTypes) {
        boolean ok = false;
        for (Type apiType : apiTypes) {
            if (!ClassUtil.isAssignable(apiType, this.delegateType)) continue;
            ok = true;
            break;
        }
        return ok;
    }

    public boolean isDecoratorMatch(Set<Type> apiTypes, Set<Annotation> annotations) {
        if (!this.apiTypesMatchDelegateType(apiTypes)) {
            return false;
        }
        for (Annotation bindingType : this.delegateBindings) {
            if (this.bindingMatchesAnnotations(bindingType, annotations)) continue;
            return false;
        }
        return true;
    }

    public Set<Annotation> getDelegateQualifiers() {
        return this.delegateBindings;
    }

    public Type getDelegateType() {
        return this.delegateType;
    }

    public void setDelegate(Object instance, Object delegate) {
        if (!this.delegateField.isAccessible()) {
            this.delegateField.setAccessible(true);
        }
        try {
            this.delegateField.set(instance, delegate);
        }
        catch (IllegalArgumentException e) {
            logger.error("ERROR_0007", new Object[]{instance.getClass().getName()}, e);
            throw new WebBeansException(e);
        }
        catch (IllegalAccessException e) {
            logger.error("ERROR_0015", new Object[]{this.delegateField.getName(), instance.getClass().getName()}, e);
        }
    }

    @Override
    protected T createInstance(CreationalContext<T> creationalContext) {
        Context context = BeanManagerImpl.getManager().getContext(this.getScope());
        Object actualInstance = context.get(this.wrappedBean, creationalContext);
        Object proxy = JavassistProxyFactory.createDependentScopedBeanProxy(this.wrappedBean, actualInstance, creationalContext);
        return (T)proxy;
    }

    public void setInjections(Object proxy, CreationalContext<?> cretionalContext) {
        ManagedBean delegate = (ManagedBean)this.wrappedBean;
        Set<Field> injectedFields = delegate.getInjectedFromSuperFields();
        for (Field injectedField : injectedFields) {
            boolean isDecorates = injectedField.isAnnotationPresent(Delegate.class);
            if (isDecorates) continue;
            this.injectField(injectedField, proxy, cretionalContext);
        }
        Set<Method> injectedMethods = delegate.getInjectedFromSuperMethods();
        for (Method injectedMethod : injectedMethods) {
            this.injectMethod(injectedMethod, proxy, cretionalContext);
        }
        injectedFields = delegate.getInjectedFields();
        for (Field injectedField : injectedFields) {
            boolean isDecorates = injectedField.isAnnotationPresent(Delegate.class);
            if (isDecorates) continue;
            this.injectField(injectedField, proxy, cretionalContext);
        }
        injectedMethods = delegate.getInjectedMethods();
        for (Method injectedMethod : injectedMethods) {
            this.injectMethod(injectedMethod, proxy, cretionalContext);
        }
    }

    private void injectField(Field field, Object instance, CreationalContext<?> creationalContext) {
        InjectableField f = new InjectableField(field, instance, this.wrappedBean, creationalContext);
        f.doInjection();
    }

    private void injectMethod(Method method, Object instance, CreationalContext<?> creationalContext) {
        InjectableMethods m = new InjectableMethods(method, instance, this.wrappedBean, creationalContext);
        m.doInjection();
    }

    @Override
    public Set<Annotation> getQualifiers() {
        return this.wrappedBean.getQualifiers();
    }

    @Override
    public String getName() {
        return this.wrappedBean.getName();
    }

    @Override
    public Class<? extends Annotation> getScope() {
        return this.wrappedBean.getScope();
    }

    @Override
    public Set<Type> getTypes() {
        return this.wrappedBean.getTypes();
    }

    @Override
    public boolean isNullable() {
        return this.wrappedBean.isNullable();
    }

    @Override
    public boolean isSerializable() {
        return this.wrappedBean.isSerializable();
    }

    public AbstractOwbBean<T> getDelegateComponent() {
        return this.wrappedBean;
    }

    @Override
    public Set<InjectionPoint> getInjectionPoints() {
        return this.wrappedBean.getInjectionPoints();
    }

    public Class<?> getClazz() {
        return this.clazz;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.clazz == null ? 0 : this.clazz.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        WebBeansDecorator other = (WebBeansDecorator)obj;
        return !(this.clazz == null ? other.clazz != null : !this.clazz.equals(other.clazz));
    }

    @Override
    public Class<?> getBeanClass() {
        return this.wrappedBean.getBeanClass();
    }

    @Override
    public Set<Class<? extends Annotation>> getStereotypes() {
        return this.wrappedBean.getStereotypes();
    }

    public Set<Type> getDecoratedTypes() {
        return this.decoratedTypes;
    }

    @Override
    public boolean isAlternative() {
        return this.wrappedBean.isAlternative();
    }

    @Override
    public void validatePassivationDependencies() {
        this.wrappedBean.validatePassivationDependencies();
    }
}

