/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.context;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.webbeans.config.WebBeansFinder;
import org.apache.webbeans.context.SessionContext;
import org.apache.webbeans.util.Asserts;

public class SessionContextManager {
    private Map<String, SessionContext> sessionContexts = new ConcurrentHashMap<String, SessionContext>();

    public static SessionContextManager getInstance() {
        SessionContextManager sessionContextManager = (SessionContextManager)WebBeansFinder.getSingletonInstance(WebBeansFinder.SINGLETON_SESSION_CONTEXT_MANAGER);
        return sessionContextManager;
    }

    public void addNewSessionContext(String sessionId, SessionContext context) {
        Asserts.assertNotNull(sessionId, "sessionId parameter can not be null");
        Asserts.assertNotNull(context, "context parameter can not be null");
        this.sessionContexts.put(sessionId, context);
    }

    public SessionContext getSessionContextWithSessionId(String sessionId) {
        Asserts.assertNotNull(sessionId, "sessionId parameter can not be null");
        return this.sessionContexts.get(sessionId);
    }

    public void destroySessionContextWithSessionId(String sessionId) {
        Set<String> keySet = this.sessionContexts.keySet();
        Iterator<String> it = keySet.iterator();
        while (it.hasNext()) {
            String id = it.next();
            if (!id.equals(sessionId)) continue;
            it.remove();
        }
    }

    public void destroyAllSessions() {
        this.sessionContexts.clear();
    }
}

