/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.container;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.inject.spi.Bean;
import org.apache.webbeans.config.WebBeansFinder;
import org.apache.webbeans.container.SerializableBean;
import org.apache.webbeans.util.WebBeansUtil;

public class SerializableBeanVault {
    private Map<String, SerializableBean<?>> serializableBeans = new ConcurrentHashMap();

    public static final SerializableBeanVault getInstance() {
        return (SerializableBeanVault)WebBeansFinder.getSingletonInstance(SerializableBeanVault.class.getName());
    }

    public <T> Contextual<T> getSerializableBean(Contextual<T> bean) {
        if (bean instanceof SerializableBean) {
            return bean;
        }
        String id = null;
        id = WebBeansUtil.isPassivationCapable(bean);
        if (id != null) {
            SerializableBean<Object> sb = this.serializableBeans.get(id);
            if (sb == null) {
                sb = new SerializableBean((Bean)bean);
                this.serializableBeans.put(id, sb);
            }
            return sb;
        }
        return null;
    }
}

