/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.container;

import java.io.InputStream;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import javax.el.ELResolver;
import javax.el.ExpressionFactory;
import javax.enterprise.context.ContextNotActiveException;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.NormalScope;
import javax.enterprise.context.spi.Context;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.AmbiguousResolutionException;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.Stereotype;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Decorator;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.InjectionTarget;
import javax.enterprise.inject.spi.InterceptionType;
import javax.enterprise.inject.spi.Interceptor;
import javax.enterprise.inject.spi.ObserverMethod;
import javax.enterprise.util.TypeLiteral;
import javax.inject.Scope;
import javax.interceptor.InterceptorBinding;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;
import org.apache.webbeans.component.AbstractOwbBean;
import org.apache.webbeans.component.EnterpriseBeanMarker;
import org.apache.webbeans.component.JmsBeanMarker;
import org.apache.webbeans.component.ManagedBean;
import org.apache.webbeans.component.NewBean;
import org.apache.webbeans.component.OwbBean;
import org.apache.webbeans.component.third.ThirdpartyBeanImpl;
import org.apache.webbeans.config.WebBeansFinder;
import org.apache.webbeans.container.ExternalScope;
import org.apache.webbeans.container.InjectionResolver;
import org.apache.webbeans.container.ManagerObjectFactory;
import org.apache.webbeans.container.ResolutionUtil;
import org.apache.webbeans.container.SerializableBean;
import org.apache.webbeans.context.ContextFactory;
import org.apache.webbeans.context.WebBeansContext;
import org.apache.webbeans.context.creational.CreationalContextFactory;
import org.apache.webbeans.context.creational.CreationalContextImpl;
import org.apache.webbeans.decorator.DecoratorComparator;
import org.apache.webbeans.decorator.WebBeansDecorator;
import org.apache.webbeans.decorator.WebBeansDecoratorConfig;
import org.apache.webbeans.el.WebBeansELResolver;
import org.apache.webbeans.event.NotificationManager;
import org.apache.webbeans.exception.WebBeansConfigurationException;
import org.apache.webbeans.exception.inject.DefinitionException;
import org.apache.webbeans.intercept.InterceptorComparator;
import org.apache.webbeans.intercept.WebBeansInterceptorConfig;
import org.apache.webbeans.intercept.webbeans.WebBeansInterceptor;
import org.apache.webbeans.plugins.OpenWebBeansEjbPlugin;
import org.apache.webbeans.plugins.OpenWebBeansJmsPlugin;
import org.apache.webbeans.plugins.PluginLoader;
import org.apache.webbeans.portable.AnnotatedElementFactory;
import org.apache.webbeans.portable.creation.InjectionTargetProducer;
import org.apache.webbeans.portable.events.discovery.ErrorStack;
import org.apache.webbeans.proxy.JavassistProxyFactory;
import org.apache.webbeans.util.AnnotationUtil;
import org.apache.webbeans.util.Asserts;
import org.apache.webbeans.util.ClassUtil;
import org.apache.webbeans.util.WebBeansAnnotatedTypeUtil;
import org.apache.webbeans.util.WebBeansUtil;
import org.apache.webbeans.xml.WebBeansXMLConfigurator;

public class BeanManagerImpl
implements BeanManager,
Referenceable,
Serializable {
    private static final long serialVersionUID = 1L;
    private static Map<Class<? extends Annotation>, List<Context>> contextMap = new ConcurrentHashMap<Class<? extends Annotation>, List<Context>>();
    private Set<Bean<?>> deploymentBeans = new CopyOnWriteArraySet();
    private Set<Interceptor<?>> webBeansInterceptors = new CopyOnWriteArraySet();
    private Set<Decorator<?>> webBeansDecorators = new CopyOnWriteArraySet();
    private NotificationManager notificationManager = null;
    private InjectionResolver injectionResolver = null;
    private WebBeansXMLConfigurator xmlConfigurator = null;
    private List<Class<? extends Annotation>> additionalQualifiers = Collections.synchronizedList(new ArrayList());
    private List<ExternalScope> additionalScopes = Collections.synchronizedList(new ArrayList());
    private ErrorStack errorStack = new ErrorStack();
    private List<AnnotatedType<?>> additionalAnnotatedTypes = new CopyOnWriteArrayList();
    private ConcurrentHashMap<String, Bean<?>> passivationBeans = new ConcurrentHashMap();
    private BeanManagerImpl parent;

    public BeanManagerImpl() {
        this.injectionResolver = new InjectionResolver(this);
        this.notificationManager = new NotificationManager();
    }

    public ErrorStack getErrorStack() {
        return this.errorStack;
    }

    public BeanManagerImpl getParent() {
        return this.parent;
    }

    public synchronized void setParent(BeanManagerImpl parent) {
        this.parent = parent;
    }

    public NotificationManager getNotificationManager() {
        return this.notificationManager;
    }

    public InjectionResolver getInjectionResolver() {
        return this.injectionResolver;
    }

    public static BeanManagerImpl getManager() {
        BeanManagerImpl currentManager = (BeanManagerImpl)WebBeansFinder.getSingletonInstance(WebBeansFinder.SINGLETON_MANAGER);
        return currentManager;
    }

    public synchronized void setXMLConfigurator(WebBeansXMLConfigurator xmlConfigurator) {
        if (this.xmlConfigurator != null) {
            throw new IllegalStateException("WebBeansXMLConfigurator is already defined!");
        }
        this.xmlConfigurator = xmlConfigurator;
    }

    public Context getContext(Class<? extends Annotation> scopeType) {
        List<Context> others;
        Asserts.assertNotNull(scopeType, "scopeType paramter can not be null");
        ArrayList<Context> contexts = new ArrayList<Context>();
        WebBeansContext standardContext = null;
        standardContext = ContextFactory.getStandardContext(scopeType);
        if (standardContext != null && standardContext.isActive()) {
            contexts.add(standardContext);
        }
        if ((others = contextMap.get(scopeType)) != null) {
            for (Context otherContext : others) {
                if (!otherContext.isActive()) continue;
                contexts.add(otherContext);
            }
        }
        if (contexts.isEmpty()) {
            throw new ContextNotActiveException("WebBeans context with scope type annotation @" + scopeType.getSimpleName() + " does not exist within current thread");
        }
        if (contexts.size() > 1) {
            throw new IllegalStateException("More than one active context exists with scope type annotation @" + scopeType.getSimpleName());
        }
        return (Context)contexts.get(0);
    }

    public BeanManager addBean(Bean<?> newBean) {
        if (newBean instanceof AbstractOwbBean) {
            this.deploymentBeans.add(newBean);
            this.addPassivationInfo((OwbBean)newBean);
        } else {
            ThirdpartyBeanImpl bean = new ThirdpartyBeanImpl(newBean);
            this.deploymentBeans.add(bean);
            this.addPassivationInfo(bean);
        }
        return this;
    }

    protected void addPassivationInfo(OwbBean<?> bean) throws DefinitionException {
        Bean oldBean;
        String id = bean.getId();
        if (id != null && (oldBean = (Bean)this.passivationBeans.putIfAbsent(id, bean)) != null) {
            throw new DefinitionException("PassivationCapable bean id is not unique: " + id + " bean:" + bean);
        }
    }

    public BeanManager addContext(Context context) {
        this.addContext(context.getScope(), ContextFactory.getCustomContext(context));
        return this;
    }

    public void fireEvent(Object event, Annotation ... bindings) {
        if (ClassUtil.isDefinitionConstainsTypeVariables(event.getClass())) {
            throw new IllegalArgumentException("Event class : " + event.getClass().getName() + " can not be defined as generic type");
        }
        this.notificationManager.fireEvent(event, bindings);
    }

    @Deprecated
    public Object getInstanceByName(String name, CreationalContext<?> creationalContext) {
        AbstractOwbBean component = null;
        Object object = null;
        Set<Bean<?>> set = this.injectionResolver.implResolveByName(name);
        if (set.isEmpty()) {
            return null;
        }
        if (set.size() > 1) {
            throw new AmbiguousResolutionException("There are more than one WebBeans with name : " + name);
        }
        component = (AbstractOwbBean)set.iterator().next();
        object = this.getInstance(component, creationalContext);
        return object;
    }

    @Deprecated
    public <T> T getInstanceToInject(InjectionPoint injectionPoint, CreationalContext<?> context) {
        return (T)this.getInjectableReference(injectionPoint, context);
    }

    @Deprecated
    public Object getInstanceToInject(InjectionPoint injectionPoint) {
        return this.getInstanceToInject(injectionPoint, null);
    }

    @Deprecated
    public <T> T getInstanceByType(Class<T> type, Annotation ... bindingTypes) {
        ResolutionUtil.getInstanceByTypeConditions(bindingTypes);
        Set<Bean<?>> set = this.resolveByType(type, bindingTypes);
        ResolutionUtil.checkResolvedBeans(set, type, bindingTypes);
        Bean<?> bean = set.iterator().next();
        return (T)this.getInstance(bean, this.createCreationalContext((Contextual<T>)bean));
    }

    @Deprecated
    public <T> T getInstanceByType(TypeLiteral<T> type, Annotation ... bindingTypes) {
        ResolutionUtil.getInstanceByTypeConditions(bindingTypes);
        Set<Bean<?>> set = this.resolveByType(type, bindingTypes);
        ResolutionUtil.checkResolvedBeans(set, type.getRawType(), bindingTypes);
        Bean<?> bean = set.iterator().next();
        return (T)this.getInstance(bean, this.createCreationalContext((Contextual<T>)bean));
    }

    @Deprecated
    public Set<Bean<?>> resolveByName(String name) {
        return this.injectionResolver.implResolveByName(name);
    }

    @Deprecated
    public Set<Bean<?>> resolveByType(Class<?> apiType, Annotation ... bindingTypes) {
        ResolutionUtil.getInstanceByTypeConditions(bindingTypes);
        return this.injectionResolver.implResolveByType(apiType, bindingTypes);
    }

    @Deprecated
    public Set<Bean<?>> resolveByType(TypeLiteral<?> apiType, Annotation ... bindingTypes) {
        ParameterizedType ptype = (ParameterizedType)apiType.getType();
        ResolutionUtil.resolveByTypeConditions(ptype);
        ResolutionUtil.getInstanceByTypeConditions(bindingTypes);
        return this.injectionResolver.implResolveByType(apiType.getType(), bindingTypes);
    }

    public Set<Bean<?>> getComponents() {
        return BeanManagerImpl.getManager().deploymentBeans;
    }

    public BeanManager addDecorator(Decorator decorator) {
        BeanManagerImpl.getManager().webBeansDecorators.add(decorator);
        return this;
    }

    public BeanManager addInterceptor(Interceptor interceptor) {
        BeanManagerImpl.getManager().webBeansInterceptors.add(interceptor);
        return this;
    }

    @Deprecated
    public <T> T getInstance(Bean<T> bean, CreationalContext<?> creationalContext) {
        if (creationalContext == null) {
            creationalContext = this.createCreationalContext((Contextual<T>)bean);
        }
        return (T)this.getReference(bean, null, (CreationalContext<?>)creationalContext);
    }

    public List<Decorator<?>> resolveDecorators(Set<Type> types, Annotation ... bindingTypes) {
        WebBeansUtil.checkDecoratorResolverParams(types, bindingTypes);
        Set<Decorator<?>> intsSet = WebBeansDecoratorConfig.findDeployedWebBeansDecorator(types, bindingTypes);
        Iterator<Decorator<?>> itSet = intsSet.iterator();
        ArrayList decoratorList = new ArrayList();
        while (itSet.hasNext()) {
            WebBeansDecorator decorator = (WebBeansDecorator)itSet.next();
            decoratorList.add(decorator);
        }
        Collections.sort(decoratorList, new DecoratorComparator());
        return decoratorList;
    }

    public List<Interceptor<?>> resolveInterceptors(InterceptionType type, Annotation ... interceptorBindings) {
        WebBeansUtil.checkInterceptorResolverParams(interceptorBindings);
        Set<Interceptor<?>> intsSet = WebBeansInterceptorConfig.findDeployedWebBeansInterceptor(interceptorBindings);
        Iterator<Interceptor<?>> itSet = intsSet.iterator();
        ArrayList interceptorList = new ArrayList();
        while (itSet.hasNext()) {
            WebBeansInterceptor interceptor = (WebBeansInterceptor)itSet.next();
            if (interceptor.getMethod(type) == null) continue;
            interceptorList.add(interceptor);
        }
        Collections.sort(interceptorList, new InterceptorComparator());
        return interceptorList;
    }

    public Set<Bean<?>> getBeans() {
        return this.deploymentBeans;
    }

    public Set<Interceptor<?>> getInterceptors() {
        return this.webBeansInterceptors;
    }

    public Set<Decorator<?>> getDecorators() {
        return this.webBeansDecorators;
    }

    private void addContext(Class<? extends Annotation> scopeType, Context context) {
        Asserts.assertNotNull(scopeType, "scopeType parameter can not be null");
        Asserts.assertNotNull(context, "context parameter can not be null");
        List<Context> contextList = contextMap.get(scopeType);
        if (contextList == null) {
            contextList = new CopyOnWriteArrayList<Context>();
            contextList.add(context);
            contextMap.put(scopeType, contextList);
        } else {
            contextList.add(context);
        }
    }

    @Override
    public Reference getReference() throws NamingException {
        return new Reference(BeanManagerImpl.class.getName(), new StringRefAddr("ManagerImpl", "ManagerImpl"), ManagerObjectFactory.class.getName(), null);
    }

    public BeanManager parse(InputStream xmlStream) {
        this.xmlConfigurator.configure(xmlStream);
        return this;
    }

    public <T> AnnotatedType<T> createAnnotatedType(Class<T> type) {
        AnnotatedType<T> annotatedType = AnnotatedElementFactory.newAnnotatedType(type);
        return annotatedType;
    }

    public <T> CreationalContext<T> createCreationalContext(Contextual<T> contextual) {
        if (contextual instanceof SerializableBean) {
            contextual = ((SerializableBean)contextual).getBean();
        }
        return CreationalContextFactory.getInstance().getCreationalContext(contextual);
    }

    public Set<Bean<?>> getBeans(Type beanType, Annotation ... bindings) {
        if (ClassUtil.isTypeVariable(beanType)) {
            throw new IllegalArgumentException("Exception in getBeans method. Bean type can not be TypeVariable for bean type : " + beanType);
        }
        AnnotationUtil.checkQualifierConditions(bindings);
        return this.injectionResolver.implResolveByType(beanType, bindings);
    }

    public Set<Bean<?>> getBeans(String name) {
        return this.injectionResolver.implResolveByName(name);
    }

    public ELResolver getELResolver() {
        return new WebBeansELResolver();
    }

    public Object getInjectableReference(InjectionPoint injectionPoint, CreationalContext<?> ownerCreationalContext) {
        Object instance = null;
        if (injectionPoint == null) {
            return null;
        }
        CreationalContextImpl ownerCreationalContextImpl = null;
        ownerCreationalContextImpl = !(ownerCreationalContext instanceof CreationalContextImpl) ? (CreationalContextImpl)CreationalContextFactory.getInstance().wrappedCreationalContext(ownerCreationalContext, injectionPoint.getBean()) : (CreationalContextImpl)ownerCreationalContext;
        Bean<?> injectedBean = this.injectionResolver.getInjectionPointBean(injectionPoint);
        CreationalContextImpl injectedCreational = (CreationalContextImpl)this.createCreationalContext((Contextual)injectedBean);
        if (WebBeansUtil.isDependent(injectedBean)) {
            injectedCreational.setOwnerCreational(ownerCreationalContextImpl);
            instance = this.getReference(injectedBean, injectionPoint.getType(), injectedCreational);
            if (!WebBeansUtil.isStaticInjection(injectionPoint)) {
                ownerCreationalContextImpl.addDependent(injectedBean, instance, injectedCreational);
            }
        } else {
            instance = WebBeansUtil.getObjectFromCreationalContext(injectedBean, ownerCreationalContextImpl);
            if (instance == null) {
                instance = this.getReference(injectedBean, injectionPoint.getType(), injectedCreational);
            }
        }
        return instance;
    }

    public Set<Annotation> getInterceptorBindingDefinition(Class<? extends Annotation> binding) {
        Annotation[] annotations = binding.getDeclaredAnnotations();
        HashSet<Annotation> set = new HashSet<Annotation>();
        if (binding.isAnnotationPresent(InterceptorBinding.class)) {
            for (Annotation ann : annotations) {
                set.add(ann);
            }
        }
        return set;
    }

    @Deprecated
    public <X> Bean<? extends X> getMostSpecializedBean(Bean<X> bean) {
        Bean<?> specialized = WebBeansUtil.getMostSpecializedBean(this, bean);
        return specialized;
    }

    public Bean<?> getPassivationCapableBean(String id) {
        return this.passivationBeans.get(id);
    }

    public Object getReference(Bean<?> bean, Type beanType, CreationalContext<?> creationalContext) {
        Context context = null;
        Object instance = null;
        if (bean instanceof SerializableBean) {
            bean = ((SerializableBean)bean).getBean();
        }
        if (beanType != null && !ResolutionUtil.checkBeanTypeAssignableToGivenType(bean.getTypes(), beanType, bean instanceof NewBean)) {
            throw new IllegalArgumentException("Given bean type : " + beanType + " is not applicable for the bean instance : " + bean);
        }
        if (!(creationalContext instanceof CreationalContextImpl)) {
            creationalContext = CreationalContextFactory.getInstance().wrappedCreationalContext(creationalContext, bean);
        }
        context = this.getContext(bean.getScope());
        if (WebBeansUtil.isScopeTypeNormal(bean.getScope())) {
            instance = this.getEjbOrJmsProxyReference((Bean<?>)bean, beanType, creationalContext);
            if (instance != null) {
                return instance;
            }
            instance = JavassistProxyFactory.createNormalScopedBeanProxy((AbstractOwbBean)bean, creationalContext);
            CreationalContextImpl temp = (CreationalContextImpl)creationalContext;
            temp.setProxyInstance(instance);
        } else {
            instance = this.getEjbOrJmsProxyReference((Bean<?>)bean, beanType, creationalContext);
            if (instance != null) {
                return instance;
            }
            instance = context.get(bean, creationalContext);
            instance = JavassistProxyFactory.createDependentScopedBeanProxy((AbstractOwbBean)bean, instance, creationalContext);
        }
        return instance;
    }

    private Object getEjbOrJmsProxyReference(Bean<?> bean, Type beanType, CreationalContext<?> creationalContext) {
        if (bean instanceof EnterpriseBeanMarker) {
            OpenWebBeansEjbPlugin ejbPlugin = PluginLoader.getInstance().getEjbPlugin();
            if (ejbPlugin == null) {
                throw new IllegalStateException("There is no EJB plugin provider. Injection is failed for bean : " + bean);
            }
            return ejbPlugin.getSessionBeanProxy(bean, ClassUtil.getClazz(beanType), creationalContext);
        }
        if (bean instanceof JmsBeanMarker) {
            OpenWebBeansJmsPlugin jmsPlugin = PluginLoader.getInstance().getJmsPlugin();
            if (jmsPlugin == null) {
                throw new IllegalStateException("There is no JMS plugin provider. Injection is failed for bean : " + bean);
            }
            return jmsPlugin.getJmsBeanProxy(bean, ClassUtil.getClass(beanType));
        }
        return null;
    }

    public Set<Annotation> getStereotypeDefinition(Class<? extends Annotation> stereotype) {
        Annotation[] annotations = stereotype.getDeclaredAnnotations();
        HashSet<Annotation> set = new HashSet<Annotation>();
        if (stereotype.isAnnotationPresent(Stereotype.class)) {
            for (Annotation ann : annotations) {
                set.add(ann);
            }
        }
        return set;
    }

    public boolean isQualifier(Class<? extends Annotation> annotationType) {
        return AnnotationUtil.isQualifierAnnotation(annotationType);
    }

    public boolean isInterceptorBinding(Class<? extends Annotation> annotationType) {
        return AnnotationUtil.isInterceptorBindingAnnotation(annotationType);
    }

    public boolean isScope(Class<? extends Annotation> annotationType) {
        if (AnnotationUtil.hasAnnotation(annotationType.getDeclaredAnnotations(), Scope.class) || AnnotationUtil.hasAnnotation(annotationType.getDeclaredAnnotations(), NormalScope.class)) {
            return true;
        }
        for (ExternalScope ext : this.additionalScopes) {
            if (!ext.getScope().equals(annotationType)) continue;
            return true;
        }
        return false;
    }

    public boolean isNormalScope(Class<? extends Annotation> annotationType) {
        for (ExternalScope extScope : this.additionalScopes) {
            if (!extScope.getScope().equals(annotationType)) continue;
            return extScope.isNormal();
        }
        return AnnotationUtil.hasAnnotation(annotationType.getDeclaredAnnotations(), NormalScope.class);
    }

    public boolean isPassivatingScope(Class<? extends Annotation> annotationType) {
        for (ExternalScope extScope : this.additionalScopes) {
            if (!extScope.getScope().equals(annotationType)) continue;
            return extScope.isPassivating();
        }
        if (AnnotationUtil.hasAnnotation(annotationType.getDeclaredAnnotations(), NormalScope.class)) {
            NormalScope scope = annotationType.getAnnotation(NormalScope.class);
            return scope.passivating();
        }
        return false;
    }

    public boolean isStereotype(Class<? extends Annotation> annotationType) {
        return AnnotationUtil.hasAnnotation(annotationType.getDeclaredAnnotations(), Stereotype.class);
    }

    public <X> Bean<? extends X> resolve(Set<Bean<? extends X>> beans) {
        Set<Bean<?>> set = new HashSet();
        for (Bean<X> bean : beans) {
            set.add(bean);
        }
        if ((set = this.injectionResolver.findByAlternatives(set)).size() > 1) {
            set = this.injectionResolver.findBySpecialization(set);
        }
        if (set.size() > 0 && set.size() > 1) {
            throw new AmbiguousResolutionException("Ambigious resolution");
        }
        return set.iterator().next();
    }

    public void validate(InjectionPoint injectionPoint) {
        Bean bean = injectionPoint.getBean();
        this.injectionResolver.checkInjectionPointType(injectionPoint);
        Class<?> rawType = ClassUtil.getRawTypeForInjectionPoint(injectionPoint);
        if (rawType.equals(InjectionPoint.class)) {
            if (AnnotationUtil.hasAnnotation(AnnotationUtil.getAnnotationsFromSet(injectionPoint.getQualifiers()), Default.class) && !bean.getScope().equals(Dependent.class)) {
                throw new WebBeansConfigurationException("Bean " + bean + "scope can not define other scope except @Dependent to inject InjectionPoint");
            }
        } else {
            this.injectionResolver.checkInjectionPoints(injectionPoint);
        }
    }

    public <T> InjectionTarget<T> createInjectionTarget(AnnotatedType<T> type) {
        ManagedBean<T> bean = WebBeansAnnotatedTypeUtil.defineManagedBean(type);
        bean.setFullyInitialize(false);
        return new InjectionTargetProducer<T>(bean);
    }

    public <T> Set<ObserverMethod<? super T>> resolveObserverMethods(T event, Annotation ... qualifiers) {
        if (ClassUtil.isDefinitionConstainsTypeVariables(event.getClass())) {
            throw new IllegalArgumentException("Event type can not contain type variables. Event class is : " + event.getClass());
        }
        return this.notificationManager.resolveObservers(event, qualifiers);
    }

    public ExpressionFactory wrapExpressionFactory(ExpressionFactory expressionFactory) {
        return null;
    }

    public void addAdditionalQualifier(Class<? extends Annotation> qualifier) {
        if (!this.additionalQualifiers.contains(qualifier)) {
            this.additionalQualifiers.add(qualifier);
        }
    }

    public void addAdditionalAnnotatedType(AnnotatedType<?> annotatedType) {
        this.additionalAnnotatedTypes.add(annotatedType);
    }

    public List<Class<? extends Annotation>> getAdditionalQualifiers() {
        return this.additionalQualifiers;
    }

    public void addAdditionalScope(ExternalScope additionalScope) {
        if (!this.additionalScopes.contains(additionalScope)) {
            this.additionalScopes.add(additionalScope);
        }
    }

    public List<ExternalScope> getAdditionalScopes() {
        return this.additionalScopes;
    }
}

