/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.config;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import org.apache.webbeans.config.WebBeansFinder;
import org.apache.webbeans.exception.WebBeansConfigurationException;
import org.apache.webbeans.logger.WebBeansLogger;

public class OpenWebBeansConfiguration {
    private static final String DEFALULT_CONFIG_PROPERTIES_NAME = "META-INF/openwebbeans/openwebbeans-default.properties";
    private static final String CONFIG_PROPERTIES_NAME = "META-INF/openwebbeans/openwebbeans.properties";
    private Properties configProperties = new Properties();
    private WebBeansLogger logger = WebBeansLogger.getLogger(OpenWebBeansConfiguration.class);
    public static final String CONVERSATION_PERIODIC_DELAY = "org.apache.webbeans.conversation.Conversation.periodicDelay";
    public static final String USE_OWB_SPECIFIC_XML_CONFIGURATION = "org.apache.webbeans.useOwbSpecificXmlConfig";
    public static final String USE_OWB_SPECIFIC_FIELD_INJECTION = "org.apache.webbeans.fieldInjection.useOwbSpecificInjection";
    public static final String USE_EJB_DISCOVERY = "org.apache.webbeans.spi.deployer.UseEjbMetaDataDiscoveryService";
    public static final String CONTAINER_LIFECYCLE = "org.apache.webbeans.spi.lifecycle";
    public static final String APPLICATION_IS_JSP = "org.apache.webbeans.application.jspf";
    public static final String USE_JSF2_EXTENSIONS = "org.apache.webbeans.application.useJSF2Extensions";

    public static OpenWebBeansConfiguration getInstance() {
        return (OpenWebBeansConfiguration)WebBeansFinder.getSingletonInstance(OpenWebBeansConfiguration.class.getName());
    }

    public OpenWebBeansConfiguration() {
        this.parseConfiguration();
    }

    public synchronized void parseConfiguration() throws WebBeansConfigurationException {
        Properties newConfigProperties = new Properties();
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        InputStream is = loader.getResourceAsStream(DEFALULT_CONFIG_PROPERTIES_NAME);
        try {
            newConfigProperties.load(is);
        }
        catch (IOException ioEx) {
            throw new WebBeansConfigurationException(this.logger.getTokenString("CRITICAL_DEFAULT_CONFIG_FAILURE"), ioEx);
        }
        URL configUrl = loader.getResource(CONFIG_PROPERTIES_NAME);
        if (configUrl == null) {
            this.logger.info(this.logger.getTokenString("TEXT_CONFIG_PROP") + CONFIG_PROPERTIES_NAME + this.logger.getTokenString("TEXT_CONFIG_NOT_FOUND"));
        } else {
            this.logger.info(this.logger.getTokenString("TEXT_CONFIG_PROP") + CONFIG_PROPERTIES_NAME + this.logger.getTokenString("TEXT_CONFIG_FOUND") + configUrl.toString() + this.logger.getTokenString("TEXT_OVERRIDING"));
            is = loader.getResourceAsStream(CONFIG_PROPERTIES_NAME);
            try {
                newConfigProperties.load(is);
            }
            catch (IOException ioEx) {
                throw new WebBeansConfigurationException(this.logger.getTokenString("CRITICAL_SPECIAL_CONFIG_FAILURE"), ioEx);
            }
        }
        this.configProperties = newConfigProperties;
    }

    public String getProperty(String key) {
        return this.configProperties.getProperty(key);
    }

    public String getProperty(String key, String defaultValue) {
        return this.configProperties.getProperty(key, defaultValue);
    }

    public void setProperty(String key, Object value) {
        this.configProperties.put(key, value);
    }

    public boolean isOwbSpecificFieldInjection() {
        String value = this.getProperty(USE_OWB_SPECIFIC_FIELD_INJECTION);
        return Boolean.valueOf(value);
    }

    public boolean isUseJSF2Extensions() {
        String value = this.getProperty(USE_JSF2_EXTENSIONS);
        return Boolean.valueOf(value);
    }

    public boolean isJspApplication() {
        String value = this.getProperty(APPLICATION_IS_JSP);
        return Boolean.valueOf(value);
    }
}

