/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.config;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.util.Set;
import javax.decorator.Decorator;
import javax.interceptor.Interceptor;
import org.apache.webbeans.component.ManagedBean;
import org.apache.webbeans.component.ProducerFieldBean;
import org.apache.webbeans.component.ProducerMethodBean;
import org.apache.webbeans.component.WebBeansType;
import org.apache.webbeans.config.DefinitionUtil;
import org.apache.webbeans.container.BeanManagerImpl;
import org.apache.webbeans.exception.WebBeansConfigurationException;
import org.apache.webbeans.intercept.InterceptorUtil;
import org.apache.webbeans.util.AnnotationUtil;
import org.apache.webbeans.util.ClassUtil;
import org.apache.webbeans.util.WebBeansUtil;

public final class ManagedBeanConfigurator {
    private ManagedBeanConfigurator() {
    }

    public static void checkManagedBeanCondition(Class<?> clazz) throws WebBeansConfigurationException {
        int modifier = clazz.getModifiers();
        if (AnnotationUtil.hasClassAnnotation(clazz, Decorator.class) && AnnotationUtil.hasClassAnnotation(clazz, Interceptor.class)) {
            throw new WebBeansConfigurationException("ManagedBean implementation class : " + clazz.getName() + " may not annotated with both @Interceptor and @Decorator annotation");
        }
        if (!AnnotationUtil.hasClassAnnotation(clazz, Decorator.class) && !AnnotationUtil.hasClassAnnotation(clazz, Interceptor.class)) {
            InterceptorUtil.checkSimpleWebBeansInterceptorConditions(clazz);
        }
        if (ClassUtil.isInterface(modifier)) {
            throw new WebBeansConfigurationException("ManagedBean implementation class : " + clazz.getName() + " may not defined as interface");
        }
    }

    public static boolean isManagedBean(Class<?> clazz) throws WebBeansConfigurationException {
        try {
            WebBeansUtil.isManagedBeanClass(clazz);
        }
        catch (WebBeansConfigurationException e) {
            return false;
        }
        return true;
    }

    public static <T> ManagedBean<T> define(Class<T> clazz, WebBeansType type) throws WebBeansConfigurationException {
        BeanManagerImpl manager = BeanManagerImpl.getManager();
        ManagedBeanConfigurator.checkManagedBeanCondition(clazz);
        ManagedBean<T> component = new ManagedBean<T>(clazz, type);
        WebBeansUtil.setInjectionTargetBeanEnableFlag(component);
        DefinitionUtil.defineSerializable(component);
        DefinitionUtil.defineStereoTypes(component, clazz.getDeclaredAnnotations());
        Annotation[] clazzAnns = clazz.getDeclaredAnnotations();
        DefinitionUtil.defineApiTypes(component, clazz);
        DefinitionUtil.defineScopeType(component, clazzAnns, "Simple WebBean Component implementation class : " + clazz.getName() + " stereotypes must declare same @Scope annotations");
        WebBeansUtil.checkGenericType(component);
        DefinitionUtil.defineQualifiers(component, clazzAnns);
        DefinitionUtil.defineName(component, clazzAnns, WebBeansUtil.getManagedBeanDefaultName(clazz.getSimpleName()));
        Constructor<T> constructor = WebBeansUtil.defineConstructor(clazz);
        component.setConstructor(constructor);
        DefinitionUtil.addConstructorInjectionPointMetaData(component, constructor);
        Set<ProducerMethodBean<?>> producerMethods = DefinitionUtil.defineProducerMethods(component);
        for (ProducerMethodBean<?> producerMethod : producerMethods) {
            manager.addBean(producerMethod);
        }
        Set<ProducerFieldBean<?>> producerFields = DefinitionUtil.defineProduerFields(component);
        for (ProducerFieldBean<?> producerField : producerFields) {
            manager.addBean(producerField);
        }
        DefinitionUtil.defineDisposalMethods(component);
        DefinitionUtil.defineInjectedFields(component);
        DefinitionUtil.defineInjectedMethods(component);
        DefinitionUtil.defineObserverMethods(component, clazz);
        return component;
    }
}

