/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.component.xml;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.enterprise.context.spi.CreationalContext;
import org.apache.webbeans.component.ManagedBean;
import org.apache.webbeans.exception.WebBeansException;
import org.apache.webbeans.inject.xml.XMLInjectableConstructor;
import org.apache.webbeans.inject.xml.XMLInjectableField;
import org.apache.webbeans.inject.xml.XMLInjectableMethods;
import org.apache.webbeans.inject.xml.XMLInjectionPointModel;
import org.apache.webbeans.logger.WebBeansLogger;
import org.apache.webbeans.util.Asserts;

public class XMLManagedBean<T>
extends ManagedBean<T> {
    private static WebBeansLogger logger = WebBeansLogger.getLogger(XMLManagedBean.class);
    private XMLInjectableConstructor<T> injectableConstructor = null;
    private Map<Field, XMLInjectionPointModel> injectableFields = new HashMap<Field, XMLInjectionPointModel>();
    private Map<Method, List<XMLInjectionPointModel>> injectableMethods = new HashMap<Method, List<XMLInjectionPointModel>>();
    private Map<Field, Object> fieldValues = new HashMap<Field, Object>();

    public XMLManagedBean(Class<T> returnType) {
        super(returnType);
    }

    @Override
    protected T createInstance(CreationalContext<T> creationalContext) {
        T instance = null;
        if (this.injectableConstructor == null) {
            instance = super.createInstance(creationalContext);
        } else {
            instance = this.injectableConstructor.doInjection();
            super.afterConstructor(instance, creationalContext);
        }
        if (instance != null) {
            this.injectFieldValues(instance);
        }
        return instance;
    }

    @Override
    public void injectFields(T instance, CreationalContext<T> creationalContext) {
        Set<Field> fieldSet = this.injectableFields.keySet();
        for (Field field : fieldSet) {
            XMLInjectionPointModel model = this.injectableFields.get(field);
            XMLInjectableField injectableField = new XMLInjectableField(field, instance, this, model, creationalContext);
            injectableField.doInjection();
        }
    }

    protected void injectFieldValues(T instance) {
        Set<Field> fieldSet = this.fieldValues.keySet();
        for (Field field : fieldSet) {
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            try {
                field.set(instance, this.fieldValues.get(field));
            }
            catch (IllegalArgumentException e) {
                logger.error("ERROR_0016", new Object[]{field.getName(), instance.getClass().getName()});
                throw new WebBeansException(e);
            }
            catch (IllegalAccessException e) {
                logger.error("ERROR_0017", new Object[]{field.getName(), instance.getClass().getName()});
                throw new WebBeansException(e);
            }
        }
    }

    @Override
    public void injectMethods(T instance, CreationalContext<T> creationalContext) {
        Set<Method> methodSet = this.injectableMethods.keySet();
        for (Method method : methodSet) {
            List<XMLInjectionPointModel> listInjectionPointModel = this.injectableMethods.get(method);
            XMLInjectableMethods injectableMethod = new XMLInjectableMethods(method, instance, this, listInjectionPointModel, creationalContext);
            injectableMethod.doInjection();
        }
    }

    public void setInjectableConstructor(XMLInjectableConstructor<T> constructor) {
        Asserts.assertNotNull(constructor, "constructor parameter can not be null");
        this.injectableConstructor = constructor;
    }

    public void addFieldInjectionPoint(Field field, XMLInjectionPointModel model) {
        Asserts.assertNotNull(field, "field parameter can not be null");
        Asserts.assertNotNull(model, "model parameter can not be null");
        this.injectableFields.put(field, model);
    }

    public void addMethodInjectionPoint(Method method, XMLInjectionPointModel model) {
        Asserts.assertNotNull(method, "method parameter can not be null");
        List<XMLInjectionPointModel> listModel = this.injectableMethods.get(method);
        if (listModel == null) {
            listModel = new ArrayList<XMLInjectionPointModel>();
            this.injectableMethods.put(method, listModel);
        }
        if (model != null) {
            listModel.add(model);
        }
    }

    public void addFieldValue(Field name, Object value) {
        this.fieldValues.put(name, value);
    }

    public Map<Field, Object> getFieldValues() {
        return this.fieldValues;
    }
}

