/*
 * Decompiled with CFR 0.152.
 */
package org.apache.webbeans.ejb.resource;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import javax.enterprise.inject.Produces;
import org.apache.webbeans.api.ResourceReference;
import org.apache.webbeans.ejb.resource.ResourceFactory;
import org.apache.webbeans.exception.WebBeansConfigurationException;
import org.apache.webbeans.exception.WebBeansException;
import org.apache.webbeans.logger.WebBeansLogger;
import org.apache.webbeans.spi.ResourceInjectionService;
import org.apache.webbeans.util.AnnotationUtil;

public class OpenEjbResourceInjectionService
implements ResourceInjectionService {
    private static final WebBeansLogger logger = WebBeansLogger.getLogger(OpenEjbResourceInjectionService.class);

    public void clear() {
    }

    public <X, T extends Annotation> X getResourceReference(ResourceReference<X, T> resourceReference) {
        try {
            return ResourceFactory.getInstance().getResourceReference(resourceReference);
        }
        catch (Exception e) {
            logger.error("Unable to get resource with class " + resourceReference.getResourceType() + " in " + resourceReference.getOwnerClass() + " with name " + resourceReference.getName(), (Throwable)e);
            throw new WebBeansConfigurationException("Unable to get resource with class " + resourceReference.getResourceType() + " in " + resourceReference.getOwnerClass() + " with name " + resourceReference.getName(), (Throwable)e);
        }
    }

    public void injectJavaEEResources(Object managedBeanInstance) throws Exception {
        Field[] fields;
        for (Field field : fields = managedBeanInstance.getClass().getDeclaredFields()) {
            Annotation ann;
            if (field.isAnnotationPresent(Produces.class) || Modifier.isStatic(field.getModifiers()) || (ann = AnnotationUtil.hasOwbInjectableResource((Annotation[])field.getDeclaredAnnotations())) == null) continue;
            ResourceReference resourceRef = new ResourceReference(field.getDeclaringClass(), field.getName(), field.getType(), ann);
            boolean acess = field.isAccessible();
            try {
                field.setAccessible(true);
                field.set(managedBeanInstance, this.getResourceReference(resourceRef));
            }
            catch (Exception e) {
                logger.error("Unable to inject field : " + field);
                throw new WebBeansException("Unable to inject field : " + field, (Throwable)e);
            }
            finally {
                field.setAccessible(acess);
            }
        }
    }
}

