/*
 * Decompiled with CFR 0.152.
 */
package opennlp.uima.tokenize;

import opennlp.tools.util.Span;
import opennlp.uima.util.AnnotatorUtil;
import opennlp.uima.util.UimaUtil;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_component.CasAnnotator_ImplBase;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.cas.text.AnnotationIndex;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.util.Level;
import org.apache.uima.util.Logger;

public abstract class AbstractTokenizer
extends CasAnnotator_ImplBase {
    protected final String name;
    protected UimaContext context;
    protected Logger logger;
    protected Type sentenceType;
    protected Type tokenType;
    private Boolean isRemoveExistingAnnotations;

    protected AbstractTokenizer(String name) {
        this.name = name;
    }

    public void initialize(UimaContext context) throws ResourceInitializationException {
        super.initialize(context);
        this.context = context;
        this.logger = context.getLogger();
        if (this.logger.isLoggable(Level.INFO)) {
            this.logger.log(Level.INFO, "Initializing the " + this.name + " annotator.");
        }
        this.isRemoveExistingAnnotations = AnnotatorUtil.getOptionalBooleanParameter(context, "opennlp.uima.IsRemoveExistingAnnotations");
        if (this.isRemoveExistingAnnotations == null) {
            this.isRemoveExistingAnnotations = false;
        }
    }

    public void typeSystemInit(TypeSystem typeSystem) throws AnalysisEngineProcessException {
        super.typeSystemInit(typeSystem);
        this.sentenceType = AnnotatorUtil.getRequiredTypeParameter(this.context, typeSystem, "opennlp.uima.SentenceType");
        this.tokenType = AnnotatorUtil.getRequiredTypeParameter(this.context, typeSystem, "opennlp.uima.TokenType");
    }

    protected void postProcessAnnotations(Span[] tokens, AnnotationFS[] tokenAnnotations) {
    }

    protected abstract Span[] tokenize(CAS var1, AnnotationFS var2);

    public void process(CAS cas) throws AnalysisEngineProcessException {
        AnnotationIndex sentences = cas.getAnnotationIndex(this.sentenceType);
        for (AnnotationFS sentence : sentences) {
            if (this.isRemoveExistingAnnotations.booleanValue()) {
                UimaUtil.removeAnnotations(cas, sentence, this.tokenType);
            }
            Span[] tokenSpans = this.tokenize(cas, sentence);
            int sentenceOffset = sentence.getBegin();
            StringBuilder tokeninzedSentenceLog = new StringBuilder();
            AnnotationFS[] tokenAnnotations = new AnnotationFS[tokenSpans.length];
            for (int i = 0; i < tokenSpans.length; ++i) {
                tokenAnnotations[i] = cas.createAnnotation(this.tokenType, sentenceOffset + tokenSpans[i].getStart(), sentenceOffset + tokenSpans[i].getEnd());
                cas.getIndexRepository().addFS((FeatureStructure)tokenAnnotations[i]);
                if (!this.logger.isLoggable(Level.FINER)) continue;
                tokeninzedSentenceLog.append(tokenAnnotations[i].getCoveredText());
                tokeninzedSentenceLog.append(' ');
            }
            if (this.logger.isLoggable(Level.FINER)) {
                tokeninzedSentenceLog.delete(tokeninzedSentenceLog.length() - 2, tokeninzedSentenceLog.length() - 1);
                this.logger.log(Level.FINER, "\"" + tokeninzedSentenceLog.toString() + "\"");
            }
            this.postProcessAnnotations(tokenSpans, tokenAnnotations);
        }
    }
}

