/*
 * Decompiled with CFR 0.152.
 */
package opennlp.uima.namefind;

import opennlp.tools.namefind.NameFinderME;
import opennlp.tools.namefind.TokenNameFinderModel;
import opennlp.tools.util.Span;
import opennlp.tools.util.eval.Mean;
import opennlp.uima.namefind.AbstractNameFinder;
import opennlp.uima.namefind.TokenNameFinderModelResource;
import opennlp.uima.util.AnnotatorUtil;
import opennlp.uima.util.UimaUtil;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.FeatureStructure;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.resource.ResourceAccessException;
import org.apache.uima.resource.ResourceInitializationException;

public final class NameFinder
extends AbstractNameFinder {
    public static final String NAME_TYPE_PARAMETER = "opennlp.uima.NameType";
    public static final String NAME_TYPE_MAP_PARAMETER = "opennlp.uima.NameTypeMap";
    public static final String TOKEN_PATTERN_OPTIMIZATION = "opennlp.uima.TokenPatternOptimization";
    public static final String TOKEN_FEATURE_PARAMETER = "opennlp.uima.namefinder.TokenFeature";
    public static final String TOKEN_FEATURE_PREV_WINDOW_SIZE_PARAMETER = "opennlp.uima.namefinder.TokenFeature.previousWindowSize";
    public static final String TOKEN_FEATURE_NEXT_WINDOW_SIZE_PARAMETER = "opennlp.uima.namefinder.TokenFeature.nextWindowSize";
    public static final String TOKEN_CLASS_FEATURE_PARAMETER = "opennlp.uima.namefinder.TokenClassFeature";
    public static final String TOKEN_CLASS_FEATURE_PREV_WINDOW_SIZE_PARAMETER = "opennlp.uima.namefinder.TokenClassFeature.previousWindowSize";
    public static final String TOKEN_CLASS_FEATURE_NEXT_WINDOW_SIZE_PARAMETER = "opennlp.uima.namefinder.TokenClassFeature.nextWindowSize";
    private NameFinderME mNameFinder;
    private Feature probabilityFeature;
    private Type documentConfidenceType;
    private Feature documentConfidenceNameTypeFeature;
    private Feature documentConfidenceFeature;
    private Mean documentConfidence = new Mean();

    public NameFinder() {
        super("OpenNLP Maxent Name annotator");
    }

    @Override
    public void initialize() throws ResourceInitializationException {
        TokenNameFinderModel model;
        super.initialize();
        try {
            TokenNameFinderModelResource modelResource = (TokenNameFinderModelResource)this.context.getResourceObject(UimaUtil.MODEL_PARAMETER);
            model = modelResource.getModel();
        }
        catch (ResourceAccessException e) {
            throw new ResourceInitializationException((Throwable)e);
        }
        this.mNameFinder = new NameFinderME(model);
    }

    @Override
    public void typeSystemInit(TypeSystem typeSystem) throws AnalysisEngineProcessException {
        super.typeSystemInit(typeSystem);
        this.probabilityFeature = AnnotatorUtil.getOptionalFeatureParameter(this.context, this.mNameType, "opennlp.uima.ProbabilityFeature", "uima.cas.Double");
        this.documentConfidenceType = AnnotatorUtil.getOptionalTypeParameter(this.context, typeSystem, "opennlp.uima.DocumentConfidenceType");
        if (this.documentConfidenceType != null) {
            this.documentConfidenceNameTypeFeature = AnnotatorUtil.getRequiredFeature(this.documentConfidenceType, "nameType");
            this.documentConfidenceFeature = AnnotatorUtil.getRequiredFeature(this.documentConfidenceType, "confidence");
        }
    }

    @Override
    protected Span[] find(CAS cas, String[] tokens) {
        double[] probs;
        Span[] names = this.mNameFinder.find(tokens);
        for (double prob : probs = this.mNameFinder.probs()) {
            this.documentConfidence.add(prob);
        }
        return names;
    }

    @Override
    protected void postProcessAnnotations(Span[] detectedNames, AnnotationFS[] nameAnnotations) {
        if (this.probabilityFeature != null) {
            double[] probs = this.mNameFinder.probs(detectedNames);
            for (int i = 0; i < nameAnnotations.length; ++i) {
                nameAnnotations[i].setDoubleValue(this.probabilityFeature, probs[i]);
            }
        }
    }

    @Override
    protected void documentDone(CAS cas) {
        if (this.documentConfidenceType != null) {
            FeatureStructure confidenceFS = cas.createFS(this.documentConfidenceType);
            confidenceFS.setDoubleValue(this.documentConfidenceFeature, this.documentConfidence.mean());
            confidenceFS.setStringValue(this.documentConfidenceNameTypeFeature, this.mNameType.getName());
            cas.addFsToIndexes(confidenceFS);
        }
        this.mNameFinder.clearAdaptiveData();
        this.documentConfidence = new Mean();
    }

    public void destroy() {
        this.mNameFinder = null;
    }
}

