/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.formats.masc;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.xml.parsers.SAXParser;
import opennlp.tools.formats.masc.MascDocument;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.XmlUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class MascDocumentStream
implements ObjectStream<MascDocument> {
    private static final Logger logger = LoggerFactory.getLogger(MascDocumentStream.class);
    private final List<MascDocument> documents = new LinkedList<MascDocument>();
    private Iterator<MascDocument> documentIterator;
    private final SAXParser saxParser = XmlUtil.createSaxParser();

    public MascDocumentStream(File mascCorpusDirectory) throws IOException {
        this(mascCorpusDirectory, true, pathname -> pathname.getName().contains(""));
    }

    public MascDocumentStream(File mascCorpusDirectory, boolean searchRecursive, FileFilter fileFilter) throws IOException {
        if (!mascCorpusDirectory.isDirectory()) {
            throw new IOException("Input corpus directory must be a directory according to File.isDirectory()!");
        }
        int failedLoads = 0;
        Stack<File> directoryStack = new Stack<File>();
        directoryStack.add(mascCorpusDirectory);
        while (!directoryStack.isEmpty()) {
            for (File file : ((File)directoryStack.pop()).listFiles(fileFilter)) {
                if (file.isFile()) {
                    String hdrFilePath = file.getAbsolutePath();
                    if (!hdrFilePath.endsWith(".hdr")) continue;
                    HashMap<String, File> fileGroup = this.checkAnnotations(hdrFilePath);
                    BufferedInputStream f_primary = new BufferedInputStream(new FileInputStream(fileGroup.get("f.text")));
                    BufferedInputStream f_seg = fileGroup.containsKey("f.seg") ? new BufferedInputStream(new FileInputStream(fileGroup.get("f.seg"))) : null;
                    BufferedInputStream f_penn = fileGroup.containsKey("f.penn") ? new BufferedInputStream(new FileInputStream(fileGroup.get("f.penn"))) : null;
                    BufferedInputStream f_s = fileGroup.containsKey("f.s") ? new BufferedInputStream(new FileInputStream(fileGroup.get("f.s"))) : null;
                    BufferedInputStream f_ne = fileGroup.containsKey("f.ne") ? new BufferedInputStream(new FileInputStream(fileGroup.get("f.ne"))) : null;
                    try {
                        this.documents.add(MascDocument.parseDocument(hdrFilePath, f_primary, f_seg, f_penn, f_s, f_ne));
                    }
                    catch (IOException e) {
                        logger.error("Failed to parse the file: {}", (Object)hdrFilePath, (Object)e);
                        ++failedLoads;
                    }
                    continue;
                }
                if (!searchRecursive || !file.isDirectory()) continue;
                directoryStack.push(file);
            }
        }
        logger.info("Documents loaded: {}", (Object)this.documents.size());
        if (failedLoads > 0) {
            logger.info("Failed loading {} documents.", (Object)failedLoads);
        }
        this.reset();
    }

    private HashMap<String, File> checkAnnotations(String path) throws IOException {
        HeaderHandler handler = new HeaderHandler();
        HashMap<String, File> fileGroup = new HashMap<String, File>();
        File hdrFile = new File(path);
        try {
            this.saxParser.parse(hdrFile, (DefaultHandler)handler);
        }
        catch (SAXException e) {
            throw new IOException("Invalid corpus format. Could not parse the header: " + path);
        }
        HashMap<String, String> annotationFiles = handler.getPathList();
        String pathToFolder = hdrFile.getParentFile().getAbsolutePath();
        for (Map.Entry<String, String> annotation : annotationFiles.entrySet()) {
            File file = new File(pathToFolder, annotation.getValue());
            if (!file.isFile() || !file.exists()) {
                throw new IOException("Corpus integrity violated. Annotation file " + file.getAbsolutePath() + " is missing.");
            }
            fileGroup.put(annotation.getKey(), file);
        }
        return fileGroup;
    }

    @Override
    public void reset() {
        for (MascDocument doc : this.documents) {
            doc.reset();
        }
        this.documentIterator = this.documents.iterator();
    }

    @Override
    public MascDocument read() throws IOException {
        MascDocument doc = null;
        if (this.documentIterator.hasNext()) {
            doc = this.documentIterator.next();
        }
        return doc;
    }

    @Override
    public void close() {
        this.documentIterator = null;
    }

    private static class HeaderHandler
    extends DefaultHandler {
        private HashMap<String, String> annotationFiles = null;
        private String file = null;
        private String fType = null;

        private HeaderHandler() {
        }

        protected HashMap<String, String> getPathList() {
            return this.annotationFiles;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (qName.equalsIgnoreCase("annotation") || qName.equalsIgnoreCase("primaryData")) {
                this.file = attributes.getValue("loc");
                this.fType = attributes.getValue("f.id");
                if (this.annotationFiles == null) {
                    this.annotationFiles = new HashMap();
                }
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            if (qName.equalsIgnoreCase("annotation") || qName.equalsIgnoreCase("primaryData")) {
                this.annotationFiles.put(this.fType, this.file);
            }
        }
    }
}

