/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.parser;

import java.io.IOException;
import opennlp.tools.parser.HeadRules;
import opennlp.tools.parser.Parse;
import opennlp.tools.parser.ParserEvaluationMonitor;
import opennlp.tools.parser.ParserEvaluator;
import opennlp.tools.parser.ParserFactory;
import opennlp.tools.parser.ParserModel;
import opennlp.tools.parser.ParserType;
import opennlp.tools.parser.treeinsert.Parser;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.TrainingParameters;
import opennlp.tools.util.eval.CrossValidationPartitioner;
import opennlp.tools.util.eval.FMeasure;

public class ParserCrossValidator {
    private final String languageCode;
    private final TrainingParameters params;
    private final HeadRules rules;
    private final FMeasure fmeasure = new FMeasure();
    private final ParserType parserType;
    private final ParserEvaluationMonitor[] monitors;

    public ParserCrossValidator(String languageCode, TrainingParameters params, HeadRules rules, ParserType parserType, ParserEvaluationMonitor ... monitors) {
        this.languageCode = languageCode;
        this.params = params;
        this.rules = rules;
        this.parserType = parserType;
        this.monitors = monitors;
    }

    public void evaluate(ObjectStream<Parse> samples, int nFolds) throws IOException {
        CrossValidationPartitioner<Parse> partitioner = new CrossValidationPartitioner<Parse>(samples, nFolds);
        while (partitioner.hasNext()) {
            CrossValidationPartitioner.TrainingSampleStream<Parse> trainingSampleStream = partitioner.next();
            try {
                ParserModel model;
                if (ParserType.CHUNKING.equals((Object)this.parserType)) {
                    model = opennlp.tools.parser.chunking.Parser.train(this.languageCode, samples, this.rules, this.params);
                } else if (ParserType.TREEINSERT.equals((Object)this.parserType)) {
                    model = Parser.train(this.languageCode, samples, this.rules, this.params);
                } else {
                    throw new IllegalStateException("Unexpected parser type: " + this.parserType);
                }
                ParserEvaluator evaluator = new ParserEvaluator(ParserFactory.create(model), this.monitors);
                evaluator.evaluate(trainingSampleStream.getTestSampleStream());
                this.fmeasure.mergeInto(evaluator.getFMeasure());
            }
            finally {
                if (trainingSampleStream == null) continue;
                trainingSampleStream.close();
            }
        }
    }

    public FMeasure getFMeasure() {
        return this.fmeasure;
    }
}

