/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.util;

import java.util.Arrays;

public record TokenTag(String token, String tag, String[] additionalData) {
    public TokenTag(String token, String tag, String[] additionalData) {
        this.token = token;
        this.tag = tag;
        this.additionalData = additionalData != null ? Arrays.copyOf(additionalData, additionalData.length) : null;
    }

    @Deprecated(forRemoval=true)
    public String getToken() {
        return this.token;
    }

    @Deprecated(forRemoval=true)
    public String getTag() {
        return this.tag;
    }

    @Deprecated(forRemoval=true)
    public String[] getAdditionalData() {
        return this.additionalData;
    }

    public static String[] extractTokens(TokenTag[] tuples) {
        String[] tokens = new String[tuples.length];
        for (int i = 0; i < tuples.length; ++i) {
            tokens[i] = tuples[i].token();
        }
        return tokens;
    }

    public static String[] extractTags(TokenTag[] tuples) {
        String[] tags = new String[tuples.length];
        for (int i = 0; i < tuples.length; ++i) {
            tags[i] = tuples[i].tag();
        }
        return tags;
    }

    public static TokenTag[] create(String[] toks, String[] tags) {
        TokenTag[] tuples = new TokenTag[toks.length];
        for (int i = 0; i < toks.length; ++i) {
            tuples[i] = new TokenTag(toks[i], tags[i], null);
        }
        return tuples;
    }

    @Override
    public String toString() {
        return this.token + "_" + this.tag;
    }
}

