/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.langdetect;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import opennlp.tools.langdetect.Language;
import opennlp.tools.langdetect.LanguageDetector;
import opennlp.tools.langdetect.LanguageDetectorConfig;
import opennlp.tools.langdetect.LanguageDetectorContextGenerator;
import opennlp.tools.langdetect.LanguageDetectorEventStream;
import opennlp.tools.langdetect.LanguageDetectorFactory;
import opennlp.tools.langdetect.LanguageDetectorModel;
import opennlp.tools.langdetect.LanguageSample;
import opennlp.tools.langdetect.ProbingLanguageDetectionResult;
import opennlp.tools.ml.EventTrainer;
import opennlp.tools.ml.TrainerFactory;
import opennlp.tools.ml.model.MaxentModel;
import opennlp.tools.util.MutableInt;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.TrainingParameters;

public class LanguageDetectorME
implements LanguageDetector {
    protected LanguageDetectorModel model;
    private final LanguageDetectorContextGenerator mContextGenerator;

    public LanguageDetectorME(LanguageDetectorModel model) {
        this.model = model;
        this.mContextGenerator = model.getFactory().getContextGenerator();
    }

    @Override
    public Language[] predictLanguages(CharSequence content) {
        return this.predict(this.arrayToCounts(this.mContextGenerator.getContext(content)));
    }

    @Override
    public Language predictLanguage(CharSequence content) {
        return this.predictLanguages(content)[0];
    }

    @Override
    public String[] getSupportedLanguages() {
        int numberLanguages = this.model.getMaxentModel().getNumOutcomes();
        String[] languages = new String[numberLanguages];
        for (int i = 0; i < numberLanguages; ++i) {
            languages[i] = this.model.getMaxentModel().getOutcome(i);
        }
        return languages;
    }

    public ProbingLanguageDetectionResult probingPredictLanguages(CharSequence content) {
        return this.probingPredictLanguages(content, LanguageDetectorConfig.DEFAULT_LANGUAGE_DETECTOR_CONFIG);
    }

    public ProbingLanguageDetectionResult probingPredictLanguages(CharSequence content, LanguageDetectorConfig config) {
        LinkedList<Language[]> predictions = new LinkedList<Language[]>();
        int start = 0;
        Language[] currPredictions = null;
        HashMap<CharSequence, MutableInt> ngramCounts = new HashMap<CharSequence, MutableInt>();
        do {
            int actualChunkSize;
            StringCPLengthPair chunk;
            if ((chunk = this.chunk(content, start, actualChunkSize = start + config.getChunkSize() > config.getMaxLength() ? config.getMaxLength() - start : config.getChunkSize())).length() == 0) {
                if (currPredictions == null) {
                    return new ProbingLanguageDetectionResult(this.predict(ngramCounts), start);
                }
                return new ProbingLanguageDetectionResult(currPredictions, start);
            }
            start += chunk.length();
            this.updateCounts(this.mContextGenerator.getContext(chunk.s), ngramCounts);
        } while (!this.seenEnough(predictions, currPredictions = this.predict(ngramCounts), ngramCounts, config));
        return new ProbingLanguageDetectionResult(currPredictions, start);
    }

    private void updateCounts(CharSequence[] context, Map<CharSequence, MutableInt> ngrams) {
        for (CharSequence ngram : context) {
            MutableInt i = ngrams.get(ngram);
            if (i == null) {
                i = new MutableInt(1);
                ngrams.put(ngram, i);
                continue;
            }
            i.increment();
        }
    }

    private Map<CharSequence, MutableInt> arrayToCounts(CharSequence[] context) {
        HashMap<CharSequence, MutableInt> ngrams = new HashMap<CharSequence, MutableInt>();
        this.updateCounts(context, ngrams);
        return ngrams;
    }

    private Language[] predict(Map<CharSequence, MutableInt> ngramCounts) {
        String[] allGrams = new String[ngramCounts.size()];
        float[] counts = new float[ngramCounts.size()];
        int i = 0;
        for (Map.Entry<CharSequence, MutableInt> e : ngramCounts.entrySet()) {
            allGrams[i] = e.getKey().toString();
            counts[i] = 1.0f;
            ++i;
        }
        double[] eval = this.model.getMaxentModel().eval(allGrams, counts);
        Language[] arr = new Language[eval.length];
        for (int j = 0; j < eval.length; ++j) {
            arr[j] = new Language(this.model.getMaxentModel().getOutcome(j), eval[j]);
        }
        Arrays.sort(arr, (o1, o2) -> Double.compare(o2.getConfidence(), o1.getConfidence()));
        return arr;
    }

    boolean seenEnough(List<Language[]> predictionsQueue, Language[] newPredictions, Map<CharSequence, MutableInt> ngramCounts, LanguageDetectorConfig config) {
        if (predictionsQueue.size() < config.getMinConsecImprovements()) {
            predictionsQueue.add(newPredictions);
            return false;
        }
        if (predictionsQueue.size() > config.getMinConsecImprovements() && predictionsQueue.size() > 0) {
            predictionsQueue.remove(0);
        }
        predictionsQueue.add(newPredictions);
        if (config.getMinDiff() > 0.0 && newPredictions[0].getConfidence() - newPredictions[1].getConfidence() < config.getMinDiff()) {
            return false;
        }
        String lastLang = null;
        double lastConf = -1.0;
        for (Language[] predictions : predictionsQueue) {
            if (lastLang == null) {
                lastLang = predictions[0].getLang();
                lastConf = predictions[0].getConfidence();
                continue;
            }
            if (!lastLang.equals(predictions[0].getLang())) {
                return false;
            }
            if (lastConf > predictions[0].getConfidence()) {
                return false;
            }
            lastLang = predictions[0].getLang();
            lastConf = predictions[0].getConfidence();
        }
        return true;
    }

    private StringCPLengthPair chunk(CharSequence content, int start, int chunkSize) {
        if (start == 0 && chunkSize > content.length()) {
            String s = content.toString();
            int codePointLength = s.codePointCount(0, s.length());
            return new StringCPLengthPair(s, codePointLength);
        }
        int[] codepoints = content.codePoints().skip(start).limit(chunkSize).toArray();
        return new StringCPLengthPair(new String(codepoints, 0, codepoints.length), codepoints.length);
    }

    public static LanguageDetectorModel train(ObjectStream<LanguageSample> samples, TrainingParameters mlParams, LanguageDetectorFactory factory) throws IOException {
        HashMap<String, String> manifestInfoEntries = new HashMap<String, String>();
        mlParams.putIfAbsent("DataIndexer", "OnePass");
        EventTrainer trainer = TrainerFactory.getEventTrainer(mlParams, manifestInfoEntries);
        MaxentModel model = trainer.train(new LanguageDetectorEventStream(samples, factory.getContextGenerator()));
        return new LanguageDetectorModel(model, manifestInfoEntries, factory);
    }

    private record StringCPLengthPair(String s, int length) {
        String getString() {
            return this.s;
        }
    }
}

