/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.util;

import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import opennlp.tools.util.ObjectStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectStreamUtils {
    public static <T> ObjectStream<T> createObjectStream(final T ... array) {
        return new ObjectStream<T>(){
            private int index = 0;

            @Override
            public T read() {
                if (this.index < array.length) {
                    return array[this.index++];
                }
                return null;
            }

            @Override
            public void reset() {
                this.index = 0;
            }

            @Override
            public void close() {
            }
        };
    }

    public static <T> ObjectStream<T> createObjectStream(final Collection<T> collection) {
        return new ObjectStream<T>(){
            private Iterator<T> iterator;
            {
                this.iterator = collection.iterator();
            }

            @Override
            public T read() {
                if (this.iterator.hasNext()) {
                    return this.iterator.next();
                }
                return null;
            }

            @Override
            public void reset() {
                this.iterator = collection.iterator();
            }

            @Override
            public void close() {
            }
        };
    }

    public static <T> ObjectStream<T> createObjectStream(final ObjectStream<T> ... streams) {
        for (ObjectStream<T> stream : streams) {
            if (stream != null) continue;
            throw new NullPointerException("stream cannot be null");
        }
        return new ObjectStream<T>(){
            private int streamIndex = 0;

            @Override
            public T read() throws IOException {
                Object object = null;
                while (this.streamIndex < streams.length && object == null) {
                    object = streams[this.streamIndex].read();
                    if (object != null) continue;
                    ++this.streamIndex;
                }
                return object;
            }

            @Override
            public void reset() throws IOException, UnsupportedOperationException {
                this.streamIndex = 0;
                for (ObjectStream stream : streams) {
                    stream.reset();
                }
            }

            @Override
            public void close() throws IOException {
                for (ObjectStream stream : streams) {
                    stream.close();
                }
            }
        };
    }
}

