/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.kernel.exps;

import java.util.Collection;
import java.util.Map;
import org.apache.openjpa.conf.OpenJPAConfiguration;
import org.apache.openjpa.jdbc.kernel.exps.Const;
import org.apache.openjpa.jdbc.kernel.exps.ExpContext;
import org.apache.openjpa.jdbc.kernel.exps.ExpState;
import org.apache.openjpa.jdbc.kernel.exps.Type;
import org.apache.openjpa.jdbc.kernel.exps.Val;
import org.apache.openjpa.jdbc.meta.ClassMapping;
import org.apache.openjpa.jdbc.meta.Discriminator;
import org.apache.openjpa.jdbc.sql.SQLBuffer;
import org.apache.openjpa.jdbc.sql.Select;
import org.apache.openjpa.kernel.Filters;
import org.apache.openjpa.kernel.exps.Parameter;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.util.ImplHelper;

public class Param
extends Const
implements Parameter {
    private static final Localizer _loc = Localizer.forPackage(Param.class);
    private final Object _key;
    private Class _type = null;
    private int _idx = -1;
    private boolean _container = false;

    public Param(Object key, Class type) {
        this._key = key;
        this.setImplicitType(type);
    }

    public Object getParameterKey() {
        return this._key;
    }

    public Class getType() {
        return this._type;
    }

    public void setImplicitType(Class type) {
        this._type = type;
        this._container = !(this.getMetaData() != null && ImplHelper.isManagedType((OpenJPAConfiguration)this.getMetaData().getRepository().getConfiguration(), (Class)type) || !Collection.class.isAssignableFrom(type) && !Map.class.isAssignableFrom(type));
    }

    public int getIndex() {
        return this._idx;
    }

    public void setIndex(int idx) {
        this._idx = idx;
    }

    public ClassMapping getValueMetaData(ExpContext ctx) {
        Object[] params = ctx.params;
        if (params[this._idx] != null && params[this._idx] instanceof Class) {
            return (ClassMapping)ctx.store.getConfiguration().getMetaDataRepositoryInstance().getMetaData((Class)params[this._idx], this.getClass().getClassLoader(), true);
        }
        return null;
    }

    public Object getValue(Object[] params) {
        return Filters.convert((Object)params[this._idx], (Class)this.getType());
    }

    @Override
    public Object getValue(ExpContext ctx, ExpState state) {
        ParamExpState pstate = (ParamExpState)state;
        return pstate.discValue != null ? pstate.discValue : this.getValue(ctx.params);
    }

    @Override
    public Object getSQLValue(Select sel, ExpContext ctx, ExpState state) {
        return ((ParamExpState)state).sqlValue;
    }

    @Override
    public ExpState initialize(Select sel, ExpContext ctx, int flags) {
        return new ParamExpState();
    }

    @Override
    public void calculateValue(Select sel, ExpContext ctx, ExpState state, Val other, ExpState otherState) {
        super.calculateValue(sel, ctx, state, other, otherState);
        Object val = this.getValue(ctx.params);
        ParamExpState pstate = (ParamExpState)state;
        if (other != null && !this._container) {
            pstate.sqlValue = other.toDataStoreValue(sel, ctx, otherState, val);
            pstate.otherLength = other.length(sel, ctx, otherState);
            if (other instanceof Type) {
                pstate.mapping = ctx.store.getConfiguration().getMappingRepositoryInstance().getMapping((Class)val, ctx.store.getContext().getClassLoader(), true);
                pstate.disc = pstate.mapping.getDiscriminator();
                pstate.discValue = pstate.disc.getValue() != null ? pstate.disc.getValue() : "1";
            }
        } else if (ImplHelper.isManageable((Object)val)) {
            ClassMapping mapping = ctx.store.getConfiguration().getMappingRepositoryInstance().getMapping(val.getClass(), ctx.store.getContext().getClassLoader(), true);
            pstate.sqlValue = mapping.toDataStoreValue(val, mapping.getPrimaryKeyColumns(), ctx.store);
            pstate.otherLength = mapping.getPrimaryKeyColumns().length;
        } else {
            pstate.sqlValue = val;
        }
    }

    @Override
    public void appendTo(Select sel, ExpContext ctx, ExpState state, SQLBuffer sql, int index) {
        ParamExpState pstate = (ParamExpState)state;
        if (pstate.otherLength > 1) {
            sql.appendValue(((Object[])pstate.sqlValue)[index], pstate.getColumn(index), this);
        } else if (pstate.cols != null) {
            sql.appendValue(pstate.sqlValue, pstate.getColumn(index), this);
        } else if (pstate.discValue != null) {
            sql.appendValue(pstate.discValue);
        } else {
            sql.appendValue(pstate.sqlValue, pstate.getColumn(index), this);
        }
    }

    @Override
    public int length(Select sel, ExpContext ctx, ExpState state) {
        ParamExpState pstate = (ParamExpState)state;
        if (this.getMetaData() == null || pstate.cols == null) {
            return 1;
        }
        return pstate.cols.length;
    }

    public static class ParamExpState
    extends Const.ConstExpState {
        public Object sqlValue = null;
        public int otherLength = 1;
        public ClassMapping mapping = null;
        public Discriminator disc = null;
        public Object discValue = null;
    }
}

