/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.meta;

import java.io.ByteArrayInputStream;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.apache.openjpa.enhance.PCEnhancer;
import org.apache.openjpa.lib.util.J2DoPrivHelper;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.lib.util.StringUtil;
import org.apache.openjpa.meta.ClassMetaData;
import org.apache.openjpa.meta.FieldMetaData;
import org.apache.openjpa.meta.MetaDataRepository;
import org.apache.openjpa.util.InternalException;
import serp.bytecode.BCClass;
import serp.bytecode.BCClassLoader;
import serp.bytecode.BCField;
import serp.bytecode.BCMethod;
import serp.bytecode.Code;
import serp.bytecode.Project;

class InterfaceImplGenerator {
    private static final Localizer _loc = Localizer.forPackage(InterfaceImplGenerator.class);
    private static final String POSTFIX = "openjpaimpl";
    private final MetaDataRepository _repos;
    private final Map<Class<?>, Class<?>> _impls = new WeakHashMap();
    private final Project _project = new Project();
    private final Project _enhProject = new Project();

    public InterfaceImplGenerator(MetaDataRepository repos) {
        this._repos = repos;
    }

    public synchronized Class<?> createImpl(ClassMetaData meta) {
        Class<?> iface = meta.getDescribedType();
        Class<?> impl = this._impls.get(iface);
        if (impl != null) {
            return impl;
        }
        ClassLoader parentLoader = AccessController.doPrivileged(J2DoPrivHelper.getClassLoaderAction(iface));
        BCClassLoader loader = AccessController.doPrivileged(J2DoPrivHelper.newBCClassLoaderAction(this._project, parentLoader));
        BCClassLoader enhLoader = AccessController.doPrivileged(J2DoPrivHelper.newBCClassLoaderAction(this._enhProject, parentLoader));
        BCClass bc = this._project.loadClass(this.getClassName(meta));
        bc.declareInterface(iface);
        ClassMetaData sup = meta.getPCSuperclassMetaData();
        if (sup != null) {
            bc.setSuperclass(sup.getInterfaceImpl());
            enhLoader = AccessController.doPrivileged(J2DoPrivHelper.newBCClassLoaderAction(this._enhProject, AccessController.doPrivileged(J2DoPrivHelper.getClassLoaderAction(sup.getInterfaceImpl()))));
        }
        FieldMetaData[] fields = meta.getDeclaredFields();
        HashSet<Method> methods = new HashSet<Method>();
        for (int i = 0; i < fields.length; ++i) {
            this.addField(bc, iface, fields[i], methods);
        }
        this.invalidateNonBeanMethods(bc, iface, methods);
        try {
            meta.setInterfaceImpl(Class.forName(bc.getName(), true, loader));
        }
        catch (Throwable t) {
            throw new InternalException(_loc.get("interface-load", iface, loader), t).setFatal(true);
        }
        bc = this._enhProject.loadClass(new ByteArrayInputStream(bc.toByteArray()), (ClassLoader)loader);
        PCEnhancer enhancer = new PCEnhancer(this._repos, bc, meta);
        int result = enhancer.run();
        if (result != 8) {
            throw new InternalException(_loc.get("interface-badenhance", iface)).setFatal(true);
        }
        try {
            impl = Class.forName(bc.getName(), true, enhLoader);
        }
        catch (Throwable t) {
            throw new InternalException(_loc.get("interface-load2", iface, enhLoader), t).setFatal(true);
        }
        this._impls.put(iface, impl);
        return impl;
    }

    private void addField(BCClass bc, Class<?> iface, FieldMetaData fmd, Set<Method> methods) {
        String name = fmd.getName();
        Class type = fmd.getDeclaredType();
        BCField field = bc.declareField(name, type);
        field.setAccessFlags(2);
        name = StringUtil.capitalize(name);
        String prefix = InterfaceImplGenerator.isGetter(iface, fmd) ? "get" : "is";
        BCMethod meth = bc.declareMethod(prefix + name, type, null);
        meth.makePublic();
        Code code = meth.getCode(true);
        code.aload().setThis();
        code.getfield().setField(field);
        code.xreturn().setType(type);
        code.calculateMaxStack();
        code.calculateMaxLocals();
        methods.add(InterfaceImplGenerator.getMethodSafe(iface, meth.getName(), null));
        meth = bc.declareMethod("set" + name, Void.TYPE, new Class[]{type});
        meth.makePublic();
        code = meth.getCode(true);
        code.aload().setThis();
        code.xload().setParam(0).setType(type);
        code.putfield().setField(field);
        code.vreturn();
        code.calculateMaxStack();
        code.calculateMaxLocals();
        methods.add(InterfaceImplGenerator.getMethodSafe(iface, meth.getName(), type));
    }

    private void invalidateNonBeanMethods(BCClass bc, Class<?> iface, Set<Method> methods) {
        Method[] meths = AccessController.doPrivileged(J2DoPrivHelper.getDeclaredMethodsAction(iface));
        Class type = this._repos.getMetaDataFactory().getDefaults().getUnimplementedExceptionType();
        for (int i = 0; i < meths.length; ++i) {
            if (methods.contains(meths[i])) continue;
            BCMethod meth = bc.declareMethod(meths[i].getName(), meths[i].getReturnType(), meths[i].getParameterTypes());
            meth.makePublic();
            Code code = meth.getCode(true);
            code.anew().setType(type);
            code.dup();
            code.invokespecial().setMethod(type, "<init>", Void.TYPE, null);
            code.athrow();
            code.calculateMaxLocals();
            code.calculateMaxStack();
        }
    }

    protected final String getClassName(ClassMetaData meta) {
        Class<?> iface = meta.getDescribedType();
        return iface.getName() + "$" + System.identityHashCode(iface) + POSTFIX;
    }

    private static Method getMethodSafe(Class<?> iface, String name, Class<?> arg) {
        try {
            Class[] classArray;
            if (arg == null) {
                classArray = null;
            } else {
                Class[] classArray2 = new Class[1];
                classArray = classArray2;
                classArray2[0] = arg;
            }
            return AccessController.doPrivileged(J2DoPrivHelper.getDeclaredMethodAction(iface, name, classArray));
        }
        catch (PrivilegedActionException pae) {
            throw new InternalException(_loc.get("interface-mismatch", name));
        }
    }

    private static boolean isGetter(Class<?> iface, FieldMetaData fmd) {
        if (fmd.getType() != Boolean.TYPE && fmd.getType() != Boolean.class) {
            return true;
        }
        try {
            Method meth = AccessController.doPrivileged(J2DoPrivHelper.getDeclaredMethodAction(iface, "is" + StringUtil.capitalize(fmd.getName()), null));
            return meth == null;
        }
        catch (PrivilegedActionException privilegedActionException) {
            return true;
        }
    }

    boolean isImplType(Class<?> cls) {
        return cls.getName().endsWith(POSTFIX) && cls.getName().indexOf(36) != -1;
    }

    public Class<?> toManagedInterface(Class<?> cls) {
        Class<?>[] ifaces = cls.getInterfaces();
        for (int i = 0; i < ifaces.length; ++i) {
            if (this._impls.get(ifaces[i]) != cls) continue;
            return ifaces[i];
        }
        throw new IllegalArgumentException(cls.getName());
    }
}

