/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.enhance;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLDecoder;
import org.apache.xbean.asm.ClassReader;
import org.apache.xbean.asm.ClassVisitor;
import org.apache.xbean.asm.ClassWriter;
import serp.bytecode.BCClass;

public class AsmAdaptor {
    private static final int Java7_MajorVersion = 51;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(BCClass bc) throws IOException {
        if (bc.getMajorVersion() < 51) {
            bc.write();
        } else {
            String name = bc.getName();
            int dotIndex = name.lastIndexOf(46) + 1;
            name = name.substring(dotIndex);
            Class type = bc.getType();
            FileOutputStream out = new FileOutputStream(URLDecoder.decode(type.getResource(name + ".class").getFile()));
            try {
                AsmAdaptor.writeJava7(bc, out);
            }
            finally {
                out.flush();
                ((OutputStream)out).close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void write(BCClass bc, File outFile) throws IOException {
        if (bc.getMajorVersion() < 51) {
            bc.write(outFile);
        } else {
            FileOutputStream out = new FileOutputStream(outFile);
            try {
                AsmAdaptor.writeJava7(bc, out);
            }
            finally {
                out.flush();
                ((OutputStream)out).close();
            }
        }
    }

    public static byte[] toByteArray(BCClass bc, byte[] returnBytes) throws IOException {
        if (bc.getMajorVersion() >= 51) {
            returnBytes = AsmAdaptor.toJava7ByteArray(bc, returnBytes);
        }
        return returnBytes;
    }

    private static void writeJava7(BCClass bc, OutputStream out) throws IOException {
        byte[] java7Bytes = AsmAdaptor.toJava7ByteArray(bc, bc.toByteArray());
        out.write(java7Bytes);
    }

    private static byte[] toJava7ByteArray(BCClass bc, byte[] classBytes) throws IOException {
        ByteArrayInputStream bais = new ByteArrayInputStream(classBytes);
        BufferedInputStream bis = new BufferedInputStream(bais);
        BCClassWriter cw = new BCClassWriter(2, bc.getClassLoader());
        ClassReader cr = new ClassReader((InputStream)bis);
        cr.accept((ClassVisitor)cw, 0);
        return cw.toByteArray();
    }

    private static class BCClassWriter
    extends ClassWriter {
        private final ClassLoader _loader;

        BCClassWriter(int flags, ClassLoader loader) {
            super(flags);
            this._loader = loader;
        }

        protected String getCommonSuperClass(String type1, String type2) {
            Class<?> class2;
            Class<?> class1;
            try {
                class1 = this._loader.loadClass(type1.replace('/', '.'));
                class2 = this._loader.loadClass(type2.replace('/', '.'));
            }
            catch (ClassNotFoundException ex) {
                throw new RuntimeException(ex);
            }
            if (class1.isAssignableFrom(class2)) {
                return type1;
            }
            if (class2.isAssignableFrom(class1)) {
                return type2;
            }
            if (class1.isInterface() || class2.isInterface()) {
                return "java/lang/Object";
            }
            while (!(class1 = class1.getSuperclass()).isAssignableFrom(class2)) {
            }
            return class1.getName().replace('.', '/');
        }
    }
}

