/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.hsql;

import java.io.PrintWriter;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;

public class HsqlPrintWriter
extends PrintWriter {
    private Logger logger;
    private boolean errorWriter;
    private StringBuffer text = new StringBuffer("");

    public HsqlPrintWriter(boolean errorWriter) {
        super(System.err);
        this.logger = Logger.getInstance((LogCategory)LogCategory.OPENEJB_HSQL, HsqlPrintWriter.class);
        this.errorWriter = errorWriter;
    }

    public void close() {
        this.flush();
    }

    private void flushLine() {
        if (!this.errorWriter) {
            this.logger.info(this.text.toString());
        } else {
            this.logger.error(this.text.toString());
        }
        this.text.setLength(0);
    }

    public void flush() {
        if (!this.text.toString().equals("")) {
            this.flushLine();
        }
    }

    public void print(boolean b) {
        this.text.append(b);
    }

    public void print(char c) {
        this.text.append(c);
    }

    public void print(char[] s) {
        this.text.append(s);
    }

    public void print(double d) {
        this.text.append(d);
    }

    public void print(float f) {
        this.text.append(f);
    }

    public void print(int i) {
        this.text.append(i);
    }

    public void print(long l) {
        this.text.append(l);
    }

    public void print(Object obj) {
        this.text.append(obj);
    }

    public void print(String s) {
        this.text.append(s);
    }

    public void println() {
        if (!this.text.toString().equals("")) {
            this.flushLine();
        }
    }

    public void println(boolean x) {
        this.text.append(x);
        this.flushLine();
    }

    public void println(char x) {
        this.text.append(x);
        this.flushLine();
    }

    public void println(char[] x) {
        this.text.append(x);
        this.flushLine();
    }

    public void println(double x) {
        this.text.append(x);
        this.flushLine();
    }

    public void println(float x) {
        this.text.append(x);
        this.flushLine();
    }

    public void println(int x) {
        this.text.append(x);
        this.flushLine();
    }

    public void println(long x) {
        this.text.append(x);
        this.flushLine();
    }

    public void println(Object x) {
        this.text.append(x);
        this.flushLine();
    }

    public void println(String x) {
        this.text.append(x);
        this.flushLine();
    }
}

