/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.hsql;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.Socket;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import javax.naming.Binding;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.resource.jdbc.HsqldbDataSourcePlugin;
import org.apache.openejb.server.SelfManaging;
import org.apache.openejb.server.ServerService;
import org.apache.openejb.server.ServiceException;
import org.apache.openejb.server.hsql.HsqlPrintWriter;
import org.apache.openejb.spi.ContainerSystem;
import org.hsqldb.DatabaseManager;
import org.hsqldb.Server;
import org.hsqldb.ServerConfiguration;
import org.hsqldb.jdbcDriver;
import org.hsqldb.persist.HsqlProperties;

public class HsqlService
implements ServerService,
SelfManaging {
    private int port = ServerConfiguration.getDefaultPort((int)1, (boolean)false);
    private String ip = "0.0.0.0";
    private Server server;

    public String getName() {
        return "hsql";
    }

    public int getPort() {
        return this.port;
    }

    public String getIP() {
        return this.ip;
    }

    public void init(Properties p) throws Exception {
        Properties properties = new Properties();
        for (Map.Entry<Object, Object> entry : p.entrySet()) {
            if (!(entry.getKey() instanceof String) || !(entry.getValue() instanceof String)) continue;
            String property = (String)entry.getKey();
            String value = (String)entry.getValue();
            if (property.startsWith("server.dbname.") || property.startsWith("server.database.")) {
                throw new ServiceException("Databases cannot be declared in the hsql.properties.  Instead declare a database connection in the openejb.conf file");
            }
            if ("port".equals(property)) {
                properties.setProperty("server.port", value);
                continue;
            }
            if ("bind".equals(property)) {
                properties.setProperty("server.address", value);
                continue;
            }
            properties.setProperty(property, value);
        }
        properties.setProperty("server.no_system_exit", "true");
        boolean disabled = Boolean.parseBoolean(properties.getProperty("disabled"));
        ContainerSystem containerSystem = (ContainerSystem)SystemInstance.get().getComponent(ContainerSystem.class);
        if (!disabled && containerSystem != null) {
            NamingEnumeration<Binding> bindings = null;
            try {
                bindings = containerSystem.getJNDIContext().listBindings("java:openejb/Resource/");
                TreeSet<String> dbnames = new TreeSet<String>();
                for (Binding binding : Collections.list(bindings)) {
                    BasicDataSource jdbc;
                    String path;
                    Object value = binding.getObject();
                    if (!(value instanceof BasicDataSource) || (path = this.getPath(jdbc = (BasicDataSource)value)) == null) continue;
                    if (dbnames.size() > 9) {
                        throw new ServiceException("Hsql Server can only host 10 database instances");
                    }
                    String dbname = path.substring(path.lastIndexOf(58) + 1);
                    if (dbnames.contains(dbname = dbname.substring(dbname.lastIndexOf(47) + 1))) continue;
                    properties.put("server.dbname." + dbnames.size(), dbname);
                    properties.put("server.database." + dbnames.size(), path);
                    dbnames.add(dbname);
                }
            }
            catch (NameNotFoundException e) {
                // empty catch block
            }
            this.server = new Server();
            properties.setProperty("server.silent", "true");
            this.server.setLogWriter((PrintWriter)new HsqlPrintWriter(false));
            this.server.setErrWriter((PrintWriter)new HsqlPrintWriter(true));
            this.server.setProperties(new HsqlProperties(properties));
            this.port = this.server.getPort();
            String ipString = this.server.getAddress();
            if (ipString != null && ipString.length() > 0) {
                this.ip = ipString;
            }
        }
    }

    private String getPath(BasicDataSource jdbc) {
        if (!jdbcDriver.class.getName().equals(jdbc.getDriverClassName())) {
            return null;
        }
        String url = jdbc.getUrl();
        if (url == null || !url.startsWith("jdbc:hsqldb:")) {
            return null;
        }
        String path = (url = HsqldbDataSourcePlugin.toAbsolutePath((String)url)).substring("jdbc:hsqldb:".length());
        if (!path.startsWith("file:") && !path.startsWith("mem:") && path.startsWith("res:")) {
            return null;
        }
        return path;
    }

    public void service(InputStream inputStream, OutputStream outputStream) throws ServiceException, IOException {
        throw new UnsupportedOperationException("Method not implemented: service(InputStream in, OutputStream out)");
    }

    public void service(Socket socket) throws ServiceException, IOException {
        throw new UnsupportedOperationException("Method not implemented: service(Socket socket)");
    }

    public void start() throws ServiceException {
        if (this.server == null) {
            return;
        }
        this.server.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() throws ServiceException {
        if (this.server == null) {
            return;
        }
        try {
            this.server.stop();
        }
        finally {
            this.server = null;
            DatabaseManager.closeDatabases((int)1);
        }
    }
}

