/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.ejbd;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.rmi.RemoteException;
import java.util.Properties;
import java.util.zip.GZIPInputStream;
import javax.ejb.EJBHome;
import javax.ejb.EJBMetaData;
import javax.ejb.EJBObject;
import javax.ejb.Handle;
import javax.ejb.HomeHandle;
import org.apache.openejb.BeanContext;
import org.apache.openejb.ProxyInfo;
import org.apache.openejb.client.EJBRequest;
import org.apache.openejb.client.EjbObjectInputStream;
import org.apache.openejb.client.FlushableGZIPOutputStream;
import org.apache.openejb.client.ProtocolMetaData;
import org.apache.openejb.client.RequestType;
import org.apache.openejb.client.ServerMetaData;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.server.DiscoveryAgent;
import org.apache.openejb.server.DiscoveryListener;
import org.apache.openejb.server.ejbd.AuthRequestHandler;
import org.apache.openejb.server.ejbd.ClientObjectFactory;
import org.apache.openejb.server.ejbd.ClusterRequestHandler;
import org.apache.openejb.server.ejbd.EjbRequestHandler;
import org.apache.openejb.server.ejbd.JndiRequestHandler;
import org.apache.openejb.spi.ApplicationServer;
import org.apache.openejb.spi.ContainerSystem;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;

public class EjbDaemon
implements ApplicationServer {
    private static final ProtocolMetaData PROTOCOL_VERSION = new ProtocolMetaData("3.1");
    static final Logger logger = Logger.getInstance((LogCategory)LogCategory.OPENEJB_SERVER_REMOTE, (String)"org.apache.openejb.server.util.resources");
    private ClientObjectFactory clientObjectFactory;
    private EjbRequestHandler ejbHandler;
    private JndiRequestHandler jndiHandler;
    private AuthRequestHandler authHandler;
    private ClusterRequestHandler clusterHandler;
    static EjbDaemon instance;
    private ContainerSystem containerSystem;
    private boolean gzip;

    private EjbDaemon() {
    }

    public static EjbDaemon getEjbDaemon() {
        if (instance == null) {
            instance = new EjbDaemon();
        }
        return instance;
    }

    public void init(Properties props) throws Exception {
        this.containerSystem = (ContainerSystem)SystemInstance.get().getComponent(ContainerSystem.class);
        this.clientObjectFactory = new ClientObjectFactory(this, props);
        this.ejbHandler = new EjbRequestHandler(this);
        this.jndiHandler = new JndiRequestHandler(this);
        this.authHandler = new AuthRequestHandler(this);
        this.clusterHandler = new ClusterRequestHandler(this);
        this.gzip = "true".equalsIgnoreCase(props.getProperty("gzip", "false"));
        DiscoveryAgent discovery = (DiscoveryAgent)SystemInstance.get().getComponent(DiscoveryAgent.class);
        if (discovery != null) {
            discovery.setDiscoveryListener((DiscoveryListener)this.clusterHandler);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void service(Socket socket) throws IOException {
        FilterInputStream in = null;
        OutputStream out = null;
        try {
            if (socket.isClosed()) {
                return;
            }
            in = new BufferedInputStream(socket.getInputStream());
            out = new BufferedOutputStream(socket.getOutputStream());
            if (this.gzip) {
                in = new GZIPInputStream(new BufferedInputStream(socket.getInputStream()));
                out = new BufferedOutputStream((OutputStream)new FlushableGZIPOutputStream(socket.getOutputStream()));
            }
            this.service(in, out);
        }
        finally {
            if (null != out) {
                try {
                    out.flush();
                }
                catch (Throwable e) {}
                try {
                    out.close();
                }
                catch (Throwable e) {}
            }
            if (null != in) {
                try {
                    ((InputStream)in).close();
                }
                catch (Throwable e) {}
            }
            if (null != socket) {
                try {
                    socket.close();
                }
                catch (Throwable t) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void service(InputStream in, OutputStream out) throws IOException {
        ProtocolMetaData protocolMetaData = new ProtocolMetaData();
        EjbObjectInputStream ois = null;
        ObjectOutputStream oos = null;
        RequestType requestType = null;
        byte requestTypeByte = RequestType.NOP_REQUEST.getCode();
        try {
            protocolMetaData.readExternal(in);
            PROTOCOL_VERSION.writeExternal(out);
            ois = new EjbObjectInputStream(in);
            oos = new ObjectOutputStream(out);
            ServerMetaData serverMetaData = new ServerMetaData();
            serverMetaData.readExternal((ObjectInput)ois);
            ClientObjectFactory.serverMetaData.set(serverMetaData);
            requestTypeByte = (byte)ois.read();
            requestType = RequestType.valueOf((byte)requestTypeByte);
            if (requestType == RequestType.NOP_REQUEST) {
                return;
            }
            if (requestType == RequestType.CLUSTER_REQUEST) {
                this.processClusterRequest((ObjectInputStream)ois, oos);
            }
            if ((requestType = RequestType.valueOf((byte)(requestTypeByte = (byte)ois.read()))) == RequestType.NOP_REQUEST) {
                return;
            }
            switch (requestType) {
                case EJB_REQUEST: {
                    this.processEjbRequest((ObjectInputStream)ois, oos);
                    return;
                }
                case JNDI_REQUEST: {
                    this.processJndiRequest((ObjectInputStream)ois, oos);
                    return;
                }
                case AUTH_REQUEST: {
                    this.processAuthRequest((ObjectInputStream)ois, oos);
                    return;
                }
                default: {
                    logger.error("\"" + requestType + " " + protocolMetaData.getSpec() + "\" FAIL \"Unknown request type " + requestType);
                    return;
                }
            }
        }
        catch (IllegalArgumentException iae) {
            String msg = "\"" + protocolMetaData.getSpec() + "\" FAIL \"Unknown request type " + requestTypeByte;
            if (logger.isDebugEnabled()) {
                logger.debug(msg, (Throwable)iae);
                return;
            } else {
                logger.warning(msg + " - Debug for StackTrace");
            }
            return;
        }
        catch (SecurityException e) {
            String msg = "\"" + requestType + " " + protocolMetaData.getSpec() + "\" FAIL \"Security error - " + e.getMessage() + "\"";
            if (logger.isDebugEnabled()) {
                logger.debug(msg, (Throwable)e);
                return;
            } else {
                logger.warning(msg + " - Debug for StackTrace");
            }
            return;
        }
        catch (Throwable e) {
            String msg = "\"" + requestType + " " + protocolMetaData.getSpec() + "\" FAIL \"Unexpected error - " + e.getMessage() + "\"";
            if (logger.isDebugEnabled()) {
                logger.debug(msg, e);
                return;
            } else {
                logger.warning(msg + " - Debug for StackTrace");
            }
            return;
        }
        finally {
            block125: {
                try {
                    ClientObjectFactory.serverMetaData.remove();
                    if (null == oos) break block125;
                }
                catch (Throwable throwable) {
                    if (null != oos) {
                        try {
                            oos.flush();
                        }
                        catch (Throwable e) {}
                        try {
                            oos.close();
                        }
                        catch (Throwable e) {}
                    }
                    if (null == ois) throw throwable;
                    try {
                        ois.close();
                        throw throwable;
                    }
                    catch (Throwable e) {}
                }
                try {
                    oos.flush();
                }
                catch (Throwable e) {}
                try {
                    oos.close();
                }
                catch (Throwable e) {}
            }
            if (null != ois) {
                try {
                    ois.close();
                }
                catch (Throwable e) {}
            }
        }
    }

    private void processClusterRequest(ObjectInputStream in, ObjectOutputStream out) throws IOException {
        this.clusterHandler.processRequest(in, out);
    }

    protected BeanContext getDeployment(EJBRequest req) throws RemoteException {
        String deploymentId = req.getDeploymentId();
        BeanContext beanContext = this.containerSystem.getBeanContext((Object)deploymentId);
        if (beanContext == null) {
            throw new RemoteException("No deployment: " + deploymentId);
        }
        return beanContext;
    }

    public void processEjbRequest(ObjectInputStream in, ObjectOutputStream out) {
        this.ejbHandler.processRequest(in, out);
    }

    public void processJndiRequest(ObjectInputStream in, ObjectOutputStream out) throws Exception {
        this.jndiHandler.processRequest(in, out);
    }

    public void processAuthRequest(ObjectInputStream in, ObjectOutputStream out) {
        this.authHandler.processRequest(in, out);
    }

    public EJBMetaData getEJBMetaData(ProxyInfo info) {
        return this.clientObjectFactory.getEJBMetaData(info);
    }

    public Handle getHandle(ProxyInfo info) {
        return this.clientObjectFactory.getHandle(info);
    }

    public HomeHandle getHomeHandle(ProxyInfo info) {
        return this.clientObjectFactory.getHomeHandle(info);
    }

    public EJBObject getEJBObject(ProxyInfo info) {
        return this.clientObjectFactory.getEJBObject(info);
    }

    public Object getBusinessObject(ProxyInfo info) {
        return this.clientObjectFactory.getBusinessObject(info);
    }

    public EJBHome getEJBHome(ProxyInfo info) {
        return this.clientObjectFactory.getEJBHome(info);
    }

    public boolean isGzip() {
        return this.gzip;
    }
}

