/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.itest.failover;

import java.io.File;
import org.apache.openejb.loader.provisining.ProvisioningResolver;
import org.apache.openejb.util.Join;

public final class Repository {
    private static final ProvisioningResolver RESOLVER = new ProvisioningResolver();

    public static File getArtifact(String groupId, String artifactId, String type) {
        String path;
        String oldCache = System.getProperty("openejb.deployer.cache.folder");
        String property = System.getProperty("openejb.itest.failover.cache", "target/cache");
        new File(property).mkdirs();
        System.setProperty("openejb.deployer.cache.folder", property);
        try {
            path = (String)RESOLVER.realLocation("mvn:" + groupId + ":" + artifactId + ":" + Repository.guessVersion(groupId, artifactId) + ":" + type).iterator().next();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (oldCache == null) {
                System.clearProperty("openejb.deployer.cache.folder");
            } else {
                System.setProperty("openejb.deployer.cache.folder", oldCache);
            }
        }
        return new File(path);
    }

    public static String guessVersion(String groupId, String artifactId) {
        Object[] keys;
        for (String string : keys = new String[]{artifactId + ".version", groupId + ".version", "version"}) {
            String value = System.getProperty(string);
            if (value == null) continue;
            return value;
        }
        String message = String.format("Cannot find version for %s:%s. Checked the following system properties: %s", groupId, artifactId, Join.join((String)", ", (Object[])keys));
        throw new IllegalStateException(message);
    }
}

