/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp.managed;

import java.sql.SQLException;
import javax.sql.XADataSource;
import javax.transaction.TransactionManager;
import org.apache.commons.dbcp.BasicDataSource;
import org.apache.commons.dbcp.ConnectionFactory;
import org.apache.commons.dbcp.PoolingDataSource;
import org.apache.commons.dbcp.SQLNestedException;
import org.apache.commons.dbcp.managed.DataSourceXAConnectionFactory;
import org.apache.commons.dbcp.managed.LocalXAConnectionFactory;
import org.apache.commons.dbcp.managed.ManagedDataSource;
import org.apache.commons.dbcp.managed.TransactionRegistry;

public class BasicManagedDataSource
extends BasicDataSource {
    protected TransactionRegistry transactionRegistry;
    protected TransactionManager transactionManager;
    protected String xaDataSource;

    public TransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    public void setTransactionManager(TransactionManager transactionManager) {
        this.transactionManager = transactionManager;
    }

    public String getXADataSource() {
        return this.xaDataSource;
    }

    public void setXADataSource(String xaDataSource) {
        this.xaDataSource = xaDataSource;
    }

    protected ConnectionFactory createConnectionFactory() throws SQLException {
        if (this.transactionManager == null) {
            throw new SQLException("Transaction manager must be set before a connection can be created");
        }
        if (this.xaDataSource == null) {
            ConnectionFactory connectionFactory = super.createConnectionFactory();
            LocalXAConnectionFactory xaConnectionFactory = new LocalXAConnectionFactory(this.getTransactionManager(), connectionFactory);
            this.transactionRegistry = xaConnectionFactory.getTransactionRegistry();
            return xaConnectionFactory;
        }
        Class<?> xaDataSourceClass = null;
        try {
            xaDataSourceClass = Class.forName(this.xaDataSource);
        }
        catch (Throwable t) {
            String message = "Cannot load XA data source class '" + this.xaDataSource + "'";
            this.logWriter.println(message);
            t.printStackTrace(this.logWriter);
            throw new SQLNestedException(message, t);
        }
        XADataSource xaDataSource = null;
        try {
            xaDataSource = (XADataSource)xaDataSourceClass.newInstance();
        }
        catch (Throwable t) {
            String message = "Cannot create XA data source of class '" + xaDataSource + "'";
            this.logWriter.println(message);
            t.printStackTrace(this.logWriter);
            throw new SQLNestedException(message, t);
        }
        DataSourceXAConnectionFactory xaConnectionFactory = new DataSourceXAConnectionFactory(this.getTransactionManager(), xaDataSource, this.username, this.password);
        this.transactionRegistry = xaConnectionFactory.getTransactionRegistry();
        return xaConnectionFactory;
    }

    protected void createDataSourceInstance() throws SQLException {
        this.dataSource = new ManagedDataSource(this.connectionPool, this.transactionRegistry);
        ((PoolingDataSource)this.dataSource).setAccessToUnderlyingConnectionAllowed(this.isAccessToUnderlyingConnectionAllowed());
        this.dataSource.setLogWriter(this.logWriter);
    }
}

