/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.util;

import java.io.OutputStreamWriter;
import java.lang.reflect.Constructor;
import java.util.logging.ConsoleHandler;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import org.apache.openejb.loader.Options;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.log.ConsoleColorHandler;
import org.apache.openejb.log.SingleLineFormatter;
import org.apache.openejb.util.JuliLogStream;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.LogStream;
import org.apache.openejb.util.LogStreamFactory;
import org.apache.openejb.util.reflection.Reflections;
import org.apache.webbeans.logger.WebBeansLoggerFacade;

public class JuliLogStreamFactory
implements LogStreamFactory {
    public static final String OPENEJB_LOG_COLOR_PROP = "openejb.log.color";
    private static volatile String consoleHandlerClazz;
    private static volatile boolean useOpenEJBHandler;

    public JuliLogStreamFactory() {
        boolean tomee = JuliLogStreamFactory.is("org.apache.tomee.catalina.TomcatLoader");
        boolean embedded = JuliLogStreamFactory.is("org.apache.tomee.embedded.Container");
        Options options = SystemInstance.isInitialized() ? SystemInstance.get().getOptions() : new Options(System.getProperties());
        boolean forceLogs = options.get("openejb.jul.forceReload", false);
        if ((!tomee || embedded || forceLogs) && System.getProperty("java.util.logging.manager") == null) {
            consoleHandlerClazz = options.get("openejb.jul.consoleHandlerClazz", (String)null);
            if (consoleHandlerClazz == null) {
                consoleHandlerClazz = options.get(OPENEJB_LOG_COLOR_PROP, false) && JuliLogStreamFactory.isNotIDE() ? ConsoleColorHandler.class.getName() : OpenEJBSimpleLayoutHandler.class.getName();
            }
            try {
                ClassLoader.getSystemClassLoader().loadClass(consoleHandlerClazz);
            }
            catch (ClassNotFoundException e) {
                consoleHandlerClazz = ConsoleHandler.class.getName();
            }
            if (forceLogs) {
                useOpenEJBHandler = options.get("openejb.jul.forceReload.use-openejb-handler", true);
                try {
                    OpenEJBLogManager value = new OpenEJBLogManager();
                    Reflections.set(LogManager.class, null, "manager", value);
                    value.forceReset();
                    JuliLogStreamFactory.setRootLogger(value);
                    value.readConfiguration();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            System.setProperty("java.util.logging.manager", OpenEJBLogManager.class.getName());
        }
        try {
            if (options.get("openjpa.Log", (String)null) == null) {
                JuliLogStreamFactory.class.getClassLoader().loadClass("org.apache.openjpa.lib.log.LogFactoryAdapter");
                System.setProperty("openjpa.Log", "org.apache.openejb.openjpa.JULOpenJPALogFactory");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            System.setProperty(WebBeansLoggerFacade.class.getName(), "org.apache.webbeans.logger.JULLoggerFactory");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public LogStream createLogStream(LogCategory logCategory) {
        return new JuliLogStream(logCategory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setRootLogger(OpenEJBLogManager value) {
        try {
            Class<?> rootLoggerClass = ClassLoader.getSystemClassLoader().loadClass("java.util.logging.LogManager$RootLogger");
            Constructor<?> cons = rootLoggerClass.getDeclaredConstructor(LogManager.class);
            boolean acc = cons.isAccessible();
            if (!acc) {
                cons.setAccessible(true);
            }
            Logger rootLogger = (Logger)Logger.class.cast(cons.newInstance(value));
            try {
                Reflections.set(value, "rootLogger", rootLogger);
            }
            finally {
                cons.setAccessible(acc);
            }
            value.addLogger(rootLogger);
            Reflections.invokeByReflection(Reflections.get(value, "systemContext"), "addLocalLogger", new Class[]{Logger.class}, new Object[]{rootLogger});
            Reflections.invokeByReflection(Logger.global, "setLogManager", new Class[]{LogManager.class}, new Object[]{value});
            value.addLogger(Logger.global);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static boolean isNotIDE() {
        return !System.getProperty("java.class.path").contains("idea_rt");
    }

    private static String reverseProperty(String name) {
        if (name.contains(".") && !name.endsWith(".")) {
            int idx = name.lastIndexOf(46);
            return name.substring(idx) + "." + name.substring(0, idx);
        }
        return name;
    }

    private static boolean isOverridableLogger(String name) {
        return useOpenEJBHandler || name.toLowerCase().contains("openejb") || name.toLowerCase().contains("transaction") || name.toLowerCase().contains("cxf") || name.toLowerCase().contains("timer") || name.startsWith("org.apache.") && !name.startsWith("org.apache.geronimo.connector.work.WorkerContext.") || name.startsWith("openjpa.") || name.startsWith("net.sf.ehcache.") || name.startsWith("org.quartz.") || name.startsWith("org.hibernate.");
    }

    private static boolean is(String classname) {
        try {
            JuliLogStreamFactory.class.getClassLoader().loadClass(classname);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static class OpenEJBSimpleLayoutHandler
    extends ConsoleHandler {
        public OpenEJBSimpleLayoutHandler() {
            this.setFormatter(new SingleLineFormatter());
            Reflections.set(this, "writer", new OutputStreamWriter(System.out));
        }
    }

    public static class OpenEJBLogManager
    extends LogManager {
        public void forceReset() {
            super.reset();
        }

        @Override
        public void reset() throws SecurityException {
        }

        @Override
        public String getProperty(String name) {
            String parentValue = super.getProperty(name);
            if (SystemInstance.isInitialized()) {
                if (SystemInstance.get().getProperties().containsKey(name)) {
                    return SystemInstance.get().getProperty(name);
                }
                String propertyKeyValue = "logging" + JuliLogStreamFactory.reverseProperty(name);
                if (SystemInstance.get().getProperties().containsKey(propertyKeyValue)) {
                    return SystemInstance.get().getProperty(propertyKeyValue);
                }
            }
            if (OpenEJBLogManager.class.getName().equals(System.getProperty("java.util.logging.manager")) && JuliLogStreamFactory.isOverridableLogger(name) && parentValue == null) {
                if (name.endsWith(".handlers")) {
                    return consoleHandlerClazz;
                }
                if (name.endsWith(".useParentHandlers")) {
                    return "false";
                }
            }
            return parentValue;
        }

        static {
            final LogManager mgr = LogManager.getLogManager();
            if (mgr instanceof OpenEJBLogManager) {
                Runtime.getRuntime().addShutdownHook(new Thread(){

                    @Override
                    public void run() {
                        ((OpenEJBLogManager)mgr).forceReset();
                    }
                });
            }
        }
    }
}

