/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.resource.jdbc.dbcp;

import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Logger;
import javax.sql.CommonDataSource;
import javax.sql.DataSource;
import javax.sql.XADataSource;
import org.apache.commons.dbcp.ConnectionFactory;
import org.apache.commons.dbcp.DataSourceConnectionFactory;
import org.apache.commons.dbcp.managed.DataSourceXAConnectionFactory;
import org.apache.openejb.OpenEJB;
import org.apache.openejb.resource.jdbc.IsolationLevels;
import org.apache.openejb.resource.jdbc.dbcp.JMXBasicDataSource;
import org.apache.openejb.util.reflection.Reflections;

public class BasicDataSource
extends org.apache.commons.dbcp.BasicDataSource {
    private static final ReentrantLock lock = new ReentrantLock();
    private Logger logger;
    private String passwordCipher;
    private String initialPassword;
    private JMXBasicDataSource jmxDs;
    private CommonDataSource delegate;

    public BasicDataSource() {
    }

    public BasicDataSource(String name) {
        this.setName(name);
    }

    public void setDelegate(CommonDataSource delegate) {
        this.delegate = delegate;
    }

    protected ConnectionFactory createConnectionFactory() throws SQLException {
        if (this.delegate != null) {
            if (XADataSource.class.isInstance(this.delegate)) {
                return new DataSourceXAConnectionFactory(OpenEJB.getTransactionManager(), (XADataSource)XADataSource.class.cast(this.delegate), this.username, this.password);
            }
            return new DataSourceConnectionFactory((DataSource)DataSource.class.cast(this.delegate), this.username, this.password);
        }
        return super.createConnectionFactory();
    }

    private void registerAsMbean(String name) {
        try {
            this.jmxDs = new JMXBasicDataSource(name, this);
        }
        catch (Exception e) {
            this.jmxDs = null;
        }
        catch (NoClassDefFoundError ncdfe) {
            this.jmxDs = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getPasswordCipher() {
        ReentrantLock l = lock;
        l.lock();
        try {
            String string = this.passwordCipher;
            return string;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPasswordCipher(String passwordCipher) {
        ReentrantLock l = lock;
        l.lock();
        try {
            this.passwordCipher = passwordCipher;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPassword(String password) {
        ReentrantLock l = lock;
        l.lock();
        try {
            this.initialPassword = password;
            super.setPassword(password);
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getUserName() {
        ReentrantLock l = lock;
        l.lock();
        try {
            String string = super.getUsername();
            return string;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setUserName(String string) {
        ReentrantLock l = lock;
        l.lock();
        try {
            super.setUsername(string);
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getJdbcDriver() {
        ReentrantLock l = lock;
        l.lock();
        try {
            String string = super.getDriverClassName();
            return string;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setJdbcDriver(String string) {
        ReentrantLock l = lock;
        l.lock();
        try {
            super.setDriverClassName(string);
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getJdbcUrl() {
        ReentrantLock l = lock;
        l.lock();
        try {
            String string = super.getUrl();
            return string;
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setJdbcUrl(String string) {
        ReentrantLock l = lock;
        l.lock();
        try {
            super.setUrl(string);
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDefaultTransactionIsolation(String s) {
        ReentrantLock l = lock;
        l.lock();
        try {
            if (s == null || s.equals("")) {
                return;
            }
            int level2 = IsolationLevels.getIsolationLevel(s);
            super.setDefaultTransactionIsolation(level2);
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxWait(int maxWait) {
        ReentrantLock l = lock;
        l.lock();
        try {
            super.setMaxWait((long)maxWait);
        }
        finally {
            l.unlock();
        }
    }

    /*
     * Exception decompiling
     */
    protected DataSource createDataSource() throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static SQLException toSQLException(Throwable e) {
        if (e instanceof SQLException) {
            return (SQLException)e;
        }
        return new SQLException("Failed to create DataSource", e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws SQLException {
        ReentrantLock l = lock;
        l.lock();
        try {
            try {
                this.unregisterMBean();
            }
            catch (Exception exception) {
                // empty catch block
            }
            super.close();
        }
        finally {
            l.unlock();
        }
    }

    private void unregisterMBean() {
        if (this.jmxDs != null) {
            this.jmxDs.unregister();
        }
    }

    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        ReentrantLock l = lock;
        l.lock();
        try {
            if (null == this.logger) {
                this.logger = (Logger)Reflections.invokeByReflection(this.dataSource, "getParentLogger", new Class[0], null);
            }
            Logger logger = this.logger;
            return logger;
        }
        catch (Throwable e) {
            throw new SQLFeatureNotSupportedException();
        }
        finally {
            l.unlock();
        }
    }

    public void setName(String name) {
        this.registerAsMbean(name);
    }
}

