/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.config.rules;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import javax.ejb.AfterBegin;
import javax.ejb.AfterCompletion;
import javax.ejb.BeforeCompletion;
import javax.ejb.Init;
import javax.ejb.PostActivate;
import javax.ejb.PrePassivate;
import javax.ejb.Remove;
import javax.ejb.SessionBean;
import javax.ejb.SessionSynchronization;
import javax.interceptor.InvocationContext;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.config.EjbModule;
import org.apache.openejb.config.rules.ValidationBase;
import org.apache.openejb.jee.AroundInvoke;
import org.apache.openejb.jee.AroundTimeout;
import org.apache.openejb.jee.CallbackMethod;
import org.apache.openejb.jee.EnterpriseBean;
import org.apache.openejb.jee.Interceptor;
import org.apache.openejb.jee.Invokable;
import org.apache.openejb.jee.LifecycleCallback;
import org.apache.openejb.jee.RemoveMethod;
import org.apache.openejb.jee.Session;
import org.apache.openejb.jee.SessionType;
import org.apache.openejb.jee.Timer;
import org.apache.xbean.finder.ClassFinder;

public class CheckCallbacks
extends ValidationBase {
    @Override
    public void validate(EjbModule module) {
        for (EnterpriseBean enterpriseBean : module.getEjbJar().getEnterpriseBeans()) {
            Class ejbClass;
            try {
                ejbClass = this.loadClass(enterpriseBean.getEjbClass());
            }
            catch (OpenEJBException e) {
                continue;
            }
            if (enterpriseBean instanceof Invokable) {
                Invokable invokable = (Invokable)enterpriseBean;
                for (AroundInvoke aroundInvoke : invokable.getAroundInvoke()) {
                    this.checkAroundInvoke(ejbClass, aroundInvoke, enterpriseBean.getEjbName());
                }
                for (AroundTimeout aroundTimeout : invokable.getAroundTimeout()) {
                    this.checkAroundTimeout(ejbClass, aroundTimeout, enterpriseBean.getEjbName());
                }
            }
            for (LifecycleCallback callback : enterpriseBean.getPostConstruct()) {
                this.checkCallback(ejbClass, "PostConstruct", (CallbackMethod)callback, enterpriseBean, new Class[0]);
            }
            for (LifecycleCallback callback : enterpriseBean.getPreDestroy()) {
                this.checkCallback(ejbClass, "PreDestroy", (CallbackMethod)callback, enterpriseBean, new Class[0]);
            }
            ClassFinder finder = new ClassFinder(new Class[]{ejbClass});
            if (enterpriseBean instanceof Session) {
                org.apache.openejb.jee.SessionBean session = (org.apache.openejb.jee.SessionBean)enterpriseBean;
                if (session.getSessionType() == SessionType.STATEFUL) {
                    for (LifecycleCallback callback : session.getPrePassivate()) {
                        this.checkCallback(ejbClass, "PrePassivate", (CallbackMethod)callback, enterpriseBean, new Class[0]);
                    }
                    for (LifecycleCallback callback : session.getPostActivate()) {
                        this.checkCallback(ejbClass, "PostActivate", (CallbackMethod)callback, enterpriseBean, new Class[0]);
                    }
                    this.checkSessionSynchronization(ejbClass, session);
                    for (LifecycleCallback callback : session.getAfterBegin()) {
                        this.checkCallback(ejbClass, "AfterBegin", (CallbackMethod)callback, enterpriseBean, new Class[0]);
                    }
                    for (LifecycleCallback callback : session.getBeforeCompletion()) {
                        this.checkCallback(ejbClass, "BeforeCompletion", (CallbackMethod)callback, enterpriseBean, new Class[0]);
                    }
                    for (LifecycleCallback callback : session.getAfterCompletion()) {
                        this.checkCallback(ejbClass, "AfterCompletion", (CallbackMethod)callback, enterpriseBean, Boolean.TYPE);
                    }
                    for (AroundTimeout aroundTimeout : session.getAroundTimeout()) {
                        this.ignoredMethodAnnotation("AroundTimeout", enterpriseBean, enterpriseBean.getEjbClass(), aroundTimeout.getMethodName(), SessionType.STATEFUL.getName());
                    }
                    for (Timer timer : session.getTimer()) {
                        this.ignoredMethodAnnotation("Schedule/Schedules", enterpriseBean, enterpriseBean.getEjbClass(), timer.getTimeoutMethod().getMethodName(), SessionType.STATEFUL.getName());
                    }
                    continue;
                }
                for (LifecycleCallback callback : session.getAfterBegin()) {
                    this.ignoredMethodAnnotation("AfterBegin", enterpriseBean, enterpriseBean.getEjbClass(), callback.getMethodName(), session.getSessionType().getName());
                }
                for (LifecycleCallback callback : session.getBeforeCompletion()) {
                    this.ignoredMethodAnnotation("BeforeCompletion", enterpriseBean, enterpriseBean.getEjbClass(), callback.getMethodName(), session.getSessionType().getName());
                }
                for (LifecycleCallback callback : session.getAfterCompletion()) {
                    this.ignoredMethodAnnotation("AfterCompletion", enterpriseBean, enterpriseBean.getEjbClass(), callback.getMethodName(), session.getSessionType().getName());
                }
                for (LifecycleCallback callback : session.getPrePassivate()) {
                    this.ignoredMethodAnnotation("PrePassivate", enterpriseBean, enterpriseBean.getEjbClass(), callback.getMethodName(), session.getSessionType().getName());
                }
                for (LifecycleCallback callback : session.getPostActivate()) {
                    this.ignoredMethodAnnotation("PostActivate", enterpriseBean, enterpriseBean.getEjbClass(), callback.getMethodName(), session.getSessionType().getName());
                }
                for (RemoveMethod method : session.getRemoveMethod()) {
                    this.ignoredMethodAnnotation("Remove", enterpriseBean, enterpriseBean.getEjbClass(), method.getBeanMethod().getMethodName(), session.getSessionType().getName());
                }
                for (RemoveMethod method : session.getInitMethod()) {
                    this.ignoredMethodAnnotation("Init", enterpriseBean, enterpriseBean.getEjbClass(), method.getBeanMethod().getMethodName(), session.getSessionType().getName());
                }
                continue;
            }
            for (Method method : finder.findAnnotatedMethods(PrePassivate.class)) {
                this.ignoredMethodAnnotation("PrePassivate", enterpriseBean, enterpriseBean.getEjbClass(), method.getName(), enterpriseBean.getClass().getSimpleName());
            }
            for (Method method : finder.findAnnotatedMethods(PostActivate.class)) {
                this.ignoredMethodAnnotation("PostActivate", enterpriseBean, enterpriseBean.getEjbClass(), method.getName(), enterpriseBean.getClass().getSimpleName());
            }
            for (Method method : finder.findAnnotatedMethods(Remove.class)) {
                this.ignoredMethodAnnotation("Remove", enterpriseBean, enterpriseBean.getEjbClass(), method.getName(), enterpriseBean.getClass().getSimpleName());
            }
            for (Method method : finder.findAnnotatedMethods(Init.class)) {
                this.ignoredMethodAnnotation("Init", enterpriseBean, enterpriseBean.getEjbClass(), method.getName(), enterpriseBean.getClass().getSimpleName());
            }
            for (Method method : finder.findAnnotatedMethods(AfterBegin.class)) {
                this.ignoredMethodAnnotation("AfterBegin", enterpriseBean, enterpriseBean.getEjbClass(), method.getName(), enterpriseBean.getClass().getSimpleName());
            }
            for (Method method : finder.findAnnotatedMethods(BeforeCompletion.class)) {
                this.ignoredMethodAnnotation("BeforeCompletion", enterpriseBean, enterpriseBean.getEjbClass(), method.getName(), enterpriseBean.getClass().getSimpleName());
            }
            for (Method method : finder.findAnnotatedMethods(AfterCompletion.class)) {
                this.ignoredMethodAnnotation("AfterCompletion", enterpriseBean, enterpriseBean.getEjbClass(), method.getName(), enterpriseBean.getClass().getSimpleName());
            }
        }
        for (EnterpriseBean enterpriseBean : module.getEjbJar().getInterceptors()) {
            Class interceptorClass;
            try {
                interceptorClass = this.loadClass(enterpriseBean.getInterceptorClass());
            }
            catch (OpenEJBException e) {
                continue;
            }
            for (AroundInvoke aroundInvoke : enterpriseBean.getAroundInvoke()) {
                this.checkAroundInvoke(interceptorClass, aroundInvoke, "Interceptor");
            }
            for (AroundTimeout aroundTimeout : enterpriseBean.getAroundTimeout()) {
                this.checkAroundTimeout(interceptorClass, aroundTimeout, "Interceptor");
            }
            for (LifecycleCallback callback : enterpriseBean.getPostConstruct()) {
                this.checkCallback(interceptorClass, "PostConstruct", (CallbackMethod)callback, (Interceptor)enterpriseBean);
            }
            for (LifecycleCallback callback : enterpriseBean.getPreDestroy()) {
                this.checkCallback(interceptorClass, "PreDestroy", (CallbackMethod)callback, (Interceptor)enterpriseBean);
            }
            for (LifecycleCallback callback : enterpriseBean.getPrePassivate()) {
                this.checkCallback(interceptorClass, "PrePassivate", (CallbackMethod)callback, (Interceptor)enterpriseBean);
            }
            for (LifecycleCallback callback : enterpriseBean.getPostActivate()) {
                this.checkCallback(interceptorClass, "PostActivate", (CallbackMethod)callback, (Interceptor)enterpriseBean);
            }
            for (LifecycleCallback callback : enterpriseBean.getAfterBegin()) {
                this.checkCallback(interceptorClass, "AfterBegin", (CallbackMethod)callback, (Interceptor)enterpriseBean);
            }
            for (LifecycleCallback callback : enterpriseBean.getBeforeCompletion()) {
                this.checkCallback(interceptorClass, "BeforeCompletion", (CallbackMethod)callback, (Interceptor)enterpriseBean);
            }
            for (LifecycleCallback callback : enterpriseBean.getAfterCompletion()) {
                this.checkCallback(interceptorClass, "AfterCompletion", (CallbackMethod)callback, (Interceptor)enterpriseBean);
            }
        }
    }

    private void checkAroundTypeInvoke(String aroundType, Class ejbClass, String declaringClassName, String declaringMethodName, String componentName) {
        try {
            Class declaringClass;
            try {
                declaringClass = declaringClassName == null ? ejbClass : this.loadClass(declaringClassName);
            }
            catch (OpenEJBException e) {
                this.fail(componentName, "missing.class", declaringClassName, aroundType, ejbClass.getName());
                return;
            }
            Method method = this.getMethod(declaringClass, declaringMethodName, InvocationContext.class);
            Class<?> returnType = method.getReturnType();
            if (!returnType.equals(Object.class)) {
                this.fail(componentName, "aroundInvoke.badReturnType", aroundType, declaringMethodName, returnType.getName(), declaringClassName);
            }
            boolean throwsException = false;
            for (Class<?> exceptionType : method.getExceptionTypes()) {
                if (!exceptionType.getName().equals(Exception.class.getName())) continue;
                throwsException = true;
            }
            if (!throwsException) {
                this.fail(componentName, "aroundInvoke.mustThrowException", aroundType, declaringMethodName, declaringClassName);
            }
        }
        catch (NoSuchMethodException e) {
            List<Method> possibleMethods = this.getMethods(ejbClass, declaringMethodName);
            if (possibleMethods.size() == 0) {
                this.fail(componentName, "aroundInvoke.missing", aroundType, declaringMethodName, declaringClassName);
            }
            if (possibleMethods.size() == 1) {
                this.fail(componentName, "aroundInvoke.invalidArguments", aroundType, declaringMethodName, this.getParameters(possibleMethods.get(0)), declaringClassName);
                Class<?> returnType = possibleMethods.get(0).getReturnType();
                if (!returnType.equals(Object.class)) {
                    this.fail(componentName, "aroundInvoke.badReturnType", aroundType, declaringMethodName, returnType.getName(), declaringClassName);
                }
            }
            this.fail(componentName, "aroundInvoke.missing.possibleTypo", aroundType, declaringMethodName, possibleMethods.size(), declaringClassName);
        }
    }

    private void checkAroundInvoke(Class<?> ejbClass, AroundInvoke aroundInvoke, String componentName) {
        this.checkAroundTypeInvoke("AroundInvoke", ejbClass, aroundInvoke.getClassName(), aroundInvoke.getMethodName(), componentName);
    }

    private void checkAroundTimeout(Class<?> ejbClass, AroundTimeout aroundTimeout, String componentName) {
        this.checkAroundTypeInvoke("AroundTimeout", ejbClass, aroundTimeout.getClassName(), aroundTimeout.getMethodName(), componentName);
    }

    private void checkCallback(Class<?> ejbClass, String type, CallbackMethod callback, EnterpriseBean bean, Class ... parameterTypes) {
        try {
            int methodModifiers;
            Class<?> returnType;
            Class delcaringClass;
            try {
                delcaringClass = callback.getClassName() == null ? ejbClass : this.loadClass(callback.getClassName());
            }
            catch (OpenEJBException e) {
                this.fail(type, "missing.class", callback.getClassName(), type, bean.getEjbName());
                return;
            }
            Method method = this.getMethod(delcaringClass, callback.getMethodName(), parameterTypes);
            if (this.implementsSessionBean(delcaringClass)) {
                if ("PreDestroy".equals(type)) {
                    if (!callback.getMethodName().equals("ejbRemove")) {
                        this.fail(bean.getEjbName(), "callback.sessionbean.invalidusage", type, callback.getMethodName(), ejbClass);
                    }
                } else if ("PostActivate".equals(type)) {
                    if (!callback.getMethodName().equals("ejbActivate")) {
                        this.fail(bean.getEjbName(), "callback.sessionbean.invalidusage", type, callback.getMethodName(), ejbClass);
                    }
                } else if ("PrePassivate".equals(type)) {
                    if (!callback.getMethodName().equals("ejbPassivate")) {
                        this.fail(bean.getEjbName(), "callback.sessionbean.invalidusage", type, callback.getMethodName(), ejbClass);
                    }
                } else if ("PostConstruct".equals(type) && !callback.getMethodName().equals("ejbCreate")) {
                    this.fail(bean.getEjbName(), "callback.sessionbean.invalidusage", type, callback.getMethodName(), ejbClass);
                }
            }
            if (!(returnType = method.getReturnType()).equals(Void.TYPE)) {
                this.fail(bean, "callback.badReturnType", type, callback.getMethodName(), returnType.getName(), callback.getClassName());
            }
            if (Modifier.isFinal(methodModifiers = method.getModifiers()) || Modifier.isStatic(methodModifiers)) {
                this.fail(bean, "callback.badModifier", type, callback.getMethodName(), callback.getClassName());
            }
        }
        catch (NoSuchMethodException e) {
            List<Method> possibleMethods = this.getMethods(ejbClass, callback.getMethodName());
            if (possibleMethods.size() == 0) {
                this.fail(bean, "callback.missing", type, callback.getMethodName(), callback.getClassName());
            }
            if (possibleMethods.size() == 1) {
                Class<?>[] parameters = possibleMethods.get(0).getParameterTypes();
                if (parameters.length == 1 && parameters[0].equals(InvocationContext.class)) {
                    this.fail(bean.getEjbName(), "callback.invocationcontext.notallowed", type, callback.getMethodName());
                } else {
                    this.fail(bean, "callback.invalidArguments", type, callback.getMethodName(), this.getParameters(possibleMethods.get(0)), callback.getClassName(), this.getParameters(parameterTypes));
                }
            }
            this.fail(bean, "callback.missing.possibleTypo", type, callback.getMethodName(), possibleMethods.size(), callback.getClassName(), this.getParameters(parameterTypes));
        }
    }

    private boolean implementsSessionBean(Class<?> ejbClass) {
        Class<?>[] interfaces;
        for (Class<?> interfce : interfaces = ejbClass.getInterfaces()) {
            if (!interfce.equals(SessionBean.class)) continue;
            return true;
        }
        return false;
    }

    private void checkCallback(Class interceptorClass, String type, CallbackMethod callback, Interceptor interceptor) {
        try {
            Class delcaringClass;
            try {
                delcaringClass = callback.getClassName() == null ? interceptorClass : this.loadClass(callback.getClassName());
            }
            catch (OpenEJBException e) {
                this.fail(type, "missing.class", callback.getClassName(), type, interceptor.getInterceptorClass());
                return;
            }
            Method method = this.getMethod(delcaringClass, callback.getMethodName(), InvocationContext.class);
            Class<?> returnType = method.getReturnType();
            if (!returnType.equals(Void.TYPE)) {
                this.fail("Interceptor", "interceptor.callback.badReturnType", interceptorClass, type, callback.getMethodName(), returnType.getName());
            }
        }
        catch (NoSuchMethodException e) {
            List<Method> possibleMethods = this.getMethods(interceptorClass, callback.getMethodName());
            if (possibleMethods.size() == 0) {
                this.fail("Interceptor", "interceptor.callback.missing", type, callback.getMethodName(), interceptorClass.getName());
            }
            if (possibleMethods.size() == 1) {
                this.fail("Interceptor", "interceptor.callback.invalidArguments", type, callback.getMethodName(), this.getParameters(possibleMethods.get(0)), interceptorClass.getName());
                Class<?> returnType = possibleMethods.get(0).getReturnType();
                if (!returnType.equals(Void.TYPE)) {
                    this.fail("Interceptor", "interceptor.callback.badReturnType", interceptorClass, type, callback.getMethodName(), returnType.getName());
                }
            }
            this.fail("Interceptor", "interceptor.callback.missing.possibleTypo", type, callback.getMethodName(), possibleMethods.size(), interceptorClass.getName());
        }
    }

    private void checkSessionSynchronization(Class ejbClass, org.apache.openejb.jee.SessionBean bean) {
        if (SessionSynchronization.class.isAssignableFrom(ejbClass)) {
            if (bean.getAfterBeginMethod() != null || bean.getBeforeCompletionMethod() != null || bean.getAfterCompletionMethod() != null) {
                this.fail((EnterpriseBean)bean, "callback.sessionSynchronization.invalidUse", ejbClass.getName());
            } else {
                ClassFinder classFinder = new ClassFinder(new Class[]{ejbClass});
                if (classFinder.findAnnotatedMethods(AfterBegin.class).size() > 0 || classFinder.findAnnotatedMethods(BeforeCompletion.class).size() > 0 || classFinder.findAnnotatedMethods(AfterCompletion.class).size() > 0) {
                    this.fail((EnterpriseBean)bean, "callback.sessionSynchronization.invalidUse", ejbClass.getName());
                }
            }
        }
    }

    private Method getMethod(Class clazz, String methodName, Class ... parameterTypes) throws NoSuchMethodException {
        NoSuchMethodException original = null;
        while (clazz != null) {
            try {
                return clazz.getDeclaredMethod(methodName, parameterTypes);
            }
            catch (NoSuchMethodException e) {
                if (original == null) {
                    original = e;
                }
                clazz = clazz.getSuperclass();
            }
        }
        throw original;
    }

    private List<Method> getMethods(Class clazz, String methodName) {
        ArrayList<Method> methods = new ArrayList<Method>();
        while (clazz != null) {
            for (Method method : clazz.getDeclaredMethods()) {
                if (!method.getName().equals(methodName)) continue;
                methods.add(method);
            }
            clazz = clazz.getSuperclass();
        }
        return methods;
    }
}

