/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.config;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.openejb.config.ConfigurableClasspathArchive;
import org.apache.openejb.config.Module;
import org.apache.openejb.config.ScanConstants;
import org.apache.openejb.config.ScanUtil;
import org.apache.xbean.finder.archive.Archive;
import org.apache.xbean.finder.archive.CompositeArchive;
import org.apache.xbean.finder.archive.FilteredArchive;
import org.apache.xbean.finder.filter.Filter;

public class WebappAggregatedArchive
implements Archive,
ScanConstants {
    private final Map<URL, List<String>> map = new HashMap<URL, List<String>>();
    private ScanUtil.ScanHandler handler;
    private boolean scanXmlExists;
    private Archive archive;

    public WebappAggregatedArchive(Module module, Iterable<URL> urls) {
        ArrayList<FilteredArchive> archives = new ArrayList<FilteredArchive>();
        URL scanXml = (URL)module.getAltDDs().get("scan.xml");
        if (scanXml != null) {
            try {
                this.handler = ScanUtil.read(scanXml);
                this.scanXmlExists = true;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        for (URL url : urls) {
            ArrayList<String> classes = new ArrayList<String>();
            FilteredArchive archive = new FilteredArchive((Archive)new ConfigurableClasspathArchive(module.getClassLoader(), Arrays.asList(url)), (Filter)new ScanXmlSaverFilter(this.scanXmlExists, this.handler, classes));
            this.map.put(url, classes);
            archives.add(archive);
        }
        this.archive = new CompositeArchive(archives);
    }

    public WebappAggregatedArchive(ClassLoader classLoader, Map<String, Object> altDDs, Collection<URL> xmls) {
        this(new ConfigurableClasspathArchive.FakeModule(classLoader, altDDs), xmls);
    }

    public Map<URL, List<String>> getClassesMap() {
        return this.map;
    }

    public InputStream getBytecode(String className) throws IOException, ClassNotFoundException {
        return this.archive.getBytecode(className);
    }

    public Class<?> loadClass(String className) throws ClassNotFoundException {
        return this.archive.loadClass(className);
    }

    public Iterator<Archive.Entry> iterator() {
        return this.archive.iterator();
    }

    public static class ScanXmlSaverFilter
    implements Filter {
        private boolean scanXmlExists;
        private final ScanUtil.ScanHandler handler;
        private final List<String> classes;

        public ScanXmlSaverFilter(boolean scanXmlExists, ScanUtil.ScanHandler handler, List<String> classes) {
            this.scanXmlExists = scanXmlExists;
            this.handler = handler;
            this.classes = classes;
        }

        public boolean accept(String name) {
            if (this.scanXmlExists) {
                for (String packageName : this.handler.getPackages()) {
                    if (!name.startsWith(packageName)) continue;
                    this.classes.add(name);
                    return true;
                }
                for (String className : this.handler.getClasses()) {
                    if (!className.equals(name)) continue;
                    this.classes.add(name);
                    return true;
                }
                return false;
            }
            this.classes.add(name);
            return true;
        }
    }
}

