/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.config;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.apache.openejb.assembler.classic.AppInfo;
import org.apache.openejb.assembler.classic.Assembler;
import org.apache.openejb.assembler.classic.event.ContainerSystemPostCreate;
import org.apache.openejb.assembler.classic.event.ContainerSystemPreDestroy;
import org.apache.openejb.config.ConfigurationFactory;
import org.apache.openejb.config.DeploymentsResolver;
import org.apache.openejb.config.sys.Deployments;
import org.apache.openejb.loader.FileUtils;
import org.apache.openejb.loader.Files;
import org.apache.openejb.loader.Options;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.observer.Observes;
import org.apache.openejb.util.Duration;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;

public class AutoDeployer {
    private static final Logger logger = Logger.getInstance(LogCategory.OPENEJB_STARTUP, AutoDeployer.class);
    private static final Semaphore SEMAPHORE = new Semaphore(1, true);
    private final ConfigurationFactory factory;
    private final long pollIntervalMillis;
    private final Map<String, FileInfo> files = new HashMap<String, FileInfo>();
    private final Timer timer;
    private final List<Deployments> deployments = new ArrayList<Deployments>();

    public AutoDeployer(ConfigurationFactory factory, List<Deployments> deployments) {
        Options options = SystemInstance.get().getOptions();
        Duration interval = options.get("openejb.autodeploy.interval", new Duration(2L, TimeUnit.SECONDS));
        if (interval.getUnit() == null) {
            interval.setUnit(TimeUnit.SECONDS);
        }
        this.factory = factory;
        this.deployments.addAll(deployments);
        this.pollIntervalMillis = interval.getUnit().toMillis(interval.getTime());
        this.timer = new Timer(this.getClass().getSimpleName(), true);
    }

    private boolean fileAdded(File file) {
        String appPath = file.getAbsolutePath();
        logger.info("Starting Auto-Deployment of: " + appPath);
        try {
            Assembler assembler;
            AppInfo appInfo = this.factory.configureApplication(file);
            appInfo.paths.add(appPath);
            appInfo.paths.add(appInfo.path);
            if (logger.isDebugEnabled()) {
                for (String path : appInfo.paths) {
                    logger.debug("Auto-Deployment path: " + path);
                }
            }
            if (null == (assembler = AutoDeployer.getAssembler())) {
                throw new Exception("Assembler is not available for Auto-Deployment of: " + appPath);
            }
            assembler.createApplication(appInfo);
            this.files.get(appPath).setModified(AutoDeployer.getLastModifiedInDir(new File(appPath)));
        }
        catch (Exception e) {
            logger.error("Failed Auto-Deployment of: " + appPath, e);
        }
        return true;
    }

    private static Assembler getAssembler() {
        return SystemInstance.get().getComponent(Assembler.class);
    }

    private static boolean fileRemoved(File file) {
        if (null == file) {
            return true;
        }
        String path = file.getAbsolutePath();
        Assembler assembler = AutoDeployer.getAssembler();
        if (null != assembler) {
            Collection<AppInfo> apps = assembler.getDeployedApplications();
            for (AppInfo app : apps) {
                if (!app.paths.contains(path)) continue;
                logger.info("Starting Auto-Undeployment of: " + app.appId + " - " + file.getAbsolutePath());
                try {
                    assembler.destroyApplication(app);
                    for (String location : app.paths) {
                        if (new File(location).equals(file)) continue;
                        File delete = new File(location.replace("%20", " ").replace("%23", "#"));
                        for (int i = 0; i < 3; ++i) {
                            try {
                                Files.remove(delete);
                                break;
                            }
                            catch (Exception e) {
                                if (i < 2) {
                                    Thread.sleep(100L);
                                    continue;
                                }
                                logger.warning("Failed to delete: " + delete);
                                continue;
                            }
                        }
                        logger.debug("Auto-Undeploy: Delete " + location);
                    }
                    logger.info("Completed Auto-Undeployment of: " + app.appId);
                }
                catch (Throwable e) {
                    logger.error("Auto-Undeploy Failed: " + file.getAbsolutePath(), e);
                }
                break;
            }
        }
        return true;
    }

    public void fileUpdated(File file) {
        AutoDeployer.fileRemoved(file);
        this.fileAdded(file);
    }

    public void observe(@Observes ContainerSystemPostCreate postCreate) {
        this.start();
    }

    public void observe(@Observes ContainerSystemPreDestroy preDestroy) {
        this.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        this.timer.cancel();
        try {
            SEMAPHORE.acquire();
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            SEMAPHORE.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        try {
            SEMAPHORE.acquire();
        }
        catch (InterruptedException e) {
            logger.warning("AutoDeployer.start failed to obtain lock");
            return;
        }
        try {
            this.initialize();
            logger.info("Starting Auto-Deployer with a polling interval of " + this.pollIntervalMillis + "ms");
            this.timer.scheduleAtFixedRate(new TimerTask(){

                @Override
                public void run() {
                    try {
                        AutoDeployer.this.scan();
                    }
                    catch (Exception e) {
                        logger.error("Scan failed.", e);
                    }
                }
            }, this.pollIntervalMillis, this.pollIntervalMillis);
        }
        finally {
            SEMAPHORE.release();
        }
    }

    private void initialize() {
        for (File file : this.list()) {
            if (!file.canRead()) continue;
            FileInfo now = this.newInfo(file);
            now.setChanging(false);
            now.setNewFile(false);
            logger.debug("Auto-Deployer initialization found: " + file.getAbsolutePath());
        }
    }

    private FileInfo newInfo(File child) {
        FileInfo fileInfo = child.isDirectory() ? new DirectoryInfo(child) : new FileInfo(child);
        this.files.put(fileInfo.getPath(), fileInfo);
        return fileInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void scan() {
        try {
            SEMAPHORE.acquire();
        }
        catch (InterruptedException e) {
            logger.warning("AutoDeployer.scan failed to obtain lock");
            return;
        }
        try {
            List<File> files = this.list();
            HashSet<String> missingFilesList = new HashSet<String>(this.files.keySet());
            for (File file : files) {
                missingFilesList.remove(file.getAbsolutePath());
                if (!file.canRead()) {
                    logger.debug("not readable " + file.getName());
                    continue;
                }
                FileInfo oldStatus = this.oldInfo(file);
                FileInfo newStatus = this.newInfo(file);
                newStatus.diff(oldStatus);
                if (oldStatus == null) {
                    logger.debug("File Discovered: " + newStatus);
                    continue;
                }
                if (newStatus.isChanging()) {
                    logger.debug("File Changing: " + newStatus);
                    continue;
                }
                if (oldStatus.isNewFile()) {
                    logger.info("New File: " + newStatus);
                    newStatus.setNewFile(!this.fileAdded(file));
                    newStatus.setChanging(false);
                    continue;
                }
                if (!oldStatus.isChanging()) continue;
                logger.info("Updated Auto-Deployer File: " + newStatus);
                this.fileUpdated(file);
                missingFilesList.remove(oldStatus.getPath());
            }
            for (String path : missingFilesList) {
                logger.info("File removed: " + path);
                if (!AutoDeployer.fileRemoved(new File(path))) continue;
                this.files.remove(path);
            }
        }
        finally {
            SEMAPHORE.release();
        }
    }

    private List<File> list() {
        ArrayList<File> files = new ArrayList<File>();
        FileUtils base = SystemInstance.get().getBase();
        for (Deployments deployment : this.deployments) {
            DeploymentsResolver.loadFrom(deployment, base, files);
        }
        return files;
    }

    private FileInfo oldInfo(File file) {
        return this.files.get(file.getAbsolutePath());
    }

    public static long getLastModifiedInDir(File dir) {
        assert (dir != null);
        if (dir.isFile()) {
            return dir.lastModified();
        }
        long value = dir.lastModified();
        File[] children = dir.listFiles();
        if (children != null) {
            for (File child : children) {
                long test;
                if (!child.canRead()) continue;
                if (child.isDirectory()) {
                    if (new File(child.getParentFile(), child.getName() + ".war").exists()) continue;
                    test = AutoDeployer.getLastModifiedInDir(child);
                } else {
                    test = child.lastModified();
                }
                if (test <= value) continue;
                value = test;
            }
        }
        return value;
    }

    private static class FileInfo
    implements Serializable {
        private final String path;
        private long size;
        private long modified;
        private boolean newFile;
        private boolean changing;

        public FileInfo(File file) {
            this(file.getAbsolutePath(), file.length(), file.lastModified());
        }

        public FileInfo(String path, long size, long modified) {
            assert (path != null);
            this.path = path;
            this.size = size;
            this.modified = modified;
            this.newFile = true;
            this.changing = true;
        }

        public String getPath() {
            return this.path;
        }

        public long getSize() {
            return this.size;
        }

        public void setSize(long size) {
            this.size = size;
        }

        public long getModified() {
            return this.modified;
        }

        public void setModified(long modified) {
            this.modified = modified;
        }

        public boolean isNewFile() {
            return this.newFile;
        }

        public void setNewFile(boolean newFile) {
            this.newFile = newFile;
        }

        public boolean isChanging() {
            return this.changing;
        }

        public void setChanging(boolean changing) {
            this.changing = changing;
        }

        public boolean isSame(FileInfo info) {
            assert (info != null);
            if (!this.path.equals(info.path)) {
                throw new IllegalArgumentException("Should only be used to compare two files representing the same path!");
            }
            return this.size == info.size && this.modified == info.modified;
        }

        public String toString() {
            return this.path;
        }

        public void diff(FileInfo old) {
            if (old != null) {
                this.changing = !this.isSame(old);
                this.newFile = old.newFile;
            }
        }
    }

    private static class DirectoryInfo
    extends FileInfo {
        public DirectoryInfo(File dir) {
            super(dir.getAbsolutePath(), 0L, AutoDeployer.getLastModifiedInDir(dir));
        }
    }
}

