/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb;

import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.LogManager;
import javax.ejb.EJBException;
import javax.ejb.embeddable.EJBContainer;
import javax.ejb.spi.EJBContainerProvider;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpSession;
import org.apache.openejb.AppContext;
import org.apache.openejb.Injector;
import org.apache.openejb.OpenEJB;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.UndeployException;
import org.apache.openejb.assembler.classic.AppInfo;
import org.apache.openejb.assembler.classic.Assembler;
import org.apache.openejb.cdi.ScopeHelper;
import org.apache.openejb.config.AppModule;
import org.apache.openejb.config.ConfigurationFactory;
import org.apache.openejb.config.ConnectorModule;
import org.apache.openejb.config.EjbModule;
import org.apache.openejb.config.PersistenceModule;
import org.apache.openejb.jee.Application;
import org.apache.openejb.jee.Beans;
import org.apache.openejb.jee.Connector;
import org.apache.openejb.jee.EjbJar;
import org.apache.openejb.jee.EnterpriseBean;
import org.apache.openejb.jee.jpa.unit.Persistence;
import org.apache.openejb.jee.jpa.unit.PersistenceUnit;
import org.apache.openejb.loader.Options;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.util.Exceptions;
import org.apache.openejb.util.Join;
import org.apache.openejb.util.JuliLogStreamFactory;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.openejb.util.ServiceManagerProxy;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.web.lifecycle.test.MockHttpSession;
import org.apache.webbeans.web.lifecycle.test.MockServletContext;
import org.apache.xbean.naming.context.ContextFlyweight;

public final class OpenEjbContainer
extends EJBContainer {
    private static final ReentrantLock LOCK;
    public static final String OPENEJB_EMBEDDED_REMOTABLE = "openejb.embedded.remotable";
    public static final String OPENEJB_EJBCONTAINER_CLOSE = "openejb.ejbcontainer.close";
    public static final String OPENEJB_EJBCONTAINER_CLOSE_SINGLE = "single-jvm";
    private static volatile OpenEjbContainer instance;
    private static Logger logger;
    private ServiceManagerProxy serviceManager;
    private final Options options;
    private final GlobalContext globalJndiContext;
    private final WebBeansContext webBeanContext;
    private final ServletContext servletContext;
    private final HttpSession session;

    private OpenEjbContainer(Map<?, ?> map, AppContext appContext) {
        this.webBeanContext = appContext.getWebBeansContext();
        this.globalJndiContext = new GlobalContext(appContext.getGlobalJndiContext());
        Properties properties = new Properties();
        properties.putAll(map);
        this.options = new Options(properties);
        this.startNetworkServices();
        this.servletContext = new MockServletContext();
        this.session = new MockHttpSession();
        try {
            ScopeHelper.startContexts(this.webBeanContext.getContextsService(), this.servletContext, this.session);
        }
        catch (Exception e) {
            OpenEjbContainer.logger().warning("can't start all CDI contexts", e);
        }
    }

    private static boolean isSingleClose() {
        return OPENEJB_EJBCONTAINER_CLOSE_SINGLE.equals(SystemInstance.get().getProperty(OPENEJB_EJBCONTAINER_CLOSE, "by-invocation"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doClose() {
        ReentrantLock lock = LOCK;
        lock.lock();
        Logger log = OpenEjbContainer.logger();
        if (log.isDebugEnabled()) {
            StackTraceElement[] stackTrace;
            for (StackTraceElement element : stackTrace = Thread.currentThread().getStackTrace()) {
                log.debug("Called by: " + element);
            }
        }
        try {
            if (instance == null) {
                return;
            }
            if (this.serviceManager != null) {
                this.serviceManager.stop();
            }
            try {
                this.globalJndiContext.close();
            }
            catch (NamingException e) {
                throw new IllegalStateException(e);
            }
            Assembler assembler = SystemInstance.get().getComponent(Assembler.class);
            if (assembler != null) {
                for (AppInfo info : assembler.getDeployedApplications()) {
                    try {
                        assembler.destroyApplication(info);
                    }
                    catch (UndeployException e) {
                        log.error(e.getMessage(), e);
                    }
                }
            }
            try {
                ScopeHelper.stopContexts(this.webBeanContext.getContextsService(), this.servletContext, this.session);
            }
            catch (Exception e) {
                log.warning("can't stop all CDI contexts", e);
            }
            log.info("Destroying OpenEJB container");
            OpenEJB.destroy();
            instance = null;
        }
        finally {
            lock.unlock();
        }
    }

    public Context getContext() {
        return this.globalJndiContext;
    }

    private void startNetworkServices() {
        if (!this.options.get(OPENEJB_EMBEDDED_REMOTABLE, false)) {
            return;
        }
        try {
            this.serviceManager = new ServiceManagerProxy();
            this.serviceManager.start();
        }
        catch (ServiceManagerProxy.AlreadyStartedException e) {
            OpenEjbContainer.logger().debug("Network services already started.  Ignoring option openejb.embedded.remotable");
        }
    }

    private static Logger logger() {
        if (logger == null) {
            logger = Logger.getInstance(LogCategory.OPENEJB_STARTUP, OpenEjbContainer.class);
        }
        return logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        ReentrantLock lock = LOCK;
        lock.lock();
        try {
            if (OpenEjbContainer.isSingleClose()) {
                return;
            }
            this.doClose();
        }
        finally {
            lock.unlock();
        }
    }

    static /* synthetic */ ReentrantLock access$000() {
        return LOCK;
    }

    static /* synthetic */ boolean access$200() {
        return OpenEjbContainer.isSingleClose();
    }

    static /* synthetic */ Logger access$300() {
        return OpenEjbContainer.logger();
    }

    static /* synthetic */ OpenEjbContainer access$102(OpenEjbContainer x0) {
        instance = x0;
        return instance;
    }

    static {
        String logManger = System.getProperty("java.util.logging.manager");
        if (logManger != null) {
            try {
                Thread.currentThread().getContextClassLoader().loadClass(logManger);
            }
            catch (Exception ignored) {
                try {
                    Field field = LogManager.class.getDeclaredField("manager");
                    field.setAccessible(true);
                    field.set(null, new JuliLogStreamFactory.OpenEJBLogManager());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        LOCK = new ReentrantLock();
    }

    public static class InvalidApplicationException
    extends InitializationException {
        public InvalidApplicationException(Exception cause) {
            super(cause);
        }
    }

    public static class AssembleApplicationException
    extends InitializationException {
        public AssembleApplicationException(Exception cause) {
            super(cause);
        }
    }

    public static class ConfigureApplicationException
    extends InitializationException {
        public ConfigureApplicationException(Exception cause) {
            super(cause);
        }
    }

    public static class NoModulesFoundException
    extends InitializationException {
        public NoModulesFoundException(String s) {
            super(s);
        }
    }

    public static class NoSuchModuleException
    extends InitializationException {
        public NoSuchModuleException(String s) {
            super(s);
        }
    }

    public static class InvalidModulesPropertyException
    extends InitializationException {
        public InvalidModulesPropertyException(String s) {
            super(s);
        }
    }

    public static class InitializationException
    extends EJBException {
        public InitializationException(String s) {
            super(s);
        }

        public InitializationException(Exception cause) {
            super(cause);
        }
    }

    private class GlobalContext
    extends ContextFlyweight {
        private final Context globalJndiContext;

        public GlobalContext(Context globalJndiContext) {
            this.globalJndiContext = globalJndiContext;
        }

        protected Context getContext() throws NamingException {
            return this.globalJndiContext;
        }

        protected Name getName(Name name) throws NamingException {
            String first = name.get(0);
            if (!first.startsWith("java:")) {
                throw new NameNotFoundException("Name must be in java: namespace");
            }
            first = first.substring("java:".length());
            name = name.getSuffix(1);
            return name.add(0, first);
        }

        protected String getName(String name) throws NamingException {
            if ("inject".equals(name)) {
                return name;
            }
            if (!name.startsWith("java:")) {
                throw new NameNotFoundException("Name must be in java: namespace");
            }
            return name.substring("java:".length());
        }

        public void bind(Name name, Object obj) throws NamingException {
            if (name.size() == 1 && "inject".equals(name.get(0))) {
                Injector.inject(obj);
            } else {
                super.bind(name, obj);
            }
        }

        public void bind(String name, Object obj) throws NamingException {
            if (name != null && "inject".equals(name)) {
                Injector.inject(obj);
            } else {
                super.bind(name, obj);
            }
        }

        public void unbind(Name name) throws NamingException {
            if (name.size() != 1 || !"inject".equals(name.get(0))) {
                super.unbind(name);
            }
        }

        public void unbind(String name) throws NamingException {
            if (name == null || !"inject".equals(name)) {
                super.unbind(name);
            }
        }
    }

    public static class Provider
    implements EJBContainerProvider {
        public static final String OPENEJB_ADDITIONNAL_CALLERS_KEY = "openejb.additionnal.callers";

        /*
         * Exception decompiling
         */
        public EJBContainer createEJBContainer(Map<?, ?> map) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [15[CATCHBLOCK]], but top level block is 7[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private boolean isValid(String caller) {
            try {
                ClassLoader loader = Thread.currentThread().getContextClassLoader();
                Class<?> clazz = loader.loadClass(caller);
                int modifiers = clazz.getModifiers();
                return !clazz.isEnum() && !clazz.isInterface() && !Modifier.isAbstract(modifiers);
            }
            catch (ClassNotFoundException e) {
                return false;
            }
        }

        private AppModule load(Map<?, ?> map, ConfigurationFactory configurationFactory) throws MalformedURLException, OpenEJBException {
            List<File> moduleLocations;
            String appId = (String)map.get("javax.ejb.embeddable.appName");
            Object modules = map.get("javax.ejb.embeddable.modules");
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            if (modules instanceof String) {
                moduleLocations = configurationFactory.getModulesFromClassPath(null, classLoader);
                Iterator i = moduleLocations.iterator();
                while (i.hasNext()) {
                    File file = (File)i.next();
                    if (this.match((String)modules, file)) continue;
                    i.remove();
                }
            } else if (modules instanceof String[]) {
                moduleLocations = configurationFactory.getModulesFromClassPath(null, classLoader);
                int matched = 0;
                Iterator i = moduleLocations.iterator();
                while (i.hasNext()) {
                    File file = (File)i.next();
                    boolean remove = true;
                    for (String s : (String[])modules) {
                        if (!this.match(s, file)) continue;
                        remove = false;
                        ++matched;
                        break;
                    }
                    if (!remove) continue;
                    i.remove();
                }
                if (matched != ((String[])modules).length) {
                    throw this.specifiedModulesNotFound();
                }
            } else if (modules instanceof File) {
                URL url = ((File)modules).toURI().toURL();
                classLoader = new URLClassLoader(new URL[]{url}, classLoader);
                moduleLocations = Collections.singletonList((File)modules);
            } else if (modules instanceof File[]) {
                File[] files = (File[])modules;
                URL[] urls = new URL[files.length];
                for (int i = 0; i < urls.length; ++i) {
                    urls[i] = files[i].toURI().toURL();
                }
                classLoader = new URLClassLoader(urls, classLoader);
                moduleLocations = Arrays.asList((File[])modules);
            } else if (modules == null) {
                moduleLocations = configurationFactory.getModulesFromClassPath(null, classLoader);
            } else {
                AppModule appModule = this.load(map);
                if (appModule != null) {
                    return appModule;
                }
                throw this.invalidModulesValue(modules);
            }
            if (moduleLocations.isEmpty()) {
                throw Exceptions.newNoModulesFoundException();
            }
            return configurationFactory.loadApplication(classLoader, appId, moduleLocations);
        }

        private AppModule load(Map<?, ?> map) {
            String appId = (String)map.get("javax.ejb.embeddable.appName");
            Object modules = map.get("javax.ejb.embeddable.modules");
            map.size();
            Application application = null;
            AppModule appModule = new AppModule(this.getClass().getClassLoader(), appId);
            if (modules instanceof EjbJar) {
                EjbJar ejbJar = (EjbJar)modules;
                appModule.getEjbModules().add(new EjbModule(ejbJar));
            } else if (modules instanceof EnterpriseBean) {
                EnterpriseBean bean = (EnterpriseBean)modules;
                EjbJar ejbJar = new EjbJar();
                ejbJar.addEnterpriseBean(bean);
                appModule.getEjbModules().add(new EjbModule(ejbJar));
            } else if (modules instanceof Application) {
                application = (Application)modules;
            } else if (modules instanceof Connector) {
                Connector connector = (Connector)modules;
                appModule.getConnectorModules().add(new ConnectorModule(connector));
            } else if (modules instanceof Persistence) {
                Persistence persistence = (Persistence)modules;
                appModule.addPersistenceModule(new PersistenceModule(appModule, "", persistence));
            } else if (modules instanceof PersistenceUnit) {
                PersistenceUnit unit = (PersistenceUnit)modules;
                appModule.addPersistenceModule(new PersistenceModule(appModule, "", new Persistence(new PersistenceUnit[]{unit})));
            } else if (modules instanceof Beans) {
                Beans beans = (Beans)modules;
                EjbModule ejbModule = new EjbModule(new EjbJar());
                ejbModule.setBeans(beans);
                appModule.getEjbModules().add(ejbModule);
            }
            if (application != null) {
                AppModule newModule = new AppModule(appModule.getClassLoader(), appModule.getModuleId(), application, false);
                newModule.getClientModules().addAll(appModule.getClientModules());
                newModule.addPersistenceModules(appModule.getPersistenceModules());
                newModule.getEjbModules().addAll(appModule.getEjbModules());
                newModule.getConnectorModules().addAll(appModule.getConnectorModules());
                appModule = newModule;
            }
            AppModule m = appModule;
            return m;
        }

        private EJBException specifiedModulesNotFound() {
            return new NoSuchModuleException("some modules not matched on classpath");
        }

        private InvalidModulesPropertyException invalidModulesValue(Object value) {
            Object[] spec = new String[]{"java.lang.String", "java.lang.String[]", "java.io.File", "java.io.File[]"};
            String type = value == null ? null : value.getClass().getName();
            return new InvalidModulesPropertyException(String.format("Invalid '%s' value '%s'. Valid values are: %s", "javax.ejb.embeddable.modules", type, Join.join(", ", spec)));
        }

        private static boolean isOtherProvider(Map<?, ?> properties) {
            Object provider = properties.get("javax.ejb.embeddable.provider");
            return provider != null && !provider.equals(OpenEjbContainer.class) && !provider.equals(OpenEjbContainer.class.getName()) && !"openejb".equals(provider);
        }

        private boolean match(String s, File file) {
            String s2 = file.getName();
            String s3 = file.getAbsolutePath();
            boolean matches = file.isDirectory() ? s2.equals(s) || s2.equals(s + ".jar") || s3.equals(s) : s2.equals(s + ".jar");
            return matches;
        }
    }
}

