/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.client;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.net.ConnectException;
import java.net.URI;
import java.net.URISyntaxException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.mail.Session;
import javax.naming.AuthenticationException;
import javax.naming.Binding;
import javax.naming.CompoundName;
import javax.naming.ConfigurationException;
import javax.naming.Context;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import javax.naming.Reference;
import javax.naming.ServiceUnavailableException;
import javax.naming.spi.InitialContextFactory;
import javax.naming.spi.NamingManager;
import javax.sql.DataSource;
import org.apache.openejb.client.AuthenticationRequest;
import org.apache.openejb.client.AuthenticationResponse;
import org.apache.openejb.client.Client;
import org.apache.openejb.client.ClientDataSource;
import org.apache.openejb.client.ClientInstance;
import org.apache.openejb.client.ClientMetaData;
import org.apache.openejb.client.ClientRuntimeException;
import org.apache.openejb.client.DataSourceMetaData;
import org.apache.openejb.client.EJBHomeHandler;
import org.apache.openejb.client.EJBHomeProxy;
import org.apache.openejb.client.EJBMetaDataImpl;
import org.apache.openejb.client.EJBObjectHandler;
import org.apache.openejb.client.JNDIRequest;
import org.apache.openejb.client.JNDIResponse;
import org.apache.openejb.client.NameClassPairEnumeration;
import org.apache.openejb.client.RequestMethodCode;
import org.apache.openejb.client.ServerMetaData;
import org.apache.openejb.client.ThrowableArtifact;
import org.apache.openejb.client.WsMetaData;
import org.apache.openejb.client.event.RemoteInitialContextCreated;
import org.apache.openejb.client.serializer.EJBDSerializer;
import org.omg.CORBA.ORB;

public class JNDIContext
implements InitialContextFactory,
Context {
    private static final Logger LOGGER;
    public static final String DEFAULT_PROVIDER_URL = "ejbd://localhost:4201";
    public static final String SERIALIZER = "openejb.ejbd.serializer";
    public static final String AUTHENTICATE_WITH_THE_REQUEST = "openejb.ejbd.authenticate-with-request";
    public static final String POOL_QUEUE_SIZE = "openejb.client.invoker.queue";
    public static final String POOL_THREAD_NUMBER = "openejb.client.invoker.threads";
    public static final String AUTHENTICATION_REALM_NAME = "openejb.authentication.realmName";
    public static final String IDENTITY_TIMEOUT = "tomee.authentication.identity.timeout";
    private final AtomicBoolean isShutdown = new AtomicBoolean(false);
    private String tail = "/";
    private ServerMetaData server;
    private ClientMetaData client;
    private Hashtable env;
    private String moduleId;
    private ClientInstance clientIdentity;
    private static final ThreadPoolExecutor GLOBAL_CLIENT_POOL;
    private AuthenticationInfo authenticationInfo = null;
    private transient int threads;
    private transient LinkedBlockingQueue<Runnable> blockingQueue;
    protected transient ThreadPoolExecutor executorService;

    public static ThreadPoolExecutor globalExecutor() {
        return GLOBAL_CLIENT_POOL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ThreadPoolExecutor executor() {
        if (this.executorService != null) {
            return this.executorService;
        }
        if (this.threads < 0) {
            return GLOBAL_CLIENT_POOL;
        }
        JNDIContext jNDIContext = this;
        synchronized (jNDIContext) {
            if (this.executorService != null) {
                return this.executorService;
            }
            this.executorService = JNDIContext.newExecutor(this.threads, this.blockingQueue);
        }
        return this.executorService;
    }

    public static ThreadPoolExecutor newExecutor(int threads, BlockingQueue<Runnable> blockingQueue) {
        ThreadPoolExecutor executorService = new ThreadPoolExecutor(3, threads < 3 ? 3 : threads, 1L, TimeUnit.MINUTES, blockingQueue == null ? new LinkedBlockingDeque(Integer.parseInt(JNDIContext.getProperty(null, POOL_QUEUE_SIZE, "2"))) : blockingQueue);
        executorService.setThreadFactory(new ThreadFactory(){
            private final AtomicInteger i = new AtomicInteger(0);

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r, "OpenEJB.Client." + this.i.incrementAndGet());
                t.setDaemon(true);
                t.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                    @Override
                    public void uncaughtException(Thread t, Throwable e) {
                        Logger.getLogger(EJBObjectHandler.class.getName()).log(Level.SEVERE, "Uncaught error in: " + t.getName(), e);
                    }
                });
                return t;
            }
        });
        executorService.setRejectedExecutionHandler(new RejectedExecutionHandler(){

            @Override
            public void rejectedExecution(Runnable r, ThreadPoolExecutor tpe) {
                if (null == r || null == tpe || tpe.isShutdown() || tpe.isTerminated() || tpe.isTerminating()) {
                    return;
                }
                Logger log = Logger.getLogger(EJBObjectHandler.class.getName());
                if (log.isLoggable(Level.WARNING)) {
                    log.log(Level.WARNING, "EJBObjectHandler ExecutorService at capacity for process: " + r);
                }
                boolean offer = false;
                try {
                    offer = tpe.getQueue().offer(r, 10L, TimeUnit.SECONDS);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (!offer) {
                    log.log(Level.SEVERE, "EJBObjectHandler ExecutorService failed to run asynchronous process: " + r);
                }
            }
        });
        return executorService;
    }

    public JNDIContext() {
    }

    public JNDIContext(JNDIContext that) {
        this.tail = that.tail;
        this.server = that.server;
        this.client = that.client;
        this.moduleId = that.moduleId;
        this.env = (Hashtable)that.env.clone();
        this.clientIdentity = that.clientIdentity;
    }

    private JNDIResponse request(JNDIRequest req) throws Exception {
        req.setServerHash(this.server.buildHash());
        JNDIResponse response = new JNDIResponse();
        Client.request(req, response, this.server);
        if (null != response.getServer()) {
            this.server.merge(response.getServer());
        }
        return response;
    }

    protected AuthenticationResponse requestAuthorization(AuthenticationRequest req) throws RemoteException {
        return (AuthenticationResponse)Client.request(req, new AuthenticationResponse(), this.server);
    }

    public Context getInitialContext(Hashtable environment) throws NamingException {
        URI location;
        if (environment == null) {
            throw new NamingException("Invalid argument, hashtable cannot be null.");
        }
        this.env = (Hashtable)environment.clone();
        String userID = (String)this.env.get("java.naming.security.principal");
        String psswrd = (String)this.env.get("java.naming.security.credentials");
        String providerUrl = (String)this.env.get("java.naming.provider.url");
        boolean authWithRequest = "true".equalsIgnoreCase((String)String.class.cast(this.env.get(AUTHENTICATE_WITH_THE_REQUEST)));
        this.moduleId = (String)this.env.get("openejb.client.moduleId");
        try {
            providerUrl = this.addMissingParts(providerUrl);
            location = new URI(providerUrl);
        }
        catch (URISyntaxException e) {
            throw (ConfigurationException)new ConfigurationException("Property value for java.naming.provider.url invalid: " + providerUrl + " - " + e.getMessage()).initCause(e);
        }
        this.server = new ServerMetaData(location);
        Client.Context context = Client.getContext(this.server);
        context.getProperties().putAll((Map<?, ?>)environment);
        String strategy = context.getOptions().get("openejb.client.connection.strategy", "default");
        context.getClusterMetaData().setConnectionStrategy(strategy);
        Client.fireEvent(new RemoteInitialContextCreated(location));
        if (userID != null) {
            if (!authWithRequest) {
                this.authenticate(userID, psswrd, false);
            } else {
                this.authenticationInfo = new AuthenticationInfo((String)String.class.cast(this.env.get(AUTHENTICATION_REALM_NAME)), userID, psswrd.toCharArray(), this.getTimeout(this.env));
            }
        }
        if (this.client == null) {
            this.client = new ClientMetaData();
        }
        this.seedClientSerializer();
        int queue = Integer.parseInt(JNDIContext.getProperty(this.env, POOL_QUEUE_SIZE, "2"));
        this.blockingQueue = new LinkedBlockingQueue(queue < 2 ? 2 : queue);
        this.threads = Integer.parseInt(JNDIContext.getProperty(this.env, POOL_THREAD_NUMBER, "-1"));
        return this;
    }

    private void seedClientSerializer() {
        String serializer = (String)this.env.get(SERIALIZER);
        if (serializer != null) {
            try {
                this.client.setSerializer((EJBDSerializer)EJBDSerializer.class.cast(Thread.currentThread().getContextClassLoader().loadClass(serializer).newInstance()));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private long getTimeout(Hashtable env) {
        Long l;
        Object o = env.get(IDENTITY_TIMEOUT);
        if (null != o && null != (l = (Long)Long.class.cast(o))) {
            return l;
        }
        return 0L;
    }

    private static String getProperty(Hashtable env, String key, String defaultValue) {
        Object value;
        Object object = value = env == null ? null : (Object)env.get(key);
        if (value != null) {
            return value.toString();
        }
        return System.getProperty(key, defaultValue);
    }

    String addMissingParts(String providerUrl) throws URISyntaxException {
        int port = Integer.parseInt(System.getProperty("ejbd.port", "4201"));
        if (providerUrl == null || providerUrl.length() == 0) {
            providerUrl = "ejbd://localhost:" + port;
        } else {
            int colonIndex = providerUrl.indexOf(":");
            int slashesIndex = providerUrl.indexOf("//");
            if (colonIndex == -1 && slashesIndex == -1) {
                providerUrl = "ejbd://" + providerUrl + ":" + port;
            } else if (colonIndex == -1) {
                URI providerUri = new URI(providerUrl);
                String scheme = providerUri.getScheme();
                if (!scheme.equals("http") && !scheme.equals("https")) {
                    providerUrl = providerUrl + ":" + port;
                }
            } else if (slashesIndex == -1) {
                providerUrl = "ejbd://" + providerUrl;
            }
        }
        return providerUrl;
    }

    public void authenticate(String userID, String psswrd, boolean logout) throws AuthenticationException {
        AuthenticationResponse res;
        AuthenticationRequest req = new AuthenticationRequest((String)String.class.cast(this.env.get(AUTHENTICATION_REALM_NAME)), userID, psswrd, this.getTimeout(this.env));
        if (logout) {
            req.setLogoutIdentity(null != this.client ? this.client.getClientIdentity() : null);
        }
        try {
            res = this.requestAuthorization(req);
        }
        catch (RemoteException e) {
            throw new AuthenticationException(e.getLocalizedMessage());
        }
        switch (res.getResponseCode()) {
            case 1: {
                this.client = logout ? new ClientMetaData() : res.getIdentity();
                break;
            }
            case 2: {
                this.client = logout ? new ClientMetaData() : res.getIdentity();
                this.server = res.getServer();
                break;
            }
            case 3: {
                throw (AuthenticationException)new AuthenticationException("This principle is not authorized.").initCause(res.getDeniedCause());
            }
        }
        this.seedClientSerializer();
    }

    public EJBHomeProxy createEJBHomeProxy(EJBMetaDataImpl ejbData) {
        EJBHomeHandler handler = EJBHomeHandler.createEJBHomeHandler(this.executor(), ejbData, this.server, this.client, this.authenticationInfo);
        EJBHomeProxy proxy = handler.createEJBHomeProxy();
        handler.ejb.ejbHomeProxy = proxy;
        return proxy;
    }

    private Object createBusinessObject(Object result) {
        EJBMetaDataImpl ejb = (EJBMetaDataImpl)result;
        Object primaryKey = ejb.getPrimaryKey();
        EJBObjectHandler handler = EJBObjectHandler.createEJBObjectHandler(this.executor(), ejb, this.server, this.client, primaryKey, this.authenticationInfo);
        return handler.createEJBObjectProxy();
    }

    @Override
    public Object lookup(String name) throws NamingException {
        JNDIResponse res;
        this.checkState();
        if (name == null) {
            throw new InvalidNameException("The name cannot be null");
        }
        if (name.equals("")) {
            return new JNDIContext(this);
        }
        if (name.startsWith("java:")) {
            name = name.replaceFirst("^java:", "");
        } else if (!name.startsWith("/")) {
            name = this.tail + name;
        }
        String prop = name.replaceFirst("comp/env/", "");
        String value = System.getProperty(prop);
        if (value != null) {
            return this.parseEntry(prop, value);
        }
        if (name.equals("comp/ORB")) {
            return this.getDefaultOrb();
        }
        JNDIRequest req = new JNDIRequest();
        req.setRequestMethod(RequestMethodCode.JNDI_LOOKUP);
        req.setRequestString(name);
        req.setModuleId(this.moduleId);
        try {
            res = this.request(req);
        }
        catch (Exception e) {
            if (e instanceof RemoteException) {
                if (e.getCause() instanceof ConnectException) {
                    e = (Exception)e.getCause();
                    throw (ServiceUnavailableException)new ServiceUnavailableException("Cannot lookup '" + name + "'.").initCause(e);
                }
                if (AuthenticationException.class.isInstance(e.getCause())) {
                    throw (AuthenticationException)AuthenticationException.class.cast(e.getCause());
                }
            }
            throw (NamingException)new NamingException("Cannot lookup '" + name + "'.").initCause(e);
        }
        switch (res.getResponseCode()) {
            case 13: {
                return this.createEJBHomeProxy((EJBMetaDataImpl)res.getResult());
            }
            case 21: {
                return this.createBusinessObject(res.getResult());
            }
            case 12: {
                return res.getResult();
            }
            case 23: {
                return res.getResult();
            }
            case 14: {
                JNDIContext subCtx = new JNDIContext(this);
                if (!name.endsWith("/")) {
                    name = name + '/';
                }
                subCtx.tail = name;
                return subCtx;
            }
            case 22: {
                return this.createDataSource((DataSourceMetaData)res.getResult());
            }
            case 25: {
                return this.createWebservice((WsMetaData)res.getResult());
            }
            case 24: {
                String type = (String)res.getResult();
                value = System.getProperty("Resource/" + type);
                if (value == null) {
                    return null;
                }
                return this.parseEntry(prop, value);
            }
            case 26: {
                Reference ref = (Reference)res.getResult();
                try {
                    return NamingManager.getObjectInstance(ref, this.getNameParser(name).parse(name), this, this.env);
                }
                catch (Exception e) {
                    throw (NamingException)new NamingException("Could not dereference " + ref).initCause(e);
                }
            }
            case 16: {
                throw new NameNotFoundException(name + " does not exist in the system.  Check that the app was successfully deployed.");
            }
            case 17: {
                Throwable throwable = ((ThrowableArtifact)res.getResult()).getThrowable();
                if (throwable instanceof NamingException) {
                    throw (NamingException)throwable;
                }
                throw (NamingException)new NamingException().initCause(throwable);
            }
            case 18: {
                throw (RuntimeException)res.getResult();
            }
            case 19: {
                throw (Error)res.getResult();
            }
        }
        throw new ClientRuntimeException("Invalid response from server: " + res.getResponseCode());
    }

    private Object parseEntry(String name, String value) throws NamingException {
        try {
            URI uri = new URI(value);
            String scheme = uri.getScheme();
            if (scheme.equals("link")) {
                value = System.getProperty(uri.getSchemeSpecificPart());
                if (value == null) {
                    return null;
                }
                return this.parseEntry(name, value);
            }
            if (scheme.equals("datasource")) {
                uri = new URI(uri.getSchemeSpecificPart());
                String driver = uri.getScheme();
                String url = uri.getSchemeSpecificPart();
                return new ClientDataSource(driver, url, null, null);
            }
            if (scheme.equals("connectionfactory")) {
                return this.build(uri);
            }
            if (scheme.equals("javamail")) {
                return Session.getDefaultInstance((Properties)new Properties());
            }
            if (scheme.equals("orb")) {
                return this.getDefaultOrb();
            }
            if (scheme.equals("queue")) {
                return this.build(uri);
            }
            if (scheme.equals("topic")) {
                return this.build(uri);
            }
            throw new UnsupportedOperationException("Unsupported Naming URI scheme '" + scheme + "'");
        }
        catch (URISyntaxException e) {
            throw (NamingException)new NamingException("Unparsable jndi entry '" + name + "=" + value + "'.  Exception: " + e.getMessage()).initCause(e);
        }
    }

    private Object build(URI inputUri) throws URISyntaxException {
        URI uri = new URI(inputUri.getSchemeSpecificPart());
        String driver = uri.getScheme();
        String url = uri.getSchemeSpecificPart();
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            this.getClass().getClassLoader();
        }
        if (classLoader == null) {
            ClassLoader.getSystemClassLoader();
        }
        try {
            Class<?> clazz = Class.forName(driver, true, classLoader);
            Constructor<?> constructor = clazz.getConstructor(String.class);
            return constructor.newInstance(url);
        }
        catch (Exception e) {
            throw new IllegalStateException("Cannot use " + driver + " with parameter " + url, e);
        }
    }

    private DataSource createDataSource(DataSourceMetaData dataSourceMetaData) {
        return new ClientDataSource(dataSourceMetaData);
    }

    private Object createWebservice(WsMetaData webserviceMetaData) throws NamingException {
        try {
            return webserviceMetaData.createWebservice();
        }
        catch (Exception e) {
            throw (NamingException)new NamingException("Error creating webservice").initCause(e);
        }
    }

    private ORB getDefaultOrb() {
        return ORB.init();
    }

    @Override
    public Object lookup(Name name) throws NamingException {
        return this.lookup(name.toString());
    }

    @Override
    public NamingEnumeration<NameClassPair> list(String name) throws NamingException {
        JNDIResponse res;
        this.checkState();
        if (name == null) {
            throw new InvalidNameException("The name cannot be null");
        }
        if (name.startsWith("java:")) {
            name = name.replaceFirst("^java:", "");
        } else if (!name.startsWith("/")) {
            name = this.tail + name;
        }
        JNDIRequest req = new JNDIRequest(RequestMethodCode.JNDI_LIST, name);
        req.setModuleId(this.moduleId);
        try {
            res = this.request(req);
        }
        catch (Exception e) {
            if (e instanceof RemoteException && e.getCause() instanceof ConnectException) {
                e = (Exception)e.getCause();
                throw (ServiceUnavailableException)new ServiceUnavailableException("Cannot list '" + name + "'.").initCause(e);
            }
            throw (NamingException)new NamingException("Cannot list '" + name + "'.").initCause(e);
        }
        switch (res.getResponseCode()) {
            case 12: {
                return null;
            }
            case 15: {
                return (NamingEnumeration)res.getResult();
            }
            case 16: {
                throw new NameNotFoundException(name);
            }
            case 17: {
                Throwable throwable = ((ThrowableArtifact)res.getResult()).getThrowable();
                if (throwable instanceof NamingException) {
                    throw (NamingException)throwable;
                }
                throw (NamingException)new NamingException().initCause(throwable);
            }
            case 19: {
                throw (Error)res.getResult();
            }
        }
        throw new ClientRuntimeException("Invalid response from server :" + res.getResponseCode());
    }

    @Override
    public NamingEnumeration<NameClassPair> list(Name name) throws NamingException {
        return this.list(name.toString());
    }

    @Override
    public NamingEnumeration<Binding> listBindings(String name) throws NamingException {
        Object o = this.lookup(name);
        if (o instanceof Context) {
            Context context = (Context)o;
            NamingEnumeration<NameClassPair> enumeration = context.list("");
            ArrayList<NameClassPair> bindings = new ArrayList<NameClassPair>();
            while (enumeration.hasMoreElements()) {
                NameClassPair pair = (NameClassPair)enumeration.nextElement();
                bindings.add(new LazyBinding(pair.getName(), pair.getClassName(), context));
            }
            return new NameClassPairEnumeration<Binding>(bindings);
        }
        return null;
    }

    @Override
    public NamingEnumeration<Binding> listBindings(Name name) throws NamingException {
        return this.listBindings(name.toString());
    }

    @Override
    public Object lookupLink(String name) throws NamingException {
        return this.lookup(name);
    }

    @Override
    public Object lookupLink(Name name) throws NamingException {
        return this.lookupLink(name.toString());
    }

    @Override
    public NameParser getNameParser(String name) throws NamingException {
        return new SimpleNameParser();
    }

    @Override
    public NameParser getNameParser(Name name) throws NamingException {
        return new SimpleNameParser();
    }

    @Override
    public String composeName(String name, String prefix) throws NamingException {
        throw new OperationNotSupportedException("TODO: Needs to be implemented");
    }

    @Override
    public Name composeName(Name name, Name prefix) throws NamingException {
        throw new OperationNotSupportedException("TODO: Needs to be implemented");
    }

    @Override
    public Object addToEnvironment(String key, Object value) throws NamingException {
        return this.env.put(key, value);
    }

    @Override
    public Object removeFromEnvironment(String key) throws NamingException {
        return this.env.remove(key);
    }

    public Hashtable getEnvironment() throws NamingException {
        return (Hashtable)this.env.clone();
    }

    @Override
    public String getNameInNamespace() throws NamingException {
        return "";
    }

    private void checkState() throws NamingException {
        if (this.isShutdown.get()) {
            throw new NamingException("Context has been closed. Please create a new instance.");
        }
    }

    @Override
    public void close() throws NamingException {
        if (this.isShutdown.getAndSet(true)) {
            return;
        }
        JNDIContext.waitForShutdown(this.executorService);
        String userID = (String)this.env.get("java.naming.security.principal");
        if (userID != null) {
            String psswrd = (String)this.env.get("java.naming.security.credentials");
            boolean logout = true;
            try {
                this.authenticate(userID, psswrd, true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static void waitForShutdown(ExecutorService executor) {
        if (executor == null || executor.isShutdown()) {
            return;
        }
        List<Runnable> runnables = executor.shutdownNow();
        for (Runnable r : runnables) {
            try {
                r.run();
            }
            catch (Throwable th) {
                LOGGER.log(Level.SEVERE, th.getMessage(), th);
            }
        }
    }

    @Override
    public void bind(String name, Object obj) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public void bind(Name name, Object obj) throws NamingException {
        this.bind(name.toString(), obj);
    }

    @Override
    public void rebind(String name, Object obj) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public void rebind(Name name, Object obj) throws NamingException {
        this.rebind(name.toString(), obj);
    }

    @Override
    public void unbind(String name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public void unbind(Name name) throws NamingException {
        this.unbind(name.toString());
    }

    @Override
    public void rename(String oldname, String newname) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public void rename(Name oldname, Name newname) throws NamingException {
        this.rename(oldname.toString(), newname.toString());
    }

    @Override
    public void destroySubcontext(String name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public void destroySubcontext(Name name) throws NamingException {
        this.destroySubcontext(name.toString());
    }

    @Override
    public Context createSubcontext(String name) throws NamingException {
        throw new OperationNotSupportedException();
    }

    @Override
    public Context createSubcontext(Name name) throws NamingException {
        return this.createSubcontext(name.toString());
    }

    static {
        Class<?> container;
        LOGGER = Logger.getLogger("OpenEJB.client");
        GLOBAL_CLIENT_POOL = JNDIContext.newExecutor(10, null);
        ClassLoader classLoader = Client.class.getClassLoader();
        try {
            container = Class.forName("org.apache.openejb.OpenEJB", false, classLoader);
        }
        catch (Throwable e) {
            container = null;
        }
        if (classLoader == ClassLoader.getSystemClassLoader() || Boolean.getBoolean("openejb.client.flus-tasks") || container != null && container.getClassLoader() == classLoader) {
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    JNDIContext.waitForShutdown(GLOBAL_CLIENT_POOL);
                }
            });
        }
    }

    public static class AuthenticationInfo
    implements Serializable {
        private static final long serialVersionUID = -8898613592355280735L;
        private final String realm;
        private final String user;
        private final char[] password;
        private final long timeout;

        public AuthenticationInfo(String realm, String user, char[] chars) {
            this(realm, user, chars, 0L);
        }

        public AuthenticationInfo(String realm, String user, char[] password, long timeout) {
            this.realm = realm;
            this.user = user;
            this.password = password;
            this.timeout = timeout;
        }

        public String getRealm() {
            return this.realm;
        }

        public String getUser() {
            return this.user;
        }

        public char[] getPassword() {
            return this.password;
        }

        public long getTimeout() {
            return this.timeout;
        }
    }

    private static final class SimpleNameParser
    implements NameParser {
        private static final Properties PARSER_PROPERTIES = new Properties();

        private SimpleNameParser() {
        }

        @Override
        public Name parse(String name) throws NamingException {
            return new CompoundName(name, PARSER_PROPERTIES);
        }

        static {
            PARSER_PROPERTIES.put("jndi.syntax.direction", "left_to_right");
            PARSER_PROPERTIES.put("jndi.syntax.separator", "/");
        }
    }

    private static class LazyBinding
    extends Binding {
        private static final long serialVersionUID = 1L;
        private RuntimeException failed;
        private final Context context;

        public LazyBinding(String name, String className, Context context) {
            super(name, className, null);
            this.context = context;
        }

        @Override
        public synchronized Object getObject() {
            if (super.getObject() == null) {
                if (this.failed != null) {
                    throw this.failed;
                }
                try {
                    super.setObject(this.context.lookup(this.getName()));
                }
                catch (NamingException e) {
                    this.failed = new ClientRuntimeException("Failed to lazily fetch the binding '" + this.getName() + "'", e);
                    throw this.failed;
                }
            }
            return super.getObject();
        }
    }
}

